/**
 * <copyright>
 * </copyright>
 *
 * $Id: EntityImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.common.extensions.EObjectPropertiesAdapter;
import org.openxma.dsl.core.model.ConditionsBlock;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.PresentableFeature;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Entity</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getSuperType <em>Super Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getAttributeGroups <em>Attribute Groups</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getConditionsBlock <em>Conditions Block</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getRepository <em>Repository</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getKey <em>Key</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getSortOrders <em>Sort Orders</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getRequiredReferences <em>Required References</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.EntityImpl#getRequiredAttributes <em>Required Attributes</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EntityImpl extends ComplexTypeImpl implements Entity {
	/**
	 * The cached value of the '{@link #getSuperType() <em>Super Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSuperType()
	 * @generated
	 * @ordered
	 */
	protected Entity superType;

	/**
	 * The cached value of the '{@link #getAttributeGroups() <em>Attribute Groups</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeGroups()
	 * @generated
	 * @ordered
	 */
	protected EList<AttributeGroup> attributeGroups;

	/**
	 * The cached value of the '{@link #getConditionsBlock() <em>Conditions Block</em>}' containment reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getConditionsBlock()
	 * @generated
	 * @ordered
	 */
	protected ConditionsBlock conditionsBlock;

	/**
	 * @generated NOT
	 */
	private Dao repository;
	/**
	 * @generated NOT
	 */
	private DataView defaultView;
	/**
	 * @generated NOT
	 */
	private AttributeGroup key;


	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.ENTITY;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Entity getObject() {
		return this;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Entity getSuperType() {
		if (superType != null && superType.eIsProxy()) {
			InternalEObject oldSuperType = (InternalEObject)superType;
			superType = (Entity)eResolveProxy(oldSuperType);
			if (superType != oldSuperType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.ENTITY__SUPER_TYPE, oldSuperType, superType));
			}
		}
		return superType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Entity basicGetSuperType() {
		return superType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSuperType(Entity newSuperType) {
		Entity oldSuperType = superType;
		superType = newSuperType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ENTITY__SUPER_TYPE, oldSuperType, superType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AttributeGroup> getAttributeGroups() {
		if (attributeGroups == null) {
			attributeGroups = new EObjectContainmentEList<AttributeGroup>(AttributeGroup.class, this, DomPackage.ENTITY__ATTRIBUTE_GROUPS);
		}
		return attributeGroups;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ConditionsBlock getConditionsBlock() {
		return conditionsBlock;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConditionsBlock(ConditionsBlock newConditionsBlock, NotificationChain msgs) {
		ConditionsBlock oldConditionsBlock = conditionsBlock;
		conditionsBlock = newConditionsBlock;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.ENTITY__CONDITIONS_BLOCK, oldConditionsBlock, newConditionsBlock);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setConditionsBlock(ConditionsBlock newConditionsBlock) {
		if (newConditionsBlock != conditionsBlock) {
			NotificationChain msgs = null;
			if (conditionsBlock != null)
				msgs = ((InternalEObject)conditionsBlock).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.ENTITY__CONDITIONS_BLOCK, null, msgs);
			if (newConditionsBlock != null)
				msgs = ((InternalEObject)newConditionsBlock).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.ENTITY__CONDITIONS_BLOCK, null, msgs);
			msgs = basicSetConditionsBlock(newConditionsBlock, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.ENTITY__CONDITIONS_BLOCK, newConditionsBlock, newConditionsBlock));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Dao getRepository() {
		if (this.repository == null) {
			Collection<Dao> daos = EcoreUtil.getObjectsByType(eContainer().eContents(), DomPackage.eINSTANCE.getDao());
			if (daos != null) {
				for (Dao dao : daos) {
					if (dao.getEntity() != null && dao.getEntity().equals(this)) {
						this.repository = dao;
					}
				}
			}
		}
		return this.repository;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public AttributeGroup getKey() {
		if (null == key) {
			if (getSuperType() != null && !getSuperType().equals(this)) {
				key =  getSuperType().getKey();
			}
			for (Iterator<AttributeGroup> iterator = getAttributeGroups().iterator(); null == key
					&& iterator.hasNext();) {
				AttributeGroup attributeGroup = iterator.next();
				if (attributeGroup.isKey()) {
					key = attributeGroup;
				}
			}
		}
		return key;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<AttributeGroup> getSortOrders() {
	    EList<AttributeGroup> sortOrders = new EObjectEList<AttributeGroup>(AttributeGroup.class, this, DomPackage.ENTITY__SORT_ORDERS);
	    sortOrders.addAll(Collections2.filter(getAttributeGroups(),
                new Predicate<AttributeGroup>() {
            public boolean apply(AttributeGroup input) {
                return input.isSortorder();
            }
        }));
	    return sortOrders;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	private Attribute identifierAttribute;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	private Attribute versionAttribute;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Attribute getIdentifier() {
		if (null == identifierAttribute) {
			if (getSuperType() != null && !getSuperType().equals(this)) {
				identifierAttribute = (Attribute) getSuperType().getIdentifier();
			}
			for (Iterator<Attribute> iterator = getAttributes().iterator(); null == identifierAttribute
					&& iterator.hasNext();) {
				Attribute attribute = iterator.next();
				if (attribute.isIdentifier()) {
					identifierAttribute = attribute;
				}
			}
		}
		return identifierAttribute;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Attribute getVersion() {
		if (null == versionAttribute) {
			if (getSuperType() != null && !getSuperType().equals(this)) {
				versionAttribute = (Attribute) getSuperType().getVersion();
			}
			for (Iterator<Attribute> iterator = getAttributes().iterator(); null == versionAttribute && iterator.hasNext();) {
				Attribute attribute = iterator.next();
				if (attribute.isVersion()) {
					versionAttribute = attribute;
				}
			}
		}
		return versionAttribute;

	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<Attribute> getRequiredReferences() {
		EList<Attribute> requiredReferences = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.ENTITY__REQUIRED_REFERENCES);
		requiredReferences.addAll(Collections2.filter(getAllAttributes(), new Predicate<Attribute>() {
            public boolean apply(Attribute attribute) {
                return attribute.isRequired() && attribute.isReference();
            }
        }));
        return requiredReferences;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<Attribute> getRequiredAttributes() {
	    EList<Attribute> requiredAttributes = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.ENTITY__REQUIRED_ATTRIBUTES);
	    requiredAttributes.addAll(Collections2.filter(getAllAttributes(), new Predicate<Attribute>() {
            public boolean apply(Attribute attribute) {
                return attribute.isRequired() && !attribute.isReference();
            }
        }));
		return requiredAttributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.ENTITY__ATTRIBUTE_GROUPS:
				return ((InternalEList<?>)getAttributeGroups()).basicRemove(otherEnd, msgs);
			case DomPackage.ENTITY__CONDITIONS_BLOCK:
				return basicSetConditionsBlock(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.ENTITY__SUPER_TYPE:
				if (resolve) return getSuperType();
				return basicGetSuperType();
			case DomPackage.ENTITY__ATTRIBUTE_GROUPS:
				return getAttributeGroups();
			case DomPackage.ENTITY__CONDITIONS_BLOCK:
				return getConditionsBlock();
			case DomPackage.ENTITY__REPOSITORY:
				return getRepository();
			case DomPackage.ENTITY__KEY:
				return getKey();
			case DomPackage.ENTITY__SORT_ORDERS:
				return getSortOrders();
			case DomPackage.ENTITY__IDENTIFIER:
				return getIdentifier();
			case DomPackage.ENTITY__VERSION:
				return getVersion();
			case DomPackage.ENTITY__REQUIRED_REFERENCES:
				return getRequiredReferences();
			case DomPackage.ENTITY__REQUIRED_ATTRIBUTES:
				return getRequiredAttributes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.ENTITY__SUPER_TYPE:
				setSuperType((Entity)newValue);
				return;
			case DomPackage.ENTITY__ATTRIBUTE_GROUPS:
				getAttributeGroups().clear();
				getAttributeGroups().addAll((Collection<? extends AttributeGroup>)newValue);
				return;
			case DomPackage.ENTITY__CONDITIONS_BLOCK:
				setConditionsBlock((ConditionsBlock)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.ENTITY__SUPER_TYPE:
				setSuperType((Entity)null);
				return;
			case DomPackage.ENTITY__ATTRIBUTE_GROUPS:
				getAttributeGroups().clear();
				return;
			case DomPackage.ENTITY__CONDITIONS_BLOCK:
				setConditionsBlock((ConditionsBlock)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.ENTITY__SUPER_TYPE:
				return superType != null;
			case DomPackage.ENTITY__ATTRIBUTE_GROUPS:
				return attributeGroups != null && !attributeGroups.isEmpty();
			case DomPackage.ENTITY__CONDITIONS_BLOCK:
				return conditionsBlock != null;
			case DomPackage.ENTITY__REPOSITORY:
				return getRepository() != null;
			case DomPackage.ENTITY__KEY:
				return getKey() != null;
			case DomPackage.ENTITY__SORT_ORDERS:
				return !getSortOrders().isEmpty();
			case DomPackage.ENTITY__IDENTIFIER:
				return getIdentifier() != null;
			case DomPackage.ENTITY__VERSION:
				return getVersion() != null;
			case DomPackage.ENTITY__REQUIRED_REFERENCES:
				return !getRequiredReferences().isEmpty();
			case DomPackage.ENTITY__REQUIRED_ATTRIBUTES:
				return !getRequiredAttributes().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * @generated NOT
	 */
	@Override
	public EList<Attribute> getAllAttributes() {
	    EList<Attribute> allAttributes = new EObjectEList<Attribute>(Attribute.class, this, DomPackage.ENTITY__ALL_ATTRIBUTES);
		if (getSuperType() != null && !getSuperType().equals(this)) {
			allAttributes.addAll(getSuperType().getAllAttributes());
		}
		allAttributes.addAll(getAttributes());
		return allAttributes;
	}

	/**
	 * @generated NOT
	 */
	public void setDas(Dao das) {
		this.repository = das;
	}

	/**
	 * @generated NOT
	 */
	public Collection<Attribute> copyAttributes() {
		Collection<Attribute> attributes = EcoreUtil.copyAll(getAttributes());
		if (getSuperType() != null) {
			Collection<Attribute> superTypeAttributes = getSuperType().copyAttributes();
			attributes.addAll(EcoreUtil.copyAll(superTypeAttributes));
		}
		return attributes;
	}

	/**
	 * @generated NOT
	 */
	public Attribute getAttributeByName(String name) {
		for (Attribute attribute : copyAttributes()) {
			if (name.equalsIgnoreCase(attribute.getName())) {
				return attribute;
			}
		}
		return null;
	}

	/**
	 * @generated NOT
	 */
	public DataView getDefaultDataView() {
		if (null == defaultView) {
			Collection<DataView> dataViews = EcoreUtil.getObjectsByType(eContainer().eContents(), DomPackage.eINSTANCE
					.getDataView());
			for (Iterator<DataView> iterator = dataViews.iterator(); iterator.hasNext() && defaultView == null;) {
				DataView dataView = (DataView) iterator.next();
				if (getDefaultDataViewName().equals(dataView.getName())) {
					defaultView = dataView;
				}
			}
		}
		return defaultView;
	}

	/**
	 * @generated NOT
	 */
	public String getDefaultDataViewName() {
		return getName() + "View";
	}

	/**
	 * @generated NOT
	 */
	public EList<Attribute> getResolvedAttributeList() {
		EList<Attribute> resolvedAttributeList = ECollections.emptyEList();
		if (getKey() != null) {
			resolvedAttributeList = getKey().getResolvedAttributeList();
		} else if (getIdentifier() != null) {
			resolvedAttributeList = new BasicEList<Attribute>();
			Attribute attributeCopy = (Attribute) EcoreUtil.copy(getIdentifier());
			EObjectPropertiesAdapter.setProperty(attributeCopy, "entity", this);
			resolvedAttributeList.add(attributeCopy);
		}
		return resolvedAttributeList;
	}
	
	/**
	 * @generated NOT
	 */	
	public List<PresentableFeature> getAllPresentableFeaturesIncludingSuperType() {
		List<PresentableFeature> presentableFeatureList = new ArrayList<PresentableFeature>();
		presentableFeatureList.addAll(getAllAttributes());		
		return presentableFeatureList;
	}	
} // EntityImpl
