/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.CorePackage;
import org.openxma.dsl.core.model.IDocumentable;
import org.openxma.dsl.core.model.ValidatorReference;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.FeatureReference;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Feature Reference</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#getTxtDescription <em>Txt Description</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#getSource <em>Source</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#getAttribute <em>Attribute</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#getView <em>View</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#isAll <em>All</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.FeatureReferenceImpl#getTarget <em>Target</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FeatureReferenceImpl extends PresentableFeatureImpl implements FeatureReference {
	/**
	 * The default value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected static final String TXT_DESCRIPTION_EDEFAULT = null;

    /**
	 * The cached value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected String txtDescription = TXT_DESCRIPTION_EDEFAULT;

    /**
	 * The cached value of the '{@link #getSource() <em>Source</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected Entity source;

	/**
	 * The cached value of the '{@link #getAttribute() <em>Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttribute()
	 * @generated
	 * @ordered
	 */
	protected Attribute attribute;

	/**
	 * The cached value of the '{@link #getView() <em>View</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getView()
	 * @generated
	 * @ordered
	 */
	protected DataView view;

	/**
	 * The default value of the '{@link #isAll() <em>All</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #isAll()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ALL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAll() <em>All</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #isAll()
	 * @generated
	 * @ordered
	 */
	protected boolean all = ALL_EDEFAULT;

    /**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<AttributeProperty> properties;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.FEATURE_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getTxtDescription() {
		return txtDescription;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setTxtDescription(String newTxtDescription) {
		String oldTxtDescription = txtDescription;
		txtDescription = newTxtDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION, oldTxtDescription, txtDescription));
	}

    /**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Entity getSource() {
		if (source != null && source.eIsProxy()) {
			InternalEObject oldSource = (InternalEObject)source;
			source = (Entity)eResolveProxy(oldSource);
			if (source != oldSource) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.FEATURE_REFERENCE__SOURCE, oldSource, source));
			}
		}
		return source;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Entity basicGetSource() {
		return source;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setSource(Entity newSource) {
		Entity oldSource = source;
		source = newSource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.FEATURE_REFERENCE__SOURCE, oldSource, source));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute getAttribute() {
		if (attribute != null && attribute.eIsProxy()) {
			InternalEObject oldAttribute = (InternalEObject)attribute;
			attribute = (Attribute)eResolveProxy(oldAttribute);
			if (attribute != oldAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.FEATURE_REFERENCE__ATTRIBUTE, oldAttribute, attribute));
			}
		}
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Attribute basicGetAttribute() {
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttribute(Attribute newAttribute) {
		Attribute oldAttribute = attribute;
		attribute = newAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.FEATURE_REFERENCE__ATTRIBUTE, oldAttribute, attribute));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataView getView() {
		if (view != null && view.eIsProxy()) {
			InternalEObject oldView = (InternalEObject)view;
			view = (DataView)eResolveProxy(oldView);
			if (view != oldView) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.FEATURE_REFERENCE__VIEW, oldView, view));
			}
		}
		return view;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DataView basicGetView() {
		return view;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setView(DataView newView) {
		DataView oldView = view;
		view = newView;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.FEATURE_REFERENCE__VIEW, oldView, view));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AttributeProperty> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<AttributeProperty>(AttributeProperty.class, this, DomPackage.FEATURE_REFERENCE__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAll() {
		return all;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setAll(boolean newAll) {
		boolean oldAll = all;
		all = newAll;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.FEATURE_REFERENCE__ALL, oldAll, all));
	}


	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Attribute getTarget() {
		return this.structuralFeature;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.FEATURE_REFERENCE__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION:
				return getTxtDescription();
			case DomPackage.FEATURE_REFERENCE__SOURCE:
				if (resolve) return getSource();
				return basicGetSource();
			case DomPackage.FEATURE_REFERENCE__ATTRIBUTE:
				if (resolve) return getAttribute();
				return basicGetAttribute();
			case DomPackage.FEATURE_REFERENCE__VIEW:
				if (resolve) return getView();
				return basicGetView();
			case DomPackage.FEATURE_REFERENCE__ALL:
				return isAll();
			case DomPackage.FEATURE_REFERENCE__PROPERTIES:
				return getProperties();
			case DomPackage.FEATURE_REFERENCE__TARGET:
				return getTarget();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION:
				setTxtDescription((String)newValue);
				return;
			case DomPackage.FEATURE_REFERENCE__SOURCE:
				setSource((Entity)newValue);
				return;
			case DomPackage.FEATURE_REFERENCE__ATTRIBUTE:
				setAttribute((Attribute)newValue);
				return;
			case DomPackage.FEATURE_REFERENCE__VIEW:
				setView((DataView)newValue);
				return;
			case DomPackage.FEATURE_REFERENCE__ALL:
				setAll((Boolean)newValue);
				return;
			case DomPackage.FEATURE_REFERENCE__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends AttributeProperty>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION:
				setTxtDescription(TXT_DESCRIPTION_EDEFAULT);
				return;
			case DomPackage.FEATURE_REFERENCE__SOURCE:
				setSource((Entity)null);
				return;
			case DomPackage.FEATURE_REFERENCE__ATTRIBUTE:
				setAttribute((Attribute)null);
				return;
			case DomPackage.FEATURE_REFERENCE__VIEW:
				setView((DataView)null);
				return;
			case DomPackage.FEATURE_REFERENCE__ALL:
				setAll(ALL_EDEFAULT);
				return;
			case DomPackage.FEATURE_REFERENCE__PROPERTIES:
				getProperties().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION:
				return TXT_DESCRIPTION_EDEFAULT == null ? txtDescription != null : !TXT_DESCRIPTION_EDEFAULT.equals(txtDescription);
			case DomPackage.FEATURE_REFERENCE__SOURCE:
				return source != null;
			case DomPackage.FEATURE_REFERENCE__ATTRIBUTE:
				return attribute != null;
			case DomPackage.FEATURE_REFERENCE__VIEW:
				return view != null;
			case DomPackage.FEATURE_REFERENCE__ALL:
				return all != ALL_EDEFAULT;
			case DomPackage.FEATURE_REFERENCE__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case DomPackage.FEATURE_REFERENCE__TARGET:
				return getTarget() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == IDocumentable.class) {
			switch (derivedFeatureID) {
				case DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION: return CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == IDocumentable.class) {
			switch (baseFeatureID) {
				case CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION: return DomPackage.FEATURE_REFERENCE__TXT_DESCRIPTION;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

    /**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (txtDescription: ");
		result.append(txtDescription);
		result.append(", all: ");
		result.append(all);
		result.append(')');
		return result.toString();
	}

	/**
	 * @modified
	 */
	public void setTarget(Attribute attribute) {
		this.structuralFeature = attribute;
	}

	/**
	 * @generated NOT
	 */
	public Attribute structuralFeature;

	/**
	 * @modified
	 * @return the attribute
	 */
	public String getLabelText() {
		EList<AttributeProperty> attrProp = getProperties();
		String labelText = null;
		if (attrProp != null && attrProp.size() > 0) {
			labelText = AttributePropertyImpl.getLabelText(getProperties());
		}
		if (labelText == null && getAttribute() != null) {
			labelText = getAttribute().getLabelText();
		}
		return labelText;
	}

	/**
	 * @modified
	 * @return the attribute
	 */
	public String getTooltipText() {

		EList<AttributeProperty> attrProp = getProperties();
		String tooltipText = null;
		if (attrProp != null && attrProp.size() > 0) {
			tooltipText = AttributePropertyImpl.getTooltipText(getProperties());
		}
		if (tooltipText == null && getAttribute() != null) {
			tooltipText = getAttribute().getTooltipText();
		}
		return tooltipText;
	}

	/**
	 * @modified
	 * @return the attribute
	 */
	public String getUnitText() {
		EList<AttributeProperty> attrProp = getProperties();
		String tooltipText = null;
		if (attrProp != null && attrProp.size() > 0) {
			tooltipText = AttributePropertyImpl.getUnitText(getProperties());
		}
		if (tooltipText == null && getAttribute() != null) {
			tooltipText = getAttribute().getUnitText();
		}
		return tooltipText;
	}

	/**
	 * @modified
	 * @return the attribute
	 */
	public Attribute getUnitAttribute() {

		EList<AttributeProperty> attrProp = getProperties();
		Attribute tooltipText = null;
		if (attrProp != null && attrProp.size() > 0) {
			tooltipText = AttributePropertyImpl.getUnitAttribute(getProperties());
		}
		if (tooltipText == null && getAttribute() != null) {
			tooltipText = getAttribute().getUnitAttribute();
		}
		return tooltipText;
	}
	
    /**
     * @modified
     * @return the attribute
     */   	
    public String getCalculatedName() {
    	String name = getName();
    	if (name == null && getAttribute() != null) {
    		name = getAttribute().getName();
    	}
    	return name;
    }	
    
    /**
     * @modified
     */   	    
	public EList<AttributeProperty> getAttributProperties() {
		EList<AttributeProperty> prop = new BasicEList<AttributeProperty>(getProperties());
		if (getAttribute() != null) {
			prop.addAll(getAttribute().getAttributProperties());
		}
		return prop;
	}
	
    /**
     * @modified
     */	
	public ValidatorReference getFormat() {
		return AttributeImpl.getFormatInternal(getAttributProperties());
	}	

} // FeatureReferenceImpl
