/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.InsertStatement;
import org.openxma.dsl.dom.model.SelectStatement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Insert Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.InsertStatementImpl#getEntity <em>Entity</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.InsertStatementImpl#getExpression <em>Expression</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.InsertStatementImpl#getSelectStatement <em>Select Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InsertStatementImpl extends QlStatementImpl implements InsertStatement {
	/**
	 * The cached value of the '{@link #getEntity() <em>Entity</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntity()
	 * @generated
	 * @ordered
	 */
	protected Entity entity;

	/**
	 * The cached value of the '{@link #getExpression() <em>Expression</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExpression()
	 * @generated
	 * @ordered
	 */
	protected EList<Expression> expression;

	/**
	 * The cached value of the '{@link #getSelectStatement() <em>Select Statement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectStatement()
	 * @generated
	 * @ordered
	 */
	protected SelectStatement selectStatement;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InsertStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.INSERT_STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entity getEntity() {
		if (entity != null && entity.eIsProxy()) {
			InternalEObject oldEntity = (InternalEObject)entity;
			entity = (Entity)eResolveProxy(oldEntity);
			if (entity != oldEntity) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.INSERT_STATEMENT__ENTITY, oldEntity, entity));
			}
		}
		return entity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entity basicGetEntity() {
		return entity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEntity(Entity newEntity) {
		Entity oldEntity = entity;
		entity = newEntity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.INSERT_STATEMENT__ENTITY, oldEntity, entity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Expression> getExpression() {
		if (expression == null) {
			expression = new EObjectContainmentEList<Expression>(Expression.class, this, DomPackage.INSERT_STATEMENT__EXPRESSION);
		}
		return expression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SelectStatement getSelectStatement() {
		return selectStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSelectStatement(SelectStatement newSelectStatement, NotificationChain msgs) {
		SelectStatement oldSelectStatement = selectStatement;
		selectStatement = newSelectStatement;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.INSERT_STATEMENT__SELECT_STATEMENT, oldSelectStatement, newSelectStatement);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSelectStatement(SelectStatement newSelectStatement) {
		if (newSelectStatement != selectStatement) {
			NotificationChain msgs = null;
			if (selectStatement != null)
				msgs = ((InternalEObject)selectStatement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.INSERT_STATEMENT__SELECT_STATEMENT, null, msgs);
			if (newSelectStatement != null)
				msgs = ((InternalEObject)newSelectStatement).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.INSERT_STATEMENT__SELECT_STATEMENT, null, msgs);
			msgs = basicSetSelectStatement(newSelectStatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.INSERT_STATEMENT__SELECT_STATEMENT, newSelectStatement, newSelectStatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.INSERT_STATEMENT__EXPRESSION:
				return ((InternalEList<?>)getExpression()).basicRemove(otherEnd, msgs);
			case DomPackage.INSERT_STATEMENT__SELECT_STATEMENT:
				return basicSetSelectStatement(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.INSERT_STATEMENT__ENTITY:
				if (resolve) return getEntity();
				return basicGetEntity();
			case DomPackage.INSERT_STATEMENT__EXPRESSION:
				return getExpression();
			case DomPackage.INSERT_STATEMENT__SELECT_STATEMENT:
				return getSelectStatement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.INSERT_STATEMENT__ENTITY:
				setEntity((Entity)newValue);
				return;
			case DomPackage.INSERT_STATEMENT__EXPRESSION:
				getExpression().clear();
				getExpression().addAll((Collection<? extends Expression>)newValue);
				return;
			case DomPackage.INSERT_STATEMENT__SELECT_STATEMENT:
				setSelectStatement((SelectStatement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.INSERT_STATEMENT__ENTITY:
				setEntity((Entity)null);
				return;
			case DomPackage.INSERT_STATEMENT__EXPRESSION:
				getExpression().clear();
				return;
			case DomPackage.INSERT_STATEMENT__SELECT_STATEMENT:
				setSelectStatement((SelectStatement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.INSERT_STATEMENT__ENTITY:
				return entity != null;
			case DomPackage.INSERT_STATEMENT__EXPRESSION:
				return expression != null && !expression.isEmpty();
			case DomPackage.INSERT_STATEMENT__SELECT_STATEMENT:
				return selectStatement != null;
		}
		return super.eIsSet(featureID);
	}

} //InsertStatementImpl
