/**
 * <copyright>
 * </copyright>
 *
 * $Id: ManyToOneImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;
import java.util.HashSet;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.SqlType;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.ManyToOne;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Many To One</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl#getColumnName <em>Column Name</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl#getUserType <em>User Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl#getSqlType <em>Sql Type</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl#getColumns <em>Columns</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ManyToOneImpl#isDerived <em>Derived</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ManyToOneImpl extends DaoFeatureImpl implements ManyToOne {
	/**
	 * The default value of the '{@link #getColumnName() <em>Column Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnName()
	 * @generated
	 * @ordered
	 */
	protected static final String COLUMN_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColumnName() <em>Column Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnName()
	 * @generated
	 * @ordered
	 */
	protected String columnName = COLUMN_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getUserType() <em>User Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserType()
	 * @generated
	 * @ordered
	 */
	protected Type userType;

	/**
	 * The cached value of the '{@link #getSqlType() <em>Sql Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSqlType()
	 * @generated
	 * @ordered
	 */
	protected SqlType sqlType;

	/**
	 * The cached value of the '{@link #getColumns() <em>Columns</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumns()
	 * @generated
	 * @ordered
	 */
	protected EList<Column> columns;

	/**
	 * The default value of the '{@link #isDerived() <em>Derived</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDerived()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DERIVED_EDEFAULT = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManyToOneImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.MANY_TO_ONE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColumnName() {
		return columnName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumnName(String newColumnName) {
		String oldColumnName = columnName;
		columnName = newColumnName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MANY_TO_ONE__COLUMN_NAME, oldColumnName, columnName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getUserType() {
		if (userType != null && userType.eIsProxy()) {
			InternalEObject oldUserType = (InternalEObject)userType;
			userType = (Type)eResolveProxy(oldUserType);
			if (userType != oldUserType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.MANY_TO_ONE__USER_TYPE, oldUserType, userType));
			}
		}
		return userType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type basicGetUserType() {
		return userType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUserType(Type newUserType) {
		Type oldUserType = userType;
		userType = newUserType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MANY_TO_ONE__USER_TYPE, oldUserType, userType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SqlType getSqlType() {
		if (sqlType != null && sqlType.eIsProxy()) {
			InternalEObject oldSqlType = (InternalEObject)sqlType;
			sqlType = (SqlType)eResolveProxy(oldSqlType);
			if (sqlType != oldSqlType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.MANY_TO_ONE__SQL_TYPE, oldSqlType, sqlType));
			}
		}
		return sqlType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SqlType basicGetSqlType() {
		return sqlType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSqlType(SqlType newSqlType) {
		SqlType oldSqlType = sqlType;
		sqlType = newSqlType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MANY_TO_ONE__SQL_TYPE, oldSqlType, sqlType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Column> getColumns() {
		if (columns == null) {
			columns = new EObjectContainmentEList<Column>(Column.class, this, DomPackage.MANY_TO_ONE__COLUMNS);
		}
		return columns;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isDerived() {
		Dao dao = (Dao) eContainer();
		HashSet<String> columnNames = Sets.newHashSet(Iterators.transform(dao.getColumns().iterator(),
				new Function<Column, String>() {
					public String apply(Column column) {
						return column.getColumnName();
					}
				}));
		if (getColumnName() != null) {
			return columnNames.contains(getColumnName());
		} else {
			final HashSet<String> manyToOneColumnNames = Sets.newHashSet(Iterators.transform(getColumns().iterator(),
					new Function<Column, String>() {
						public String apply(Column column) {
							return column.getColumnName();
						}
					}));
			return Iterators.any(columnNames.iterator(), new Predicate<String>() {
				public boolean apply(String input) {
					return manyToOneColumnNames.contains(input);
				}
			});
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.MANY_TO_ONE__COLUMNS:
				return ((InternalEList<?>)getColumns()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.MANY_TO_ONE__COLUMN_NAME:
				return getColumnName();
			case DomPackage.MANY_TO_ONE__USER_TYPE:
				if (resolve) return getUserType();
				return basicGetUserType();
			case DomPackage.MANY_TO_ONE__SQL_TYPE:
				if (resolve) return getSqlType();
				return basicGetSqlType();
			case DomPackage.MANY_TO_ONE__COLUMNS:
				return getColumns();
			case DomPackage.MANY_TO_ONE__DERIVED:
				return isDerived();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.MANY_TO_ONE__COLUMN_NAME:
				setColumnName((String)newValue);
				return;
			case DomPackage.MANY_TO_ONE__USER_TYPE:
				setUserType((Type)newValue);
				return;
			case DomPackage.MANY_TO_ONE__SQL_TYPE:
				setSqlType((SqlType)newValue);
				return;
			case DomPackage.MANY_TO_ONE__COLUMNS:
				getColumns().clear();
				getColumns().addAll((Collection<? extends Column>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.MANY_TO_ONE__COLUMN_NAME:
				setColumnName(COLUMN_NAME_EDEFAULT);
				return;
			case DomPackage.MANY_TO_ONE__USER_TYPE:
				setUserType((Type)null);
				return;
			case DomPackage.MANY_TO_ONE__SQL_TYPE:
				setSqlType((SqlType)null);
				return;
			case DomPackage.MANY_TO_ONE__COLUMNS:
				getColumns().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.MANY_TO_ONE__COLUMN_NAME:
				return COLUMN_NAME_EDEFAULT == null ? columnName != null : !COLUMN_NAME_EDEFAULT.equals(columnName);
			case DomPackage.MANY_TO_ONE__USER_TYPE:
				return userType != null;
			case DomPackage.MANY_TO_ONE__SQL_TYPE:
				return sqlType != null;
			case DomPackage.MANY_TO_ONE__COLUMNS:
				return columns != null && !columns.isEmpty();
			case DomPackage.MANY_TO_ONE__DERIVED:
				return isDerived() != DERIVED_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (columnName: ");
		result.append(columnName);
		result.append(')');
		return result.toString();
	}

} //ManyToOneImpl
