/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.impl.ModelElementImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.MapperAttribute;
import org.openxma.dsl.dom.model.MapperLeftRightAttribute;
import org.openxma.dsl.dom.model.MapperMappingProperty;
import org.openxma.dsl.dom.model.MappingProperty;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.PropertyMappingAttribute;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Mapper</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.MapperImpl#getLeft <em>Left</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.MapperImpl#isBiDirectional <em>Bi Directional</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.MapperImpl#isToLeft <em>To Left</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.MapperImpl#isToRight <em>To Right</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.MapperImpl#getRight <em>Right</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.MapperImpl#getPropertyMappings <em>Property Mappings</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MapperImpl extends ModelElementImpl implements Mapper {
    /**
	 * The cached value of the '{@link #getLeft() <em>Left</em>}' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getLeft()
	 * @generated
	 * @ordered
	 */
    protected ComplexType left;

    /**
	 * The default value of the '{@link #isBiDirectional() <em>Bi Directional</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isBiDirectional()
	 * @generated
	 * @ordered
	 */
    protected static final boolean BI_DIRECTIONAL_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isBiDirectional() <em>Bi Directional</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isBiDirectional()
	 * @generated
	 * @ordered
	 */
    protected boolean biDirectional = BI_DIRECTIONAL_EDEFAULT;

    /**
	 * The default value of the '{@link #isToLeft() <em>To Left</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToLeft()
	 * @generated
	 * @ordered
	 */
    protected static final boolean TO_LEFT_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isToLeft() <em>To Left</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToLeft()
	 * @generated
	 * @ordered
	 */
    protected boolean toLeft = TO_LEFT_EDEFAULT;

    /**
	 * The default value of the '{@link #isToRight() <em>To Right</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToRight()
	 * @generated
	 * @ordered
	 */
    protected static final boolean TO_RIGHT_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isToRight() <em>To Right</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToRight()
	 * @generated
	 * @ordered
	 */
    protected boolean toRight = TO_RIGHT_EDEFAULT;

    /**
	 * The cached value of the '{@link #getRight() <em>Right</em>}' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getRight()
	 * @generated
	 * @ordered
	 */
    protected ComplexType right;

    /**
	 * The cached value of the '{@link #getPropertyMappings() <em>Property Mappings</em>}' containment reference list.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getPropertyMappings()
	 * @generated
	 * @ordered
	 */
    protected EList<PropertyMapping> propertyMappings;

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected MapperImpl() {
		super();
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    protected EClass eStaticClass() {
		return DomPackage.Literals.MAPPER;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public ComplexType getLeft() {
		if (left != null && left.eIsProxy()) {
			InternalEObject oldLeft = (InternalEObject)left;
			left = (ComplexType)eResolveProxy(oldLeft);
			if (left != oldLeft) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.MAPPER__LEFT, oldLeft, left));
			}
		}
		return left;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public ComplexType basicGetLeft() {
		return left;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setLeft(ComplexType newLeft) {
		ComplexType oldLeft = left;
		left = newLeft;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MAPPER__LEFT, oldLeft, left));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isBiDirectional() {
		return biDirectional;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setBiDirectional(boolean newBiDirectional) {
		boolean oldBiDirectional = biDirectional;
		biDirectional = newBiDirectional;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MAPPER__BI_DIRECTIONAL, oldBiDirectional, biDirectional));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isToLeft() {
		return toLeft;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setToLeft(boolean newToLeft) {
		boolean oldToLeft = toLeft;
		toLeft = newToLeft;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MAPPER__TO_LEFT, oldToLeft, toLeft));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isToRight() {
		return toRight;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setToRight(boolean newToRight) {
		boolean oldToRight = toRight;
		toRight = newToRight;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MAPPER__TO_RIGHT, oldToRight, toRight));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public ComplexType getRight() {
		if (right != null && right.eIsProxy()) {
			InternalEObject oldRight = (InternalEObject)right;
			right = (ComplexType)eResolveProxy(oldRight);
			if (right != oldRight) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.MAPPER__RIGHT, oldRight, right));
			}
		}
		return right;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public ComplexType basicGetRight() {
		return right;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setRight(ComplexType newRight) {
		ComplexType oldRight = right;
		right = newRight;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.MAPPER__RIGHT, oldRight, right));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public EList<PropertyMapping> getPropertyMappings() {
		if (propertyMappings == null) {
			propertyMappings = new EObjectContainmentEList<PropertyMapping>(PropertyMapping.class, this, DomPackage.MAPPER__PROPERTY_MAPPINGS);
		}
		return propertyMappings;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.MAPPER__PROPERTY_MAPPINGS:
				return ((InternalEList<?>)getPropertyMappings()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.MAPPER__LEFT:
				if (resolve) return getLeft();
				return basicGetLeft();
			case DomPackage.MAPPER__BI_DIRECTIONAL:
				return isBiDirectional();
			case DomPackage.MAPPER__TO_LEFT:
				return isToLeft();
			case DomPackage.MAPPER__TO_RIGHT:
				return isToRight();
			case DomPackage.MAPPER__RIGHT:
				if (resolve) return getRight();
				return basicGetRight();
			case DomPackage.MAPPER__PROPERTY_MAPPINGS:
				return getPropertyMappings();
		}
		return super.eGet(featureID, resolve, coreType);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.MAPPER__LEFT:
				setLeft((ComplexType)newValue);
				return;
			case DomPackage.MAPPER__BI_DIRECTIONAL:
				setBiDirectional((Boolean)newValue);
				return;
			case DomPackage.MAPPER__TO_LEFT:
				setToLeft((Boolean)newValue);
				return;
			case DomPackage.MAPPER__TO_RIGHT:
				setToRight((Boolean)newValue);
				return;
			case DomPackage.MAPPER__RIGHT:
				setRight((ComplexType)newValue);
				return;
			case DomPackage.MAPPER__PROPERTY_MAPPINGS:
				getPropertyMappings().clear();
				getPropertyMappings().addAll((Collection<? extends PropertyMapping>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.MAPPER__LEFT:
				setLeft((ComplexType)null);
				return;
			case DomPackage.MAPPER__BI_DIRECTIONAL:
				setBiDirectional(BI_DIRECTIONAL_EDEFAULT);
				return;
			case DomPackage.MAPPER__TO_LEFT:
				setToLeft(TO_LEFT_EDEFAULT);
				return;
			case DomPackage.MAPPER__TO_RIGHT:
				setToRight(TO_RIGHT_EDEFAULT);
				return;
			case DomPackage.MAPPER__RIGHT:
				setRight((ComplexType)null);
				return;
			case DomPackage.MAPPER__PROPERTY_MAPPINGS:
				getPropertyMappings().clear();
				return;
		}
		super.eUnset(featureID);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.MAPPER__LEFT:
				return left != null;
			case DomPackage.MAPPER__BI_DIRECTIONAL:
				return biDirectional != BI_DIRECTIONAL_EDEFAULT;
			case DomPackage.MAPPER__TO_LEFT:
				return toLeft != TO_LEFT_EDEFAULT;
			case DomPackage.MAPPER__TO_RIGHT:
				return toRight != TO_RIGHT_EDEFAULT;
			case DomPackage.MAPPER__RIGHT:
				return right != null;
			case DomPackage.MAPPER__PROPERTY_MAPPINGS:
				return propertyMappings != null && !propertyMappings.isEmpty();
		}
		return super.eIsSet(featureID);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (biDirectional: ");
		result.append(biDirectional);
		result.append(", toLeft: ");
		result.append(toLeft);
		result.append(", toRight: ");
		result.append(toRight);
		result.append(')');
		return result.toString();
	}

} //MapperImpl
