/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.PresentableFeature;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.MapperLeftRightAttribute;
import org.openxma.dsl.dom.model.MappingProperty;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.PropertyMappingAttribute;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Property Mapping</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl#getLeft <em>Left</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl#isBiDirectional <em>Bi Directional</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl#isToLeft <em>To Left</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl#isToRight <em>To Right</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.PropertyMappingImpl#getRight <em>Right</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PropertyMappingImpl extends MinimalEObjectImpl.Container implements PropertyMapping {
    /**
	 * The cached value of the '{@link #getLeft() <em>Left</em>}' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getLeft()
	 * @generated
	 * @ordered
	 */
    protected Attribute left;

    /**
	 * The default value of the '{@link #isBiDirectional() <em>Bi Directional</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isBiDirectional()
	 * @generated
	 * @ordered
	 */
    protected static final boolean BI_DIRECTIONAL_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isBiDirectional() <em>Bi Directional</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isBiDirectional()
	 * @generated
	 * @ordered
	 */
    protected boolean biDirectional = BI_DIRECTIONAL_EDEFAULT;

    /**
	 * The default value of the '{@link #isToLeft() <em>To Left</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToLeft()
	 * @generated
	 * @ordered
	 */
    protected static final boolean TO_LEFT_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isToLeft() <em>To Left</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToLeft()
	 * @generated
	 * @ordered
	 */
    protected boolean toLeft = TO_LEFT_EDEFAULT;

    /**
	 * The default value of the '{@link #isToRight() <em>To Right</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToRight()
	 * @generated
	 * @ordered
	 */
    protected static final boolean TO_RIGHT_EDEFAULT = false;

    /**
	 * The cached value of the '{@link #isToRight() <em>To Right</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #isToRight()
	 * @generated
	 * @ordered
	 */
    protected boolean toRight = TO_RIGHT_EDEFAULT;

    /**
	 * The cached value of the '{@link #getRight() <em>Right</em>}' reference.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getRight()
	 * @generated
	 * @ordered
	 */
    protected Attribute right;

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected PropertyMappingImpl() {
		super();
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    protected EClass eStaticClass() {
		return DomPackage.Literals.PROPERTY_MAPPING;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Attribute getLeft() {
		if (left != null && left.eIsProxy()) {
			InternalEObject oldLeft = (InternalEObject)left;
			left = (Attribute)eResolveProxy(oldLeft);
			if (left != oldLeft) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.PROPERTY_MAPPING__LEFT, oldLeft, left));
			}
		}
		return left;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Attribute basicGetLeft() {
		return left;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setLeft(Attribute newLeft) {
		Attribute oldLeft = left;
		left = newLeft;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.PROPERTY_MAPPING__LEFT, oldLeft, left));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isBiDirectional() {
		return biDirectional;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setBiDirectional(boolean newBiDirectional) {
		boolean oldBiDirectional = biDirectional;
		biDirectional = newBiDirectional;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.PROPERTY_MAPPING__BI_DIRECTIONAL, oldBiDirectional, biDirectional));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isToLeft() {
		return toLeft;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setToLeft(boolean newToLeft) {
		boolean oldToLeft = toLeft;
		toLeft = newToLeft;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.PROPERTY_MAPPING__TO_LEFT, oldToLeft, toLeft));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public boolean isToRight() {
		return toRight;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setToRight(boolean newToRight) {
		boolean oldToRight = toRight;
		toRight = newToRight;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.PROPERTY_MAPPING__TO_RIGHT, oldToRight, toRight));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Attribute getRight() {
		if (right != null && right.eIsProxy()) {
			InternalEObject oldRight = (InternalEObject)right;
			right = (Attribute)eResolveProxy(oldRight);
			if (right != oldRight) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DomPackage.PROPERTY_MAPPING__RIGHT, oldRight, right));
			}
		}
		return right;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Attribute basicGetRight() {
		return right;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setRight(Attribute newRight) {
		Attribute oldRight = right;
		right = newRight;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.PROPERTY_MAPPING__RIGHT, oldRight, right));
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.PROPERTY_MAPPING__LEFT:
				if (resolve) return getLeft();
				return basicGetLeft();
			case DomPackage.PROPERTY_MAPPING__BI_DIRECTIONAL:
				return isBiDirectional();
			case DomPackage.PROPERTY_MAPPING__TO_LEFT:
				return isToLeft();
			case DomPackage.PROPERTY_MAPPING__TO_RIGHT:
				return isToRight();
			case DomPackage.PROPERTY_MAPPING__RIGHT:
				if (resolve) return getRight();
				return basicGetRight();
		}
		return super.eGet(featureID, resolve, coreType);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @SuppressWarnings("unchecked")
    @Override
    public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.PROPERTY_MAPPING__LEFT:
				setLeft((Attribute)newValue);
				return;
			case DomPackage.PROPERTY_MAPPING__BI_DIRECTIONAL:
				setBiDirectional((Boolean)newValue);
				return;
			case DomPackage.PROPERTY_MAPPING__TO_LEFT:
				setToLeft((Boolean)newValue);
				return;
			case DomPackage.PROPERTY_MAPPING__TO_RIGHT:
				setToRight((Boolean)newValue);
				return;
			case DomPackage.PROPERTY_MAPPING__RIGHT:
				setRight((Attribute)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.PROPERTY_MAPPING__LEFT:
				setLeft((Attribute)null);
				return;
			case DomPackage.PROPERTY_MAPPING__BI_DIRECTIONAL:
				setBiDirectional(BI_DIRECTIONAL_EDEFAULT);
				return;
			case DomPackage.PROPERTY_MAPPING__TO_LEFT:
				setToLeft(TO_LEFT_EDEFAULT);
				return;
			case DomPackage.PROPERTY_MAPPING__TO_RIGHT:
				setToRight(TO_RIGHT_EDEFAULT);
				return;
			case DomPackage.PROPERTY_MAPPING__RIGHT:
				setRight((Attribute)null);
				return;
		}
		super.eUnset(featureID);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.PROPERTY_MAPPING__LEFT:
				return left != null;
			case DomPackage.PROPERTY_MAPPING__BI_DIRECTIONAL:
				return biDirectional != BI_DIRECTIONAL_EDEFAULT;
			case DomPackage.PROPERTY_MAPPING__TO_LEFT:
				return toLeft != TO_LEFT_EDEFAULT;
			case DomPackage.PROPERTY_MAPPING__TO_RIGHT:
				return toRight != TO_RIGHT_EDEFAULT;
			case DomPackage.PROPERTY_MAPPING__RIGHT:
				return right != null;
		}
		return super.eIsSet(featureID);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (biDirectional: ");
		result.append(biDirectional);
		result.append(", toLeft: ");
		result.append(toLeft);
		result.append(", toRight: ");
		result.append(toRight);
		result.append(')');
		return result.toString();
	}

} //PropertyMappingImpl
