/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.CorePackage;
import org.openxma.dsl.core.model.IDocumentable;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.QlStatement;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Query Operation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.QueryOperationImpl#getTxtDescription <em>Txt Description</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.QueryOperationImpl#getQueryParameters <em>Query Parameters</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.QueryOperationImpl#getStatement <em>Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class QueryOperationImpl extends DaoOperationImpl implements QueryOperation {
	/**
	 * The default value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected static final String TXT_DESCRIPTION_EDEFAULT = null;
    /**
	 * The cached value of the '{@link #getTxtDescription() <em>Txt Description</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getTxtDescription()
	 * @generated
	 * @ordered
	 */
    protected String txtDescription = TXT_DESCRIPTION_EDEFAULT;
    /**
	 * The cached value of the '{@link #getQueryParameters() <em>Query Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueryParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<QueryParameter> queryParameters;
	/**
	 * The cached value of the '{@link #getStatement() <em>Statement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatement()
	 * @generated
	 * @ordered
	 */
	protected QlStatement statement;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryOperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.QUERY_OPERATION;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getTxtDescription() {
		return txtDescription;
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setTxtDescription(String newTxtDescription) {
		String oldTxtDescription = txtDescription;
		txtDescription = newTxtDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.QUERY_OPERATION__TXT_DESCRIPTION, oldTxtDescription, txtDescription));
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<QueryParameter> getQueryParameters() {
		if (queryParameters == null) {
			queryParameters = new EObjectContainmentEList<QueryParameter>(QueryParameter.class, this, DomPackage.QUERY_OPERATION__QUERY_PARAMETERS);
		}
		return queryParameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QlStatement getStatement() {
		return statement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStatement(QlStatement newStatement, NotificationChain msgs) {
		QlStatement oldStatement = statement;
		statement = newStatement;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.QUERY_OPERATION__STATEMENT, oldStatement, newStatement);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatement(QlStatement newStatement) {
		if (newStatement != statement) {
			NotificationChain msgs = null;
			if (statement != null)
				msgs = ((InternalEObject)statement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.QUERY_OPERATION__STATEMENT, null, msgs);
			if (newStatement != null)
				msgs = ((InternalEObject)newStatement).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.QUERY_OPERATION__STATEMENT, null, msgs);
			msgs = basicSetStatement(newStatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.QUERY_OPERATION__STATEMENT, newStatement, newStatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.QUERY_OPERATION__QUERY_PARAMETERS:
				return ((InternalEList<?>)getQueryParameters()).basicRemove(otherEnd, msgs);
			case DomPackage.QUERY_OPERATION__STATEMENT:
				return basicSetStatement(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.QUERY_OPERATION__TXT_DESCRIPTION:
				return getTxtDescription();
			case DomPackage.QUERY_OPERATION__QUERY_PARAMETERS:
				return getQueryParameters();
			case DomPackage.QUERY_OPERATION__STATEMENT:
				return getStatement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.QUERY_OPERATION__TXT_DESCRIPTION:
				setTxtDescription((String)newValue);
				return;
			case DomPackage.QUERY_OPERATION__QUERY_PARAMETERS:
				getQueryParameters().clear();
				getQueryParameters().addAll((Collection<? extends QueryParameter>)newValue);
				return;
			case DomPackage.QUERY_OPERATION__STATEMENT:
				setStatement((QlStatement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.QUERY_OPERATION__TXT_DESCRIPTION:
				setTxtDescription(TXT_DESCRIPTION_EDEFAULT);
				return;
			case DomPackage.QUERY_OPERATION__QUERY_PARAMETERS:
				getQueryParameters().clear();
				return;
			case DomPackage.QUERY_OPERATION__STATEMENT:
				setStatement((QlStatement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.QUERY_OPERATION__TXT_DESCRIPTION:
				return TXT_DESCRIPTION_EDEFAULT == null ? txtDescription != null : !TXT_DESCRIPTION_EDEFAULT.equals(txtDescription);
			case DomPackage.QUERY_OPERATION__QUERY_PARAMETERS:
				return queryParameters != null && !queryParameters.isEmpty();
			case DomPackage.QUERY_OPERATION__STATEMENT:
				return statement != null;
		}
		return super.eIsSet(featureID);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == IDocumentable.class) {
			switch (derivedFeatureID) {
				case DomPackage.QUERY_OPERATION__TXT_DESCRIPTION: return CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == IDocumentable.class) {
			switch (baseFeatureID) {
				case CorePackage.IDOCUMENTABLE__TXT_DESCRIPTION: return DomPackage.QUERY_OPERATION__TXT_DESCRIPTION;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

    /**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    @Override
    public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (txtDescription: ");
		result.append(txtDescription);
		result.append(')');
		return result.toString();
	}

} //QueryOperationImpl
