/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.FromRange;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.SelectStatement;
import org.openxma.dsl.dom.model.SortOrderElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Select Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl#getFrom <em>From</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl#getJoin <em>Join</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl#getWhere <em>Where</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl#getGroupBy <em>Group By</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl#getHaving <em>Having</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.SelectStatementImpl#getOrderBy <em>Order By</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SelectStatementImpl extends QlStatementImpl implements SelectStatement {
	/**
	 * The cached value of the '{@link #getFrom() <em>From</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFrom()
	 * @generated
	 * @ordered
	 */
	protected EList<FromRange> from;

	/**
	 * The cached value of the '{@link #getJoin() <em>Join</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJoin()
	 * @generated
	 * @ordered
	 */
	protected EList<Join> join;

	/**
	 * The cached value of the '{@link #getWhere() <em>Where</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWhere()
	 * @generated
	 * @ordered
	 */
	protected Expression where;

	/**
	 * The cached value of the '{@link #getGroupBy() <em>Group By</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroupBy()
	 * @generated
	 * @ordered
	 */
	protected EList<Expression> groupBy;

	/**
	 * The cached value of the '{@link #getHaving() <em>Having</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHaving()
	 * @generated
	 * @ordered
	 */
	protected Expression having;

	/**
	 * The cached value of the '{@link #getOrderBy() <em>Order By</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderBy()
	 * @generated
	 * @ordered
	 */
	protected EList<SortOrderElement> orderBy;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SelectStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.SELECT_STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<FromRange> getFrom() {
		if (from == null) {
			from = new EObjectContainmentEList<FromRange>(FromRange.class, this, DomPackage.SELECT_STATEMENT__FROM);
		}
		return from;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Join> getJoin() {
		if (join == null) {
			join = new EObjectContainmentEList<Join>(Join.class, this, DomPackage.SELECT_STATEMENT__JOIN);
		}
		return join;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression getWhere() {
		return where;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetWhere(Expression newWhere, NotificationChain msgs) {
		Expression oldWhere = where;
		where = newWhere;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.SELECT_STATEMENT__WHERE, oldWhere, newWhere);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWhere(Expression newWhere) {
		if (newWhere != where) {
			NotificationChain msgs = null;
			if (where != null)
				msgs = ((InternalEObject)where).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.SELECT_STATEMENT__WHERE, null, msgs);
			if (newWhere != null)
				msgs = ((InternalEObject)newWhere).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.SELECT_STATEMENT__WHERE, null, msgs);
			msgs = basicSetWhere(newWhere, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.SELECT_STATEMENT__WHERE, newWhere, newWhere));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Expression> getGroupBy() {
		if (groupBy == null) {
			groupBy = new EObjectContainmentEList<Expression>(Expression.class, this, DomPackage.SELECT_STATEMENT__GROUP_BY);
		}
		return groupBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Expression getHaving() {
		return having;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetHaving(Expression newHaving, NotificationChain msgs) {
		Expression oldHaving = having;
		having = newHaving;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DomPackage.SELECT_STATEMENT__HAVING, oldHaving, newHaving);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHaving(Expression newHaving) {
		if (newHaving != having) {
			NotificationChain msgs = null;
			if (having != null)
				msgs = ((InternalEObject)having).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DomPackage.SELECT_STATEMENT__HAVING, null, msgs);
			if (newHaving != null)
				msgs = ((InternalEObject)newHaving).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DomPackage.SELECT_STATEMENT__HAVING, null, msgs);
			msgs = basicSetHaving(newHaving, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DomPackage.SELECT_STATEMENT__HAVING, newHaving, newHaving));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SortOrderElement> getOrderBy() {
		if (orderBy == null) {
			orderBy = new EObjectContainmentEList<SortOrderElement>(SortOrderElement.class, this, DomPackage.SELECT_STATEMENT__ORDER_BY);
		}
		return orderBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.SELECT_STATEMENT__FROM:
				return ((InternalEList<?>)getFrom()).basicRemove(otherEnd, msgs);
			case DomPackage.SELECT_STATEMENT__JOIN:
				return ((InternalEList<?>)getJoin()).basicRemove(otherEnd, msgs);
			case DomPackage.SELECT_STATEMENT__WHERE:
				return basicSetWhere(null, msgs);
			case DomPackage.SELECT_STATEMENT__GROUP_BY:
				return ((InternalEList<?>)getGroupBy()).basicRemove(otherEnd, msgs);
			case DomPackage.SELECT_STATEMENT__HAVING:
				return basicSetHaving(null, msgs);
			case DomPackage.SELECT_STATEMENT__ORDER_BY:
				return ((InternalEList<?>)getOrderBy()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.SELECT_STATEMENT__FROM:
				return getFrom();
			case DomPackage.SELECT_STATEMENT__JOIN:
				return getJoin();
			case DomPackage.SELECT_STATEMENT__WHERE:
				return getWhere();
			case DomPackage.SELECT_STATEMENT__GROUP_BY:
				return getGroupBy();
			case DomPackage.SELECT_STATEMENT__HAVING:
				return getHaving();
			case DomPackage.SELECT_STATEMENT__ORDER_BY:
				return getOrderBy();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.SELECT_STATEMENT__FROM:
				getFrom().clear();
				getFrom().addAll((Collection<? extends FromRange>)newValue);
				return;
			case DomPackage.SELECT_STATEMENT__JOIN:
				getJoin().clear();
				getJoin().addAll((Collection<? extends Join>)newValue);
				return;
			case DomPackage.SELECT_STATEMENT__WHERE:
				setWhere((Expression)newValue);
				return;
			case DomPackage.SELECT_STATEMENT__GROUP_BY:
				getGroupBy().clear();
				getGroupBy().addAll((Collection<? extends Expression>)newValue);
				return;
			case DomPackage.SELECT_STATEMENT__HAVING:
				setHaving((Expression)newValue);
				return;
			case DomPackage.SELECT_STATEMENT__ORDER_BY:
				getOrderBy().clear();
				getOrderBy().addAll((Collection<? extends SortOrderElement>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.SELECT_STATEMENT__FROM:
				getFrom().clear();
				return;
			case DomPackage.SELECT_STATEMENT__JOIN:
				getJoin().clear();
				return;
			case DomPackage.SELECT_STATEMENT__WHERE:
				setWhere((Expression)null);
				return;
			case DomPackage.SELECT_STATEMENT__GROUP_BY:
				getGroupBy().clear();
				return;
			case DomPackage.SELECT_STATEMENT__HAVING:
				setHaving((Expression)null);
				return;
			case DomPackage.SELECT_STATEMENT__ORDER_BY:
				getOrderBy().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.SELECT_STATEMENT__FROM:
				return from != null && !from.isEmpty();
			case DomPackage.SELECT_STATEMENT__JOIN:
				return join != null && !join.isEmpty();
			case DomPackage.SELECT_STATEMENT__WHERE:
				return where != null;
			case DomPackage.SELECT_STATEMENT__GROUP_BY:
				return groupBy != null && !groupBy.isEmpty();
			case DomPackage.SELECT_STATEMENT__HAVING:
				return having != null;
			case DomPackage.SELECT_STATEMENT__ORDER_BY:
				return orderBy != null && !orderBy.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //SelectStatementImpl
