/**
 * <copyright>
 * </copyright>
 *
 * $Id: ServiceImpl.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.impl.ModelElementImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.Dependant;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Service;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Service</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ServiceImpl#getDependencies <em>Dependencies</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ServiceImpl#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.openxma.dsl.dom.model.impl.ServiceImpl#getDelegateOperations <em>Delegate Operations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ServiceImpl extends ModelElementImpl implements Service {
	/**
	 * The cached value of the '{@link #getDependencies() <em>Dependencies</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDependencies()
	 * @generated
	 * @ordered
	 */
	protected EList<Dependant> dependencies;

	/**
	 * The cached value of the '{@link #getOperations() <em>Operations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperations()
	 * @generated
	 * @ordered
	 */
	protected EList<Operation> operations;

	/**
	 * The cached value of the '{@link #getDelegateOperations() <em>Delegate Operations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDelegateOperations()
	 * @generated
	 * @ordered
	 */
	protected EList<DelegateOperation> delegateOperations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DomPackage.Literals.SERVICE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Dependant> getDependencies() {
		if (dependencies == null) {
			dependencies = new EObjectResolvingEList<Dependant>(Dependant.class, this, DomPackage.SERVICE__DEPENDENCIES);
		}
		return dependencies;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DelegateOperation> getDelegateOperations() {
		if (delegateOperations == null) {
			delegateOperations = new EObjectContainmentEList<DelegateOperation>(DelegateOperation.class, this, DomPackage.SERVICE__DELEGATE_OPERATIONS);
		}
		return delegateOperations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Operation> getOperations() {
		if (operations == null) {
			operations = new EObjectContainmentEList<Operation>(Operation.class, this, DomPackage.SERVICE__OPERATIONS);
		}
		return operations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case DomPackage.SERVICE__OPERATIONS:
				return ((InternalEList<?>)getOperations()).basicRemove(otherEnd, msgs);
			case DomPackage.SERVICE__DELEGATE_OPERATIONS:
				return ((InternalEList<?>)getDelegateOperations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case DomPackage.SERVICE__DEPENDENCIES:
				return getDependencies();
			case DomPackage.SERVICE__OPERATIONS:
				return getOperations();
			case DomPackage.SERVICE__DELEGATE_OPERATIONS:
				return getDelegateOperations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case DomPackage.SERVICE__DEPENDENCIES:
				getDependencies().clear();
				getDependencies().addAll((Collection<? extends Dependant>)newValue);
				return;
			case DomPackage.SERVICE__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection<? extends Operation>)newValue);
				return;
			case DomPackage.SERVICE__DELEGATE_OPERATIONS:
				getDelegateOperations().clear();
				getDelegateOperations().addAll((Collection<? extends DelegateOperation>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case DomPackage.SERVICE__DEPENDENCIES:
				getDependencies().clear();
				return;
			case DomPackage.SERVICE__OPERATIONS:
				getOperations().clear();
				return;
			case DomPackage.SERVICE__DELEGATE_OPERATIONS:
				getDelegateOperations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case DomPackage.SERVICE__DEPENDENCIES:
				return dependencies != null && !dependencies.isEmpty();
			case DomPackage.SERVICE__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case DomPackage.SERVICE__DELEGATE_OPERATIONS:
				return delegateOperations != null && !delegateOperations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //ServiceImpl
