package org.openxma.dsl.dom.naming;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.FeatureReference;

import com.google.inject.Inject;

public class DomDslQualifiedNameProvider extends DefaultDeclarativeQualifiedNameProvider {
    @Inject
    private LinkingHelper linkingHelper;

    QualifiedName qualifiedName(FeatureReference featureReference) {
        if (featureReference.getName() != null) {
            return QualifiedName.create(featureReference.getName());
        }
        return getCrossReferenceAsString(featureReference, DomPackage.eINSTANCE.getFeatureReference_Attribute());
    }

    private QualifiedName getCrossReferenceAsString(EObject object, EReference eReference) {
        QualifiedName qualifiedName = null;
        List<INode> crossReferenceNodes = NodeModelUtils.findNodesForFeature(object, eReference);
        if (!crossReferenceNodes.isEmpty()) {
            LeafNode next = (LeafNode) crossReferenceNodes.iterator().next();
            String crossRefNodeAsString = null;
            if (linkingHelper != null) {
                crossRefNodeAsString = linkingHelper.getCrossRefNodeAsString(next, true);
            } else {
                crossRefNodeAsString = next.getText();
            }
            qualifiedName = QualifiedName.create(crossRefNodeAsString);
        }
        return qualifiedName;
    }
}
