package org.openxma.dsl.dom.naming;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.util.DomSwitch;

import com.google.common.base.Function;
import com.google.inject.Inject;

public class DomNameFunction extends DomSwitch<String> implements Function<EObject, QualifiedName> {
    private SimpleAttributeResolver<EObject, String> resolver = SimpleAttributeResolver.newResolver(String.class,
            "name");

    @Inject
    private LinkingHelper linkingHelper;

    public QualifiedName apply(EObject theEObject) {
        return QualifiedName.create(doSwitch(theEObject));
    }

    @Override
    public String defaultCase(EObject object) {
        return resolver.apply(object);
    }

    @Override
    public String caseFeatureReference(FeatureReference object) {
        String name = object.getName();
        if (name == null) {
            name = getCrossReferenceAsString(object, DomPackage.eINSTANCE.getFeatureReference_Attribute());
        }
        return name;
    }

    private String getCrossReferenceAsString(EObject object, EReference eReference) {
        List<INode> crossReferenceNodes = NodeModelUtils.findNodesForFeature(object, eReference);
        if (!crossReferenceNodes.isEmpty()) {
            LeafNode next = (LeafNode) crossReferenceNodes.iterator().next();
            String crossRefNodeAsString = null;
            if (linkingHelper != null) {
                crossRefNodeAsString = linkingHelper.getCrossRefNodeAsString(next, true);
            } else {
                crossRefNodeAsString = next.getText();
            }
            return crossRefNodeAsString;
        }
        return null;
    }

}
