package org.openxma.dsl.dom.parsetree.reconstr;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.CrossReferenceSerializer;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.dom.model.Service;

public class DomDslCrossReferenceSerializer extends CrossReferenceSerializer {

    @Override
    public String serializeCrossRef(EObject context, CrossReference grammarElement, final EObject target, INode node) {
        String serializedCrossRef = super.serializeCrossRef(context, grammarElement, target, node);
        if (null == serializedCrossRef && target instanceof Type) {
            serializedCrossRef = ((Type) target).getName();
        }
        if (null == serializedCrossRef && target instanceof Service) {
            EcoreUtil.resolveAll(context);
            serializedCrossRef = ((Service) target).getName();
        }
        return serializedCrossRef;
    }
}
