/*******************************************************************************
 * Copyright (c) 2010 s IT Solutions AT Spardat GmbH . All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: s IT Solutions AT Spardat GmbH - initial API and implementation
 *******************************************************************************/
package org.openxma.dsl.dom.resource;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.util.DomSwitch;

import com.google.common.base.Predicate;

public class DomDslResourceDescriptionStrategy extends DefaultResourceDescriptionStrategy {
    private static final Predicate<EObject> EXPORTED_OBJECTS_FILTER = new ExportedObjectsFilter();

    @Override
    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        return EXPORTED_OBJECTS_FILTER.apply(eObject) && super.createEObjectDescriptions(eObject, acceptor);
    }

    private static class ExportedObjectsFilter extends DomSwitch<Boolean> implements Predicate<EObject> {

        public boolean apply(EObject input) {
            return doSwitch(input);
        }

        @Override
        public Boolean caseAttribute(Attribute object) {
            return false;
        }

        @Override
        public Boolean caseFeatureReference(FeatureReference object) {
            return false;
        }

        @Override
        public Boolean caseOperation(Operation object) {
            return false;
        }

        @Override
        public Boolean caseQueryOperation(QueryOperation object) {
            return false;
        }

        @Override
        public Boolean defaultCase(EObject object) {
            return true;
        }

        @Override
        public Boolean caseFromClass(FromClass object) {
            return false;
        }

        @Override
        public Boolean caseParameter(Parameter object) {
            return false;
        }

        @Override
        public Boolean caseJoin(Join object) {
            return false;
        }

        @Override
        public Boolean caseExpression(Expression object) {
            return false;
        }

    }
}
