/**
 * <copyright>
 * </copyright>
 *
 * $Id: DomAdapterFactory.java 10224 2013-01-04 15:48:48Z dschwarz $
 */
package org.openxma.dsl.dom.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.openxma.dsl.core.model.IDocumentable;
import org.openxma.dsl.core.model.ModelElement;
import org.openxma.dsl.core.model.ReferenceableByXmadslVariable;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.*;
import org.openxma.dsl.dom.model.AggregateFunction;
import org.openxma.dsl.dom.model.AliasedExpression;
import org.openxma.dsl.dom.model.AltWhenClause;
import org.openxma.dsl.dom.model.ApplicationSession;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeFlag;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.AttributeSortOrder;
import org.openxma.dsl.dom.model.AttributeTextProperty;
import org.openxma.dsl.dom.model.AttributeValidationProperty;
import org.openxma.dsl.dom.model.AvailableFlag;
import org.openxma.dsl.dom.model.BetweenExpression;
import org.openxma.dsl.dom.model.BinaryExpression;
import org.openxma.dsl.dom.model.BooleanLiteralValue;
import org.openxma.dsl.dom.model.CallInputParameter;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;
import org.openxma.dsl.dom.model.CaseExpression;
import org.openxma.dsl.dom.model.CastFunction;
import org.openxma.dsl.dom.model.CollectionFunction;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DaoFeature;
import org.openxma.dsl.dom.model.DaoOperation;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.DeleteStatement;
import org.openxma.dsl.dom.model.Dependant;
import org.openxma.dsl.dom.model.DerivedFlag;
import org.openxma.dsl.dom.model.EmptyLiteralValue;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.ExpressionFlag;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.FromRange;
import org.openxma.dsl.dom.model.FunctionCall;
import org.openxma.dsl.dom.model.IElementWithNoName;
import org.openxma.dsl.dom.model.InClass;
import org.openxma.dsl.dom.model.InCollection;
import org.openxma.dsl.dom.model.InCollectionElements;
import org.openxma.dsl.dom.model.InExpression;
import org.openxma.dsl.dom.model.InsertStatement;
import org.openxma.dsl.dom.model.IntegerLiteralValue;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.JoinEntity;
import org.openxma.dsl.dom.model.LikeExpression;
import org.openxma.dsl.dom.model.LiteralValue;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.MemberOfExpression;
import org.openxma.dsl.dom.model.NotExpression;
import org.openxma.dsl.dom.model.NullLiteralValue;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.ParenthesizedExpression;
import org.openxma.dsl.dom.model.PresentableFeature;
import org.openxma.dsl.dom.model.Property;
import org.openxma.dsl.dom.model.PropertyAssignment;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.PropertyValue;
import org.openxma.dsl.dom.model.QlStatement;
import org.openxma.dsl.dom.model.QuantifiedExpression;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;
import org.openxma.dsl.dom.model.QueryParameterReference;
import org.openxma.dsl.dom.model.QueryParameterValue;
import org.openxma.dsl.dom.model.ReadOnlyFlag;
import org.openxma.dsl.dom.model.RealLiteralValue;
import org.openxma.dsl.dom.model.RequiredFlag;
import org.openxma.dsl.dom.model.SelectClass;
import org.openxma.dsl.dom.model.SelectObject;
import org.openxma.dsl.dom.model.SelectProperties;
import org.openxma.dsl.dom.model.SelectStatement;
import org.openxma.dsl.dom.model.Service;
import org.openxma.dsl.dom.model.SortOrderElement;
import org.openxma.dsl.dom.model.StringLiteralValue;
import org.openxma.dsl.dom.model.SubQuery;
import org.openxma.dsl.dom.model.TransientFlag;
import org.openxma.dsl.dom.model.TrimFunction;
import org.openxma.dsl.dom.model.UnaryExpression;
import org.openxma.dsl.dom.model.UpdateStatement;
import org.openxma.dsl.dom.model.ValueObject;
import org.openxma.dsl.dom.model.WhenClause;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.openxma.dsl.dom.DomPackage
 * @generated
 */
public class DomAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static DomPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DomAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = DomPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DomSwitch<Adapter> modelSwitch =
		new DomSwitch<Adapter>() {
			@Override
			public Adapter caseComplexType(ComplexType object) {
				return createComplexTypeAdapter();
			}
			@Override
			public Adapter caseService(Service object) {
				return createServiceAdapter();
			}
			@Override
			public Adapter caseDependant(Dependant object) {
				return createDependantAdapter();
			}
			@Override
			public Adapter caseProperty(Property object) {
				return createPropertyAdapter();
			}
			@Override
			public Adapter caseOperation(Operation object) {
				return createOperationAdapter();
			}
			@Override
			public Adapter caseParameter(Parameter object) {
				return createParameterAdapter();
			}
			@Override
			public Adapter caseDelegateOperation(DelegateOperation object) {
				return createDelegateOperationAdapter();
			}
			@Override
			public Adapter caseDaoOperation(DaoOperation object) {
				return createDaoOperationAdapter();
			}
			@Override
			public Adapter caseValueObject(ValueObject object) {
				return createValueObjectAdapter();
			}
			@Override
			public Adapter caseDataView(DataView object) {
				return createDataViewAdapter();
			}
			@Override
			public Adapter caseFeatureReference(FeatureReference object) {
				return createFeatureReferenceAdapter();
			}
			@Override
			public Adapter caseMapper(Mapper object) {
				return createMapperAdapter();
			}
			@Override
			public Adapter casePropertyMapping(PropertyMapping object) {
				return createPropertyMappingAdapter();
			}
			@Override
			public Adapter caseEntity(Entity object) {
				return createEntityAdapter();
			}
			@Override
			public Adapter caseAttribute(Attribute object) {
				return createAttributeAdapter();
			}
			@Override
			public Adapter caseAttributeFlag(AttributeFlag object) {
				return createAttributeFlagAdapter();
			}
			@Override
			public Adapter caseExpressionFlag(ExpressionFlag object) {
				return createExpressionFlagAdapter();
			}
			@Override
			public Adapter caseRequiredFlag(RequiredFlag object) {
				return createRequiredFlagAdapter();
			}
			@Override
			public Adapter caseReadOnlyFlag(ReadOnlyFlag object) {
				return createReadOnlyFlagAdapter();
			}
			@Override
			public Adapter caseAvailableFlag(AvailableFlag object) {
				return createAvailableFlagAdapter();
			}
			@Override
			public Adapter caseDerivedFlag(DerivedFlag object) {
				return createDerivedFlagAdapter();
			}
			@Override
			public Adapter caseTransientFlag(TransientFlag object) {
				return createTransientFlagAdapter();
			}
			@Override
			public Adapter caseAttributeProperty(AttributeProperty object) {
				return createAttributePropertyAdapter();
			}
			@Override
			public Adapter caseAttributeValidationProperty(AttributeValidationProperty object) {
				return createAttributeValidationPropertyAdapter();
			}
			@Override
			public Adapter caseAttributeTextProperty(AttributeTextProperty object) {
				return createAttributeTextPropertyAdapter();
			}
			@Override
			public Adapter caseAttributeGroup(AttributeGroup object) {
				return createAttributeGroupAdapter();
			}
			@Override
			public Adapter caseAttributeSortOrder(AttributeSortOrder object) {
				return createAttributeSortOrderAdapter();
			}
			@Override
			public Adapter caseDaoFeature(DaoFeature object) {
				return createDaoFeatureAdapter();
			}
			@Override
			public Adapter caseDao(Dao object) {
				return createDaoAdapter();
			}
			@Override
			public Adapter caseQueryOperation(QueryOperation object) {
				return createQueryOperationAdapter();
			}
			@Override
			public Adapter caseQueryParameter(QueryParameter object) {
				return createQueryParameterAdapter();
			}
			@Override
			public Adapter caseColumn(Column object) {
				return createColumnAdapter();
			}
			@Override
			public Adapter caseManyToOne(ManyToOne object) {
				return createManyToOneAdapter();
			}
			@Override
			public Adapter caseOneToOne(OneToOne object) {
				return createOneToOneAdapter();
			}
			@Override
			public Adapter caseOneToMany(OneToMany object) {
				return createOneToManyAdapter();
			}
			@Override
			public Adapter caseManyToMany(ManyToMany object) {
				return createManyToManyAdapter();
			}
			@Override
			public Adapter caseDataBaseConstraint(DataBaseConstraint object) {
				return createDataBaseConstraintAdapter();
			}
			@Override
			public Adapter caseApplicationSession(ApplicationSession object) {
				return createApplicationSessionAdapter();
			}
			@Override
			public Adapter caseQlStatement(QlStatement object) {
				return createQlStatementAdapter();
			}
			@Override
			public Adapter caseCallableStatement(CallableStatement object) {
				return createCallableStatementAdapter();
			}
			@Override
			public Adapter caseCallInputParameter(CallInputParameter object) {
				return createCallInputParameterAdapter();
			}
			@Override
			public Adapter caseCallOutputParameter(CallOutputParameter object) {
				return createCallOutputParameterAdapter();
			}
			@Override
			public Adapter caseInsertStatement(InsertStatement object) {
				return createInsertStatementAdapter();
			}
			@Override
			public Adapter caseDeleteStatement(DeleteStatement object) {
				return createDeleteStatementAdapter();
			}
			@Override
			public Adapter caseUpdateStatement(UpdateStatement object) {
				return createUpdateStatementAdapter();
			}
			@Override
			public Adapter casePropertyAssignment(PropertyAssignment object) {
				return createPropertyAssignmentAdapter();
			}
			@Override
			public Adapter caseSelectStatement(SelectStatement object) {
				return createSelectStatementAdapter();
			}
			@Override
			public Adapter caseSortOrderElement(SortOrderElement object) {
				return createSortOrderElementAdapter();
			}
			@Override
			public Adapter caseSelectProperties(SelectProperties object) {
				return createSelectPropertiesAdapter();
			}
			@Override
			public Adapter caseSelectClass(SelectClass object) {
				return createSelectClassAdapter();
			}
			@Override
			public Adapter caseSelectObject(SelectObject object) {
				return createSelectObjectAdapter();
			}
			@Override
			public Adapter caseFromRange(FromRange object) {
				return createFromRangeAdapter();
			}
			@Override
			public Adapter caseFromClass(FromClass object) {
				return createFromClassAdapter();
			}
			@Override
			public Adapter caseInClass(InClass object) {
				return createInClassAdapter();
			}
			@Override
			public Adapter caseInCollection(InCollection object) {
				return createInCollectionAdapter();
			}
			@Override
			public Adapter caseInCollectionElements(InCollectionElements object) {
				return createInCollectionElementsAdapter();
			}
			@Override
			public Adapter caseJoin(Join object) {
				return createJoinAdapter();
			}
			@Override
			public Adapter caseJoinEntity(JoinEntity object) {
				return createJoinEntityAdapter();
			}
			@Override
			public Adapter caseExpression(Expression object) {
				return createExpressionAdapter();
			}
			@Override
			public Adapter casePropertyValue(PropertyValue object) {
				return createPropertyValueAdapter();
			}
			@Override
			public Adapter caseFunctionCall(FunctionCall object) {
				return createFunctionCallAdapter();
			}
			@Override
			public Adapter caseTrimFunction(TrimFunction object) {
				return createTrimFunctionAdapter();
			}
			@Override
			public Adapter caseCastFunction(CastFunction object) {
				return createCastFunctionAdapter();
			}
			@Override
			public Adapter caseAggregateFunction(AggregateFunction object) {
				return createAggregateFunctionAdapter();
			}
			@Override
			public Adapter caseQueryParameterReference(QueryParameterReference object) {
				return createQueryParameterReferenceAdapter();
			}
			@Override
			public Adapter caseQueryParameterValue(QueryParameterValue object) {
				return createQueryParameterValueAdapter();
			}
			@Override
			public Adapter caseQuantifiedExpression(QuantifiedExpression object) {
				return createQuantifiedExpressionAdapter();
			}
			@Override
			public Adapter caseCaseExpression(CaseExpression object) {
				return createCaseExpressionAdapter();
			}
			@Override
			public Adapter caseWhenClause(WhenClause object) {
				return createWhenClauseAdapter();
			}
			@Override
			public Adapter caseAltWhenClause(AltWhenClause object) {
				return createAltWhenClauseAdapter();
			}
			@Override
			public Adapter caseCollectionFunction(CollectionFunction object) {
				return createCollectionFunctionAdapter();
			}
			@Override
			public Adapter caseSubQuery(SubQuery object) {
				return createSubQueryAdapter();
			}
			@Override
			public Adapter caseParenthesizedExpression(ParenthesizedExpression object) {
				return createParenthesizedExpressionAdapter();
			}
			@Override
			public Adapter caseLiteralValue(LiteralValue object) {
				return createLiteralValueAdapter();
			}
			@Override
			public Adapter caseStringLiteralValue(StringLiteralValue object) {
				return createStringLiteralValueAdapter();
			}
			@Override
			public Adapter caseIntegerLiteralValue(IntegerLiteralValue object) {
				return createIntegerLiteralValueAdapter();
			}
			@Override
			public Adapter caseRealLiteralValue(RealLiteralValue object) {
				return createRealLiteralValueAdapter();
			}
			@Override
			public Adapter caseBooleanLiteralValue(BooleanLiteralValue object) {
				return createBooleanLiteralValueAdapter();
			}
			@Override
			public Adapter caseNullLiteralValue(NullLiteralValue object) {
				return createNullLiteralValueAdapter();
			}
			@Override
			public Adapter caseEmptyLiteralValue(EmptyLiteralValue object) {
				return createEmptyLiteralValueAdapter();
			}
			@Override
			public Adapter caseIElementWithNoName(IElementWithNoName object) {
				return createIElementWithNoNameAdapter();
			}
			@Override
			public Adapter casePresentableFeature(PresentableFeature object) {
				return createPresentableFeatureAdapter();
			}
			@Override
			public Adapter caseAliasedExpression(AliasedExpression object) {
				return createAliasedExpressionAdapter();
			}
			@Override
			public Adapter caseBinaryExpression(BinaryExpression object) {
				return createBinaryExpressionAdapter();
			}
			@Override
			public Adapter caseNotExpression(NotExpression object) {
				return createNotExpressionAdapter();
			}
			@Override
			public Adapter caseInExpression(InExpression object) {
				return createInExpressionAdapter();
			}
			@Override
			public Adapter caseBetweenExpression(BetweenExpression object) {
				return createBetweenExpressionAdapter();
			}
			@Override
			public Adapter caseLikeExpression(LikeExpression object) {
				return createLikeExpressionAdapter();
			}
			@Override
			public Adapter caseMemberOfExpression(MemberOfExpression object) {
				return createMemberOfExpressionAdapter();
			}
			@Override
			public Adapter caseUnaryExpression(UnaryExpression object) {
				return createUnaryExpressionAdapter();
			}
			@Override
			public Adapter caseIDocumentable(IDocumentable object) {
				return createIDocumentableAdapter();
			}
			@Override
			public Adapter caseModelElement(ModelElement object) {
				return createModelElementAdapter();
			}
			@Override
			public Adapter caseType(Type object) {
				return createTypeAdapter();
			}
			@Override
			public Adapter caseReferenceableByXmadslVariable(ReferenceableByXmadslVariable object) {
				return createReferenceableByXmadslVariableAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Service <em>Service</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Service
	 * @generated
	 */
	public Adapter createServiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ComplexType <em>Complex Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ComplexType
	 * @generated
	 */
	public Adapter createComplexTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Dependant <em>Dependant</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Dependant
	 * @generated
	 */
	public Adapter createDependantAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Operation
	 * @generated
	 */
	public Adapter createOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DelegateOperation <em>Delegate Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DelegateOperation
	 * @generated
	 */
	public Adapter createDelegateOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DaoOperation <em>Dao Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DaoOperation
	 * @generated
	 */
	public Adapter createDaoOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Parameter
	 * @generated
	 */
	public Adapter createParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ValueObject <em>Value Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ValueObject
	 * @generated
	 */
	public Adapter createValueObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DataView <em>Data View</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DataView
	 * @generated
	 */
	public Adapter createDataViewAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.FeatureReference <em>Feature Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.FeatureReference
	 * @generated
	 */
	public Adapter createFeatureReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Mapper <em>Mapper</em>}'.
	 * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Mapper
	 * @generated
	 */
    public Adapter createMapperAdapter() {
		return null;
	}

    /**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.PropertyMapping <em>Property Mapping</em>}'.
	 * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.PropertyMapping
	 * @generated
	 */
    public Adapter createPropertyMappingAdapter() {
		return null;
	}

    /**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.IElementWithNoName <em>IElement With No Name</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.IElementWithNoName
	 * @generated
	 */
	public Adapter createIElementWithNoNameAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Entity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Entity
	 * @generated
	 */
	public Adapter createEntityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.QlStatement <em>Ql Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.QlStatement
	 * @generated
	 */
	public Adapter createQlStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.CallableStatement <em>Callable Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.CallableStatement
	 * @generated
	 */
	public Adapter createCallableStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.CallInputParameter <em>Call Input Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.CallInputParameter
	 * @generated
	 */
	public Adapter createCallInputParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.CallOutputParameter <em>Call Output Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.CallOutputParameter
	 * @generated
	 */
	public Adapter createCallOutputParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.InsertStatement <em>Insert Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.InsertStatement
	 * @generated
	 */
	public Adapter createInsertStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DeleteStatement <em>Delete Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DeleteStatement
	 * @generated
	 */
	public Adapter createDeleteStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.UpdateStatement <em>Update Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.UpdateStatement
	 * @generated
	 */
	public Adapter createUpdateStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.PropertyAssignment <em>Property Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.PropertyAssignment
	 * @generated
	 */
	public Adapter createPropertyAssignmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.SelectStatement <em>Select Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.SelectStatement
	 * @generated
	 */
	public Adapter createSelectStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.SortOrderElement <em>Sort Order Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.SortOrderElement
	 * @generated
	 */
	public Adapter createSortOrderElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.SelectProperties <em>Select Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.SelectProperties
	 * @generated
	 */
	public Adapter createSelectPropertiesAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.SelectClass <em>Select Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.SelectClass
	 * @generated
	 */
	public Adapter createSelectClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.SelectObject <em>Select Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.SelectObject
	 * @generated
	 */
	public Adapter createSelectObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.FromRange <em>From Range</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.FromRange
	 * @generated
	 */
	public Adapter createFromRangeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.FromClass <em>From Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.FromClass
	 * @generated
	 */
	public Adapter createFromClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.InClass <em>In Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.InClass
	 * @generated
	 */
	public Adapter createInClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.InCollection <em>In Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.InCollection
	 * @generated
	 */
	public Adapter createInCollectionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.InCollectionElements <em>In Collection Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.InCollectionElements
	 * @generated
	 */
	public Adapter createInCollectionElementsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Join <em>Join</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Join
	 * @generated
	 */
	public Adapter createJoinAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.JoinEntity <em>Join Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.JoinEntity
	 * @generated
	 */
	public Adapter createJoinEntityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Expression
	 * @generated
	 */
	public Adapter createExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.PropertyValue <em>Property Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.PropertyValue
	 * @generated
	 */
	public Adapter createPropertyValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.FunctionCall <em>Function Call</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.FunctionCall
	 * @generated
	 */
	public Adapter createFunctionCallAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.TrimFunction <em>Trim Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.TrimFunction
	 * @generated
	 */
	public Adapter createTrimFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.CastFunction <em>Cast Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.CastFunction
	 * @generated
	 */
	public Adapter createCastFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AggregateFunction <em>Aggregate Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AggregateFunction
	 * @generated
	 */
	public Adapter createAggregateFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.QueryParameterReference <em>Query Parameter Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.QueryParameterReference
	 * @generated
	 */
	public Adapter createQueryParameterReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.QueryParameterValue <em>Query Parameter Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.QueryParameterValue
	 * @generated
	 */
	public Adapter createQueryParameterValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.QuantifiedExpression <em>Quantified Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.QuantifiedExpression
	 * @generated
	 */
	public Adapter createQuantifiedExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.CaseExpression <em>Case Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.CaseExpression
	 * @generated
	 */
	public Adapter createCaseExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.WhenClause <em>When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.WhenClause
	 * @generated
	 */
	public Adapter createWhenClauseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AltWhenClause <em>Alt When Clause</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AltWhenClause
	 * @generated
	 */
	public Adapter createAltWhenClauseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.CollectionFunction <em>Collection Function</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.CollectionFunction
	 * @generated
	 */
	public Adapter createCollectionFunctionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.SubQuery <em>Sub Query</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.SubQuery
	 * @generated
	 */
	public Adapter createSubQueryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ParenthesizedExpression <em>Parenthesized Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ParenthesizedExpression
	 * @generated
	 */
	public Adapter createParenthesizedExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.LiteralValue <em>Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.LiteralValue
	 * @generated
	 */
	public Adapter createLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.StringLiteralValue <em>String Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.StringLiteralValue
	 * @generated
	 */
	public Adapter createStringLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.IntegerLiteralValue <em>Integer Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.IntegerLiteralValue
	 * @generated
	 */
	public Adapter createIntegerLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.RealLiteralValue <em>Real Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.RealLiteralValue
	 * @generated
	 */
	public Adapter createRealLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.BooleanLiteralValue <em>Boolean Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.BooleanLiteralValue
	 * @generated
	 */
	public Adapter createBooleanLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.NullLiteralValue <em>Null Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.NullLiteralValue
	 * @generated
	 */
	public Adapter createNullLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.EmptyLiteralValue <em>Empty Literal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.EmptyLiteralValue
	 * @generated
	 */
	public Adapter createEmptyLiteralValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DaoFeature <em>Dao Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DaoFeature
	 * @generated
	 */
	public Adapter createDaoFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Dao <em>Dao</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Dao
	 * @generated
	 */
	public Adapter createDaoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.QueryOperation <em>Query Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.QueryOperation
	 * @generated
	 */
	public Adapter createQueryOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.QueryParameter <em>Query Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.QueryParameter
	 * @generated
	 */
	public Adapter createQueryParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Column <em>Column</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Column
	 * @generated
	 */
	public Adapter createColumnAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ManyToOne <em>Many To One</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ManyToOne
	 * @generated
	 */
	public Adapter createManyToOneAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.OneToOne <em>One To One</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.OneToOne
	 * @generated
	 */
	public Adapter createOneToOneAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.OneToMany <em>One To Many</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.OneToMany
	 * @generated
	 */
	public Adapter createOneToManyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ManyToMany <em>Many To Many</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ManyToMany
	 * @generated
	 */
	public Adapter createManyToManyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.PresentableFeature <em>Presentable Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.PresentableFeature
	 * @generated
	 */
	public Adapter createPresentableFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AliasedExpression <em>Aliased Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AliasedExpression
	 * @generated
	 */
	public Adapter createAliasedExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.BinaryExpression <em>Binary Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.BinaryExpression
	 * @generated
	 */
	public Adapter createBinaryExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.NotExpression <em>Not Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.NotExpression
	 * @generated
	 */
	public Adapter createNotExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.InExpression <em>In Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.InExpression
	 * @generated
	 */
	public Adapter createInExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.BetweenExpression <em>Between Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.BetweenExpression
	 * @generated
	 */
	public Adapter createBetweenExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.LikeExpression <em>Like Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.LikeExpression
	 * @generated
	 */
	public Adapter createLikeExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.MemberOfExpression <em>Member Of Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.MemberOfExpression
	 * @generated
	 */
	public Adapter createMemberOfExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.UnaryExpression <em>Unary Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.UnaryExpression
	 * @generated
	 */
	public Adapter createUnaryExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.core.model.IDocumentable <em>IDocumentable</em>}'.
	 * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.core.model.IDocumentable
	 * @generated
	 */
    public Adapter createIDocumentableAdapter() {
		return null;
	}

    /**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DataBaseConstraint <em>Data Base Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DataBaseConstraint
	 * @generated
	 */
	public Adapter createDataBaseConstraintAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Attribute
	 * @generated
	 */
	public Adapter createAttributeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AttributeFlag <em>Attribute Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AttributeFlag
	 * @generated
	 */
	public Adapter createAttributeFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ExpressionFlag <em>Expression Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ExpressionFlag
	 * @generated
	 */
	public Adapter createExpressionFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.RequiredFlag <em>Required Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.RequiredFlag
	 * @generated
	 */
	public Adapter createRequiredFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ReadOnlyFlag <em>Read Only Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ReadOnlyFlag
	 * @generated
	 */
	public Adapter createReadOnlyFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AvailableFlag <em>Available Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AvailableFlag
	 * @generated
	 */
	public Adapter createAvailableFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.DerivedFlag <em>Derived Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.DerivedFlag
	 * @generated
	 */
	public Adapter createDerivedFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.TransientFlag <em>Transient Flag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.TransientFlag
	 * @generated
	 */
	public Adapter createTransientFlagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AttributeProperty <em>Attribute Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AttributeProperty
	 * @generated
	 */
	public Adapter createAttributePropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AttributeValidationProperty <em>Attribute Validation Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AttributeValidationProperty
	 * @generated
	 */
	public Adapter createAttributeValidationPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AttributeTextProperty <em>Attribute Text Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AttributeTextProperty
	 * @generated
	 */
	public Adapter createAttributeTextPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AttributeGroup <em>Attribute Group</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AttributeGroup
	 * @generated
	 */
	public Adapter createAttributeGroupAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.AttributeSortOrder <em>Attribute Sort Order</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.AttributeSortOrder
	 * @generated
	 */
	public Adapter createAttributeSortOrderAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.core.model.ReferenceableByXmadslVariable <em>Referenceable By Xmadsl Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.core.model.ReferenceableByXmadslVariable
	 * @generated
	 */
	public Adapter createReferenceableByXmadslVariableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.Property <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.Property
	 * @generated
	 */
	public Adapter createPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.dom.model.ApplicationSession <em>Application Session</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.dom.model.ApplicationSession
	 * @generated
	 */
	public Adapter createApplicationSessionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.core.model.ModelElement <em>Model Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.core.model.ModelElement
	 * @generated
	 */
	public Adapter createModelElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.openxma.dsl.core.model.Type <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.openxma.dsl.core.model.Type
	 * @generated
	 */
	public Adapter createTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //DomAdapterFactory
