/**
 * <copyright>
 * </copyright>
 *
 * $Id: DomSwitch.java 10627 2013-04-10 09:59:28Z dschwarz $
 */
package org.openxma.dsl.dom.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.openxma.dsl.core.model.IDocumentable;
import org.openxma.dsl.core.model.ModelElement;
import org.openxma.dsl.core.model.ReferenceableByXmadslVariable;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.*;
import org.openxma.dsl.dom.model.AggregateFunction;
import org.openxma.dsl.dom.model.AliasedExpression;
import org.openxma.dsl.dom.model.AltWhenClause;
import org.openxma.dsl.dom.model.ApplicationSession;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeFlag;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.AttributeProperty;
import org.openxma.dsl.dom.model.AttributeSortOrder;
import org.openxma.dsl.dom.model.AttributeTextProperty;
import org.openxma.dsl.dom.model.AttributeValidationProperty;
import org.openxma.dsl.dom.model.AvailableFlag;
import org.openxma.dsl.dom.model.BetweenExpression;
import org.openxma.dsl.dom.model.BinaryExpression;
import org.openxma.dsl.dom.model.BooleanLiteralValue;
import org.openxma.dsl.dom.model.CallInputParameter;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;
import org.openxma.dsl.dom.model.CaseExpression;
import org.openxma.dsl.dom.model.CastFunction;
import org.openxma.dsl.dom.model.CollectionFunction;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DaoFeature;
import org.openxma.dsl.dom.model.DaoOperation;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.DeleteStatement;
import org.openxma.dsl.dom.model.Dependant;
import org.openxma.dsl.dom.model.DerivedFlag;
import org.openxma.dsl.dom.model.EmptyLiteralValue;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.Expression;
import org.openxma.dsl.dom.model.ExpressionFlag;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.FromRange;
import org.openxma.dsl.dom.model.FunctionCall;
import org.openxma.dsl.dom.model.IElementWithNoName;
import org.openxma.dsl.dom.model.InClass;
import org.openxma.dsl.dom.model.InCollection;
import org.openxma.dsl.dom.model.InCollectionElements;
import org.openxma.dsl.dom.model.InExpression;
import org.openxma.dsl.dom.model.InsertStatement;
import org.openxma.dsl.dom.model.IntegerLiteralValue;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.JoinEntity;
import org.openxma.dsl.dom.model.LikeExpression;
import org.openxma.dsl.dom.model.LiteralValue;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.MemberOfExpression;
import org.openxma.dsl.dom.model.NotExpression;
import org.openxma.dsl.dom.model.NullLiteralValue;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.ParenthesizedExpression;
import org.openxma.dsl.dom.model.PresentableFeature;
import org.openxma.dsl.dom.model.Property;
import org.openxma.dsl.dom.model.PropertyAssignment;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.PropertyValue;
import org.openxma.dsl.dom.model.QlStatement;
import org.openxma.dsl.dom.model.QuantifiedExpression;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;
import org.openxma.dsl.dom.model.QueryParameterReference;
import org.openxma.dsl.dom.model.QueryParameterValue;
import org.openxma.dsl.dom.model.ReadOnlyFlag;
import org.openxma.dsl.dom.model.RealLiteralValue;
import org.openxma.dsl.dom.model.RequiredFlag;
import org.openxma.dsl.dom.model.SelectClass;
import org.openxma.dsl.dom.model.SelectObject;
import org.openxma.dsl.dom.model.SelectProperties;
import org.openxma.dsl.dom.model.SelectStatement;
import org.openxma.dsl.dom.model.Service;
import org.openxma.dsl.dom.model.SortOrderElement;
import org.openxma.dsl.dom.model.StringLiteralValue;
import org.openxma.dsl.dom.model.SubQuery;
import org.openxma.dsl.dom.model.TransientFlag;
import org.openxma.dsl.dom.model.TrimFunction;
import org.openxma.dsl.dom.model.UnaryExpression;
import org.openxma.dsl.dom.model.UpdateStatement;
import org.openxma.dsl.dom.model.ValueObject;
import org.openxma.dsl.dom.model.WhenClause;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see org.openxma.dsl.dom.DomPackage
 * @generated
 */
public class DomSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static DomPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DomSwitch() {
		if (modelPackage == null) {
			modelPackage = DomPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated NOT
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch((EClass) (theEObject instanceof EClass ? theEObject : theEObject.eClass()), 
				theEObject instanceof EClass ? null : theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case DomPackage.COMPLEX_TYPE: {
				ComplexType complexType = (ComplexType)theEObject;
				T result = caseComplexType(complexType);
				if (result == null) result = caseType(complexType);
				if (result == null) result = caseModelElement(complexType);
				if (result == null) result = caseIDocumentable(complexType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SERVICE: {
				Service service = (Service)theEObject;
				T result = caseService(service);
				if (result == null) result = caseModelElement(service);
				if (result == null) result = caseDependant(service);
				if (result == null) result = caseIDocumentable(service);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DEPENDANT: {
				Dependant dependant = (Dependant)theEObject;
				T result = caseDependant(dependant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PROPERTY: {
				Property property = (Property)theEObject;
				T result = caseProperty(property);
				if (result == null) result = caseReferenceableByXmadslVariable(property);
				if (result == null) result = caseIDocumentable(property);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.OPERATION: {
				Operation operation = (Operation)theEObject;
				T result = caseOperation(operation);
				if (result == null) result = caseDaoOperation(operation);
				if (result == null) result = caseIDocumentable(operation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PARAMETER: {
				Parameter parameter = (Parameter)theEObject;
				T result = caseParameter(parameter);
				if (result == null) result = caseQueryParameter(parameter);
				if (result == null) result = caseQueryParameterReference(parameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DELEGATE_OPERATION: {
				DelegateOperation delegateOperation = (DelegateOperation)theEObject;
				T result = caseDelegateOperation(delegateOperation);
				if (result == null) result = caseIDocumentable(delegateOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DAO_OPERATION: {
				DaoOperation daoOperation = (DaoOperation)theEObject;
				T result = caseDaoOperation(daoOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.VALUE_OBJECT: {
				ValueObject valueObject = (ValueObject)theEObject;
				T result = caseValueObject(valueObject);
				if (result == null) result = caseComplexType(valueObject);
				if (result == null) result = caseType(valueObject);
				if (result == null) result = caseModelElement(valueObject);
				if (result == null) result = caseIDocumentable(valueObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DATA_VIEW: {
				DataView dataView = (DataView)theEObject;
				T result = caseDataView(dataView);
				if (result == null) result = caseComplexType(dataView);
				if (result == null) result = caseType(dataView);
				if (result == null) result = caseModelElement(dataView);
				if (result == null) result = caseIDocumentable(dataView);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.FEATURE_REFERENCE: {
				FeatureReference featureReference = (FeatureReference)theEObject;
				T result = caseFeatureReference(featureReference);
				if (result == null) result = casePresentableFeature(featureReference);
				if (result == null) result = caseIDocumentable(featureReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.MAPPER: {
				Mapper mapper = (Mapper)theEObject;
				T result = caseMapper(mapper);
				if (result == null) result = caseModelElement(mapper);
				if (result == null) result = caseIDocumentable(mapper);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PROPERTY_MAPPING: {
				PropertyMapping propertyMapping = (PropertyMapping)theEObject;
				T result = casePropertyMapping(propertyMapping);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ENTITY: {
				Entity entity = (Entity)theEObject;
				T result = caseEntity(entity);
				if (result == null) result = caseComplexType(entity);
				if (result == null) result = caseDependant(entity);
				if (result == null) result = caseType(entity);
				if (result == null) result = caseModelElement(entity);
				if (result == null) result = caseIDocumentable(entity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE: {
				Attribute attribute = (Attribute)theEObject;
				T result = caseAttribute(attribute);
				if (result == null) result = caseReferenceableByXmadslVariable(attribute);
				if (result == null) result = caseQueryParameterReference(attribute);
				if (result == null) result = casePresentableFeature(attribute);
				if (result == null) result = caseIDocumentable(attribute);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE_FLAG: {
				AttributeFlag attributeFlag = (AttributeFlag)theEObject;
				T result = caseAttributeFlag(attributeFlag);
				if (result == null) result = caseAttributeProperty(attributeFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.EXPRESSION_FLAG: {
				ExpressionFlag expressionFlag = (ExpressionFlag)theEObject;
				T result = caseExpressionFlag(expressionFlag);
				if (result == null) result = caseAttributeFlag(expressionFlag);
				if (result == null) result = caseAttributeProperty(expressionFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.REQUIRED_FLAG: {
				RequiredFlag requiredFlag = (RequiredFlag)theEObject;
				T result = caseRequiredFlag(requiredFlag);
				if (result == null) result = caseExpressionFlag(requiredFlag);
				if (result == null) result = caseAttributeFlag(requiredFlag);
				if (result == null) result = caseAttributeProperty(requiredFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.READ_ONLY_FLAG: {
				ReadOnlyFlag readOnlyFlag = (ReadOnlyFlag)theEObject;
				T result = caseReadOnlyFlag(readOnlyFlag);
				if (result == null) result = caseExpressionFlag(readOnlyFlag);
				if (result == null) result = caseAttributeFlag(readOnlyFlag);
				if (result == null) result = caseAttributeProperty(readOnlyFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.AVAILABLE_FLAG: {
				AvailableFlag availableFlag = (AvailableFlag)theEObject;
				T result = caseAvailableFlag(availableFlag);
				if (result == null) result = caseExpressionFlag(availableFlag);
				if (result == null) result = caseAttributeFlag(availableFlag);
				if (result == null) result = caseAttributeProperty(availableFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DERIVED_FLAG: {
				DerivedFlag derivedFlag = (DerivedFlag)theEObject;
				T result = caseDerivedFlag(derivedFlag);
				if (result == null) result = caseAttributeFlag(derivedFlag);
				if (result == null) result = caseAttributeProperty(derivedFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.TRANSIENT_FLAG: {
				TransientFlag transientFlag = (TransientFlag)theEObject;
				T result = caseTransientFlag(transientFlag);
				if (result == null) result = caseAttributeFlag(transientFlag);
				if (result == null) result = caseAttributeProperty(transientFlag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE_PROPERTY: {
				AttributeProperty attributeProperty = (AttributeProperty)theEObject;
				T result = caseAttributeProperty(attributeProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE_VALIDATION_PROPERTY: {
				AttributeValidationProperty attributeValidationProperty = (AttributeValidationProperty)theEObject;
				T result = caseAttributeValidationProperty(attributeValidationProperty);
				if (result == null) result = caseAttributeProperty(attributeValidationProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE_TEXT_PROPERTY: {
				AttributeTextProperty attributeTextProperty = (AttributeTextProperty)theEObject;
				T result = caseAttributeTextProperty(attributeTextProperty);
				if (result == null) result = caseAttributeProperty(attributeTextProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE_GROUP: {
				AttributeGroup attributeGroup = (AttributeGroup)theEObject;
				T result = caseAttributeGroup(attributeGroup);
				if (result == null) result = caseIDocumentable(attributeGroup);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ATTRIBUTE_SORT_ORDER: {
				AttributeSortOrder attributeSortOrder = (AttributeSortOrder)theEObject;
				T result = caseAttributeSortOrder(attributeSortOrder);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DAO_FEATURE: {
				DaoFeature daoFeature = (DaoFeature)theEObject;
				T result = caseDaoFeature(daoFeature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DAO: {
				Dao dao = (Dao)theEObject;
				T result = caseDao(dao);
				if (result == null) result = caseModelElement(dao);
				if (result == null) result = caseDependant(dao);
				if (result == null) result = caseIDocumentable(dao);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.QUERY_OPERATION: {
				QueryOperation queryOperation = (QueryOperation)theEObject;
				T result = caseQueryOperation(queryOperation);
				if (result == null) result = caseDaoOperation(queryOperation);
				if (result == null) result = caseIDocumentable(queryOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.QUERY_PARAMETER: {
				QueryParameter queryParameter = (QueryParameter)theEObject;
				T result = caseQueryParameter(queryParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.COLUMN: {
				Column column = (Column)theEObject;
				T result = caseColumn(column);
				if (result == null) result = caseDaoFeature(column);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.MANY_TO_ONE: {
				ManyToOne manyToOne = (ManyToOne)theEObject;
				T result = caseManyToOne(manyToOne);
				if (result == null) result = caseDaoFeature(manyToOne);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ONE_TO_ONE: {
				OneToOne oneToOne = (OneToOne)theEObject;
				T result = caseOneToOne(oneToOne);
				if (result == null) result = caseDaoFeature(oneToOne);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ONE_TO_MANY: {
				OneToMany oneToMany = (OneToMany)theEObject;
				T result = caseOneToMany(oneToMany);
				if (result == null) result = caseDaoFeature(oneToMany);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.MANY_TO_MANY: {
				ManyToMany manyToMany = (ManyToMany)theEObject;
				T result = caseManyToMany(manyToMany);
				if (result == null) result = caseDaoFeature(manyToMany);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DATA_BASE_CONSTRAINT: {
				DataBaseConstraint dataBaseConstraint = (DataBaseConstraint)theEObject;
				T result = caseDataBaseConstraint(dataBaseConstraint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.APPLICATION_SESSION: {
				ApplicationSession applicationSession = (ApplicationSession)theEObject;
				T result = caseApplicationSession(applicationSession);
				if (result == null) result = caseModelElement(applicationSession);
				if (result == null) result = caseIDocumentable(applicationSession);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.QL_STATEMENT: {
				QlStatement qlStatement = (QlStatement)theEObject;
				T result = caseQlStatement(qlStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.CALLABLE_STATEMENT: {
				CallableStatement callableStatement = (CallableStatement)theEObject;
				T result = caseCallableStatement(callableStatement);
				if (result == null) result = caseQlStatement(callableStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.CALL_INPUT_PARAMETER: {
				CallInputParameter callInputParameter = (CallInputParameter)theEObject;
				T result = caseCallInputParameter(callInputParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.CALL_OUTPUT_PARAMETER: {
				CallOutputParameter callOutputParameter = (CallOutputParameter)theEObject;
				T result = caseCallOutputParameter(callOutputParameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.INSERT_STATEMENT: {
				InsertStatement insertStatement = (InsertStatement)theEObject;
				T result = caseInsertStatement(insertStatement);
				if (result == null) result = caseQlStatement(insertStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.DELETE_STATEMENT: {
				DeleteStatement deleteStatement = (DeleteStatement)theEObject;
				T result = caseDeleteStatement(deleteStatement);
				if (result == null) result = caseQlStatement(deleteStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.UPDATE_STATEMENT: {
				UpdateStatement updateStatement = (UpdateStatement)theEObject;
				T result = caseUpdateStatement(updateStatement);
				if (result == null) result = caseQlStatement(updateStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PROPERTY_ASSIGNMENT: {
				PropertyAssignment propertyAssignment = (PropertyAssignment)theEObject;
				T result = casePropertyAssignment(propertyAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SELECT_STATEMENT: {
				SelectStatement selectStatement = (SelectStatement)theEObject;
				T result = caseSelectStatement(selectStatement);
				if (result == null) result = caseQlStatement(selectStatement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SORT_ORDER_ELEMENT: {
				SortOrderElement sortOrderElement = (SortOrderElement)theEObject;
				T result = caseSortOrderElement(sortOrderElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SELECT_PROPERTIES: {
				SelectProperties selectProperties = (SelectProperties)theEObject;
				T result = caseSelectProperties(selectProperties);
				if (result == null) result = caseSelectStatement(selectProperties);
				if (result == null) result = caseQlStatement(selectProperties);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SELECT_CLASS: {
				SelectClass selectClass = (SelectClass)theEObject;
				T result = caseSelectClass(selectClass);
				if (result == null) result = caseSelectStatement(selectClass);
				if (result == null) result = caseQlStatement(selectClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SELECT_OBJECT: {
				SelectObject selectObject = (SelectObject)theEObject;
				T result = caseSelectObject(selectObject);
				if (result == null) result = caseSelectStatement(selectObject);
				if (result == null) result = caseQlStatement(selectObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.FROM_RANGE: {
				FromRange fromRange = (FromRange)theEObject;
				T result = caseFromRange(fromRange);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.FROM_CLASS: {
				FromClass fromClass = (FromClass)theEObject;
				T result = caseFromClass(fromClass);
				if (result == null) result = caseFromRange(fromClass);
				if (result == null) result = caseJoinEntity(fromClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.IN_CLASS: {
				InClass inClass = (InClass)theEObject;
				T result = caseInClass(inClass);
				if (result == null) result = caseFromRange(inClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.IN_COLLECTION: {
				InCollection inCollection = (InCollection)theEObject;
				T result = caseInCollection(inCollection);
				if (result == null) result = caseFromRange(inCollection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.IN_COLLECTION_ELEMENTS: {
				InCollectionElements inCollectionElements = (InCollectionElements)theEObject;
				T result = caseInCollectionElements(inCollectionElements);
				if (result == null) result = caseFromRange(inCollectionElements);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.JOIN: {
				Join join = (Join)theEObject;
				T result = caseJoin(join);
				if (result == null) result = caseJoinEntity(join);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.JOIN_ENTITY: {
				JoinEntity joinEntity = (JoinEntity)theEObject;
				T result = caseJoinEntity(joinEntity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.EXPRESSION: {
				Expression expression = (Expression)theEObject;
				T result = caseExpression(expression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PROPERTY_VALUE: {
				PropertyValue propertyValue = (PropertyValue)theEObject;
				T result = casePropertyValue(propertyValue);
				if (result == null) result = caseExpression(propertyValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.FUNCTION_CALL: {
				FunctionCall functionCall = (FunctionCall)theEObject;
				T result = caseFunctionCall(functionCall);
				if (result == null) result = caseExpression(functionCall);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.TRIM_FUNCTION: {
				TrimFunction trimFunction = (TrimFunction)theEObject;
				T result = caseTrimFunction(trimFunction);
				if (result == null) result = caseExpression(trimFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.CAST_FUNCTION: {
				CastFunction castFunction = (CastFunction)theEObject;
				T result = caseCastFunction(castFunction);
				if (result == null) result = caseExpression(castFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.AGGREGATE_FUNCTION: {
				AggregateFunction aggregateFunction = (AggregateFunction)theEObject;
				T result = caseAggregateFunction(aggregateFunction);
				if (result == null) result = caseExpression(aggregateFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.QUERY_PARAMETER_REFERENCE: {
				QueryParameterReference queryParameterReference = (QueryParameterReference)theEObject;
				T result = caseQueryParameterReference(queryParameterReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.QUERY_PARAMETER_VALUE: {
				QueryParameterValue queryParameterValue = (QueryParameterValue)theEObject;
				T result = caseQueryParameterValue(queryParameterValue);
				if (result == null) result = caseExpression(queryParameterValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.QUANTIFIED_EXPRESSION: {
				QuantifiedExpression quantifiedExpression = (QuantifiedExpression)theEObject;
				T result = caseQuantifiedExpression(quantifiedExpression);
				if (result == null) result = caseExpression(quantifiedExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.CASE_EXPRESSION: {
				CaseExpression caseExpression = (CaseExpression)theEObject;
				T result = caseCaseExpression(caseExpression);
				if (result == null) result = caseExpression(caseExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.WHEN_CLAUSE: {
				WhenClause whenClause = (WhenClause)theEObject;
				T result = caseWhenClause(whenClause);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ALT_WHEN_CLAUSE: {
				AltWhenClause altWhenClause = (AltWhenClause)theEObject;
				T result = caseAltWhenClause(altWhenClause);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.COLLECTION_FUNCTION: {
				CollectionFunction collectionFunction = (CollectionFunction)theEObject;
				T result = caseCollectionFunction(collectionFunction);
				if (result == null) result = caseExpression(collectionFunction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.SUB_QUERY: {
				SubQuery subQuery = (SubQuery)theEObject;
				T result = caseSubQuery(subQuery);
				if (result == null) result = caseExpression(subQuery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PARENTHESIZED_EXPRESSION: {
				ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)theEObject;
				T result = caseParenthesizedExpression(parenthesizedExpression);
				if (result == null) result = caseExpression(parenthesizedExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.LITERAL_VALUE: {
				LiteralValue literalValue = (LiteralValue)theEObject;
				T result = caseLiteralValue(literalValue);
				if (result == null) result = caseExpression(literalValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.STRING_LITERAL_VALUE: {
				StringLiteralValue stringLiteralValue = (StringLiteralValue)theEObject;
				T result = caseStringLiteralValue(stringLiteralValue);
				if (result == null) result = caseLiteralValue(stringLiteralValue);
				if (result == null) result = caseExpression(stringLiteralValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.INTEGER_LITERAL_VALUE: {
				IntegerLiteralValue integerLiteralValue = (IntegerLiteralValue)theEObject;
				T result = caseIntegerLiteralValue(integerLiteralValue);
				if (result == null) result = caseLiteralValue(integerLiteralValue);
				if (result == null) result = caseExpression(integerLiteralValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.REAL_LITERAL_VALUE: {
				RealLiteralValue realLiteralValue = (RealLiteralValue)theEObject;
				T result = caseRealLiteralValue(realLiteralValue);
				if (result == null) result = caseLiteralValue(realLiteralValue);
				if (result == null) result = caseExpression(realLiteralValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.BOOLEAN_LITERAL_VALUE: {
				BooleanLiteralValue booleanLiteralValue = (BooleanLiteralValue)theEObject;
				T result = caseBooleanLiteralValue(booleanLiteralValue);
				if (result == null) result = caseLiteralValue(booleanLiteralValue);
				if (result == null) result = caseExpression(booleanLiteralValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.NULL_LITERAL_VALUE: {
				NullLiteralValue nullLiteralValue = (NullLiteralValue)theEObject;
				T result = caseNullLiteralValue(nullLiteralValue);
				if (result == null) result = caseLiteralValue(nullLiteralValue);
				if (result == null) result = caseExpression(nullLiteralValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.EMPTY_LITERAL_VALUE: {
				EmptyLiteralValue emptyLiteralValue = (EmptyLiteralValue)theEObject;
				T result = caseEmptyLiteralValue(emptyLiteralValue);
				if (result == null) result = caseLiteralValue(emptyLiteralValue);
				if (result == null) result = caseExpression(emptyLiteralValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.IELEMENT_WITH_NO_NAME: {
				IElementWithNoName iElementWithNoName = (IElementWithNoName)theEObject;
				T result = caseIElementWithNoName(iElementWithNoName);
				if (result == null) result = caseReferenceableByXmadslVariable(iElementWithNoName);
				if (result == null) result = caseQueryParameterReference(iElementWithNoName);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.PRESENTABLE_FEATURE: {
				PresentableFeature presentableFeature = (PresentableFeature)theEObject;
				T result = casePresentableFeature(presentableFeature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.ALIASED_EXPRESSION: {
				AliasedExpression aliasedExpression = (AliasedExpression)theEObject;
				T result = caseAliasedExpression(aliasedExpression);
				if (result == null) result = caseExpression(aliasedExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.BINARY_EXPRESSION: {
				BinaryExpression binaryExpression = (BinaryExpression)theEObject;
				T result = caseBinaryExpression(binaryExpression);
				if (result == null) result = caseExpression(binaryExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.NOT_EXPRESSION: {
				NotExpression notExpression = (NotExpression)theEObject;
				T result = caseNotExpression(notExpression);
				if (result == null) result = caseExpression(notExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.IN_EXPRESSION: {
				InExpression inExpression = (InExpression)theEObject;
				T result = caseInExpression(inExpression);
				if (result == null) result = caseExpression(inExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.BETWEEN_EXPRESSION: {
				BetweenExpression betweenExpression = (BetweenExpression)theEObject;
				T result = caseBetweenExpression(betweenExpression);
				if (result == null) result = caseExpression(betweenExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.LIKE_EXPRESSION: {
				LikeExpression likeExpression = (LikeExpression)theEObject;
				T result = caseLikeExpression(likeExpression);
				if (result == null) result = caseExpression(likeExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.MEMBER_OF_EXPRESSION: {
				MemberOfExpression memberOfExpression = (MemberOfExpression)theEObject;
				T result = caseMemberOfExpression(memberOfExpression);
				if (result == null) result = caseExpression(memberOfExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case DomPackage.UNARY_EXPRESSION: {
				UnaryExpression unaryExpression = (UnaryExpression)theEObject;
				T result = caseUnaryExpression(unaryExpression);
				if (result == null) result = caseExpression(unaryExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Service</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Service</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseService(Service object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Complex Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Complex Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComplexType(ComplexType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dependant</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dependant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDependant(Dependant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operation</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperation(Operation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Delegate Operation</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Delegate Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDelegateOperation(DelegateOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dao Operation</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dao Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDaoOperation(DaoOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameter(Parameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Value Object</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Value Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseValueObject(ValueObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data View</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataView(DataView object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature Reference</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFeatureReference(FeatureReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mapper</em>'.
	 * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mapper</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
    public T caseMapper(Mapper object) {
		return null;
	}

    /**
	 * Returns the result of interpreting the object as an instance of '<em>Property Mapping</em>'.
	 * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Mapping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
    public T casePropertyMapping(PropertyMapping object) {
		return null;
	}

    /**
	 * Returns the result of interpreting the object as an instance of '<em>IElement With No Name</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IElement With No Name</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIElementWithNoName(IElementWithNoName object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ql Statement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ql Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQlStatement(QlStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Callable Statement</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Callable Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCallableStatement(CallableStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Call Input Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Call Input Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCallInputParameter(CallInputParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Call Output Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Call Output Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCallOutputParameter(CallOutputParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Insert Statement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Insert Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInsertStatement(InsertStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Delete Statement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Delete Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeleteStatement(DeleteStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Update Statement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Update Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUpdateStatement(UpdateStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Assignment</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyAssignment(PropertyAssignment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Select Statement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Select Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelectStatement(SelectStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sort Order Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sort Order Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSortOrderElement(SortOrderElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Select Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Select Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelectProperties(SelectProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Select Class</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Select Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelectClass(SelectClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Select Object</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Select Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSelectObject(SelectObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>From Range</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>From Range</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFromRange(FromRange object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>From Class</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>From Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFromClass(FromClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>In Class</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>In Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInClass(InClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>In Collection</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>In Collection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInCollection(InCollection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>In Collection Elements</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>In Collection Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInCollectionElements(InCollectionElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Join</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Join</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJoin(Join object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Join Entity</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Join Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseJoinEntity(JoinEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expression</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpression(Expression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePropertyValue(PropertyValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Function Call</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Function Call</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFunctionCall(FunctionCall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Trim Function</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Trim Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTrimFunction(TrimFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cast Function</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cast Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCastFunction(CastFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Aggregate Function</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Aggregate Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAggregateFunction(AggregateFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Parameter Reference</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Parameter Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryParameterReference(QueryParameterReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Parameter Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Parameter Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryParameterValue(QueryParameterValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Quantified Expression</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Quantified Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQuantifiedExpression(QuantifiedExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Case Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Case Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCaseExpression(CaseExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>When Clause</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>When Clause</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWhenClause(WhenClause object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Alt When Clause</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Alt When Clause</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAltWhenClause(AltWhenClause object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Collection Function</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Collection Function</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCollectionFunction(CollectionFunction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sub Query</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sub Query</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSubQuery(SubQuery object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parenthesized Expression</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parenthesized Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParenthesizedExpression(ParenthesizedExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Literal Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLiteralValue(LiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String Literal Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStringLiteralValue(StringLiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Integer Literal Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Integer Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntegerLiteralValue(IntegerLiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Real Literal Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Real Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRealLiteralValue(RealLiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Boolean Literal Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Boolean Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBooleanLiteralValue(BooleanLiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Null Literal Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Null Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullLiteralValue(NullLiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Empty Literal Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Empty Literal Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEmptyLiteralValue(EmptyLiteralValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dao Feature</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dao Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDaoFeature(DaoFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Dao</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Dao</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDao(Dao object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Operation</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryOperation(QueryOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Parameter</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryParameter(QueryParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Column</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseColumn(Column object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Many To One</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Many To One</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseManyToOne(ManyToOne object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>One To One</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>One To One</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOneToOne(OneToOne object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>One To Many</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>One To Many</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOneToMany(OneToMany object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Many To Many</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Many To Many</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseManyToMany(ManyToMany object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Presentable Feature</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Presentable Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePresentableFeature(PresentableFeature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Aliased Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Aliased Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAliasedExpression(AliasedExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Binary Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Binary Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBinaryExpression(BinaryExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Not Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Not Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNotExpression(NotExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>In Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>In Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInExpression(InExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Between Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Between Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBetweenExpression(BetweenExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Like Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Like Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLikeExpression(LikeExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member Of Expression</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member Of Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemberOfExpression(MemberOfExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unary Expression</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unary Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnaryExpression(UnaryExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IDocumentable</em>'.
	 * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IDocumentable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
    public T caseIDocumentable(IDocumentable object) {
		return null;
	}

    /**
	 * Returns the result of interpreting the object as an instance of '<em>Data Base Constraint</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Base Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataBaseConstraint(DataBaseConstraint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttribute(Attribute object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeFlag(AttributeFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expression Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expression Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpressionFlag(ExpressionFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Required Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Required Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRequiredFlag(RequiredFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Read Only Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Read Only Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReadOnlyFlag(ReadOnlyFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Available Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Available Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAvailableFlag(AvailableFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Derived Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Derived Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDerivedFlag(DerivedFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Transient Flag</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Transient Flag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTransientFlag(TransientFlag object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Property</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeProperty(AttributeProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Validation Property</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Validation Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeValidationProperty(AttributeValidationProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Text Property</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Text Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeTextProperty(AttributeTextProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Group</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeGroup(AttributeGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Sort Order</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Sort Order</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeSortOrder(AttributeSortOrder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Referenceable By Xmadsl Variable</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Referenceable By Xmadsl Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferenceableByXmadslVariable(ReferenceableByXmadslVariable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Property</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProperty(Property object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Application Session</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Application Session</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseApplicationSession(ApplicationSession object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelElement(ModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Type</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseType(Type object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} // DomSwitch
