/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CollectionType implements Enumerator
{
    NULL(0, "NULL", "NULL"),
    COLLECTION(1, "COLLECTION", "Collection"),
    SET(2, "SET", "Set"),
    LIST(3, "LIST", "List"),
    MAP(4, "MAP", "Map");

    public static final int NULL_VALUE = 0;
    public static final int COLLECTION_VALUE = 1;
    public static final int SET_VALUE = 2;
    public static final int LIST_VALUE = 3;
    public static final int MAP_VALUE = 4;
    private static final CollectionType[] VALUES_ARRAY;
    public static final List<CollectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CollectionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CollectionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CollectionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CollectionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CollectionType get(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return COLLECTION;
            }
            case 2: {
                return SET;
            }
            case 3: {
                return LIST;
            }
            case 4: {
                return MAP;
            }
        }
        return null;
    }

    private CollectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CollectionType[]{NULL, COLLECTION, SET, LIST, MAP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

