/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CrudOperationType implements Enumerator
{
    NULL(0, "NULL", "NULL"),
    CREATE(1, "CREATE", "create"),
    READ(2, "READ", "read"),
    UPDATE(3, "UPDATE", "update"),
    DELETE(4, "DELETE", "delete"),
    ALL(5, "ALL", "crud");

    public static final int NULL_VALUE = 0;
    public static final int CREATE_VALUE = 1;
    public static final int READ_VALUE = 2;
    public static final int UPDATE_VALUE = 3;
    public static final int DELETE_VALUE = 4;
    public static final int ALL_VALUE = 5;
    private static final CrudOperationType[] VALUES_ARRAY;
    public static final List<CrudOperationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CrudOperationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CrudOperationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CrudOperationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CrudOperationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CrudOperationType get(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return CREATE;
            }
            case 2: {
                return READ;
            }
            case 3: {
                return UPDATE;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return ALL;
            }
        }
        return null;
    }

    private CrudOperationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CrudOperationType[]{NULL, CREATE, READ, UPDATE, DELETE, ALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

