/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServiceType implements Enumerator
{
    REMOTE(0, "remote", "remote"),
    LOCAL(1, "local", "local");

    public static final int REMOTE_VALUE = 0;
    public static final int LOCAL_VALUE = 1;
    private static final ServiceType[] VALUES_ARRAY;
    public static final List<ServiceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ServiceType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ServiceType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ServiceType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ServiceType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ServiceType get(int value) {
        switch (value) {
            case 0: {
                return REMOTE;
            }
            case 1: {
                return LOCAL;
            }
        }
        return null;
    }

    private ServiceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ServiceType[]{REMOTE, LOCAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

