/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.core.model.impl.ModelElementImpl;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataBaseConstraintType;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.QueryOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoImpl
extends ModelElementImpl
implements Dao {
    protected Entity entity;
    protected static final String TABLE_NAME_EDEFAULT = null;
    protected String tableName = TABLE_NAME_EDEFAULT;
    protected static final String DISCRIMINATOR_EDEFAULT = null;
    protected String discriminator = DISCRIMINATOR_EDEFAULT;
    protected static final String QUALIFIER_EDEFAULT = null;
    protected String qualifier = QUALIFIER_EDEFAULT;
    protected EList<Operation> operations;
    protected EList<QueryOperation> queryOperation;
    protected EList<DataBaseConstraint> dataBaseConstraints;
    protected EList<Column> columns;
    protected EList<ManyToOne> manyToOneAssociations;
    protected EList<OneToOne> oneToOneAssociations;
    protected EList<OneToMany> oneToManyAssociations;
    protected EList<ManyToMany> manyToManyAssociations;
    protected DataBaseConstraint primaryKey;
    protected Column primaryKeyColumn;
    protected Column versionColumn;
    protected DataBaseConstraint naturalKey;

    protected DaoImpl() {
    }

    protected EClass eStaticClass() {
        return DomPackage.Literals.DAO;
    }

    @Override
    public Entity getEntity() {
        if (this.entity != null && this.entity.eIsProxy()) {
            InternalEObject oldEntity = (InternalEObject)this.entity;
            this.entity = (Entity)this.eResolveProxy(oldEntity);
            if (this.entity != oldEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldEntity, (Object)this.entity));
            }
        }
        return this.entity;
    }

    public Entity basicGetEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Entity newEntity) {
        Entity oldEntity = this.entity;
        this.entity = newEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldEntity, (Object)this.entity));
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String newTableName) {
        String oldTableName = this.tableName;
        this.tableName = newTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTableName, (Object)this.tableName));
        }
    }

    @Override
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public void setDiscriminator(String newDiscriminator) {
        String oldDiscriminator = this.discriminator;
        this.discriminator = newDiscriminator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDiscriminator, (Object)this.discriminator));
        }
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public void setQualifier(String newQualifier) {
        String oldQualifier = this.qualifier;
        this.qualifier = newQualifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldQualifier, (Object)this.qualifier));
        }
    }

    @Override
    public EList<DataBaseConstraint> getDataBaseConstraints() {
        if (this.dataBaseConstraints == null) {
            this.dataBaseConstraints = new EObjectContainmentEList(DataBaseConstraint.class, (InternalEObject)this, 8);
        }
        return this.dataBaseConstraints;
    }

    @Override
    public EList<Operation> getOperations() {
        if (this.operations == null) {
            this.operations = new EObjectContainmentEList(Operation.class, (InternalEObject)this, 6);
        }
        return this.operations;
    }

    @Override
    public EList<QueryOperation> getQueryOperation() {
        if (this.queryOperation == null) {
            this.queryOperation = new EObjectContainmentEList(QueryOperation.class, (InternalEObject)this, 7);
        }
        return this.queryOperation;
    }

    @Override
    public EList<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new EObjectContainmentEList(Column.class, (InternalEObject)this, 9);
        }
        return this.columns;
    }

    @Override
    public EList<ManyToOne> getManyToOneAssociations() {
        if (this.manyToOneAssociations == null) {
            this.manyToOneAssociations = new EObjectContainmentEList(ManyToOne.class, (InternalEObject)this, 10);
        }
        return this.manyToOneAssociations;
    }

    @Override
    public EList<OneToOne> getOneToOneAssociations() {
        if (this.oneToOneAssociations == null) {
            this.oneToOneAssociations = new EObjectContainmentEList(OneToOne.class, (InternalEObject)this, 11);
        }
        return this.oneToOneAssociations;
    }

    @Override
    public EList<OneToMany> getOneToManyAssociations() {
        if (this.oneToManyAssociations == null) {
            this.oneToManyAssociations = new EObjectContainmentEList(OneToMany.class, (InternalEObject)this, 12);
        }
        return this.oneToManyAssociations;
    }

    @Override
    public EList<ManyToMany> getManyToManyAssociations() {
        if (this.manyToManyAssociations == null) {
            this.manyToManyAssociations = new EObjectContainmentEList(ManyToMany.class, (InternalEObject)this, 13);
        }
        return this.manyToManyAssociations;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        if (this.primaryKeyColumn == null) {
            for (Column column : this.getColumns()) {
                if (null == column.getAttribute() || !column.getAttribute().isIdentifier()) continue;
                this.primaryKeyColumn = column;
            }
        }
        return this.primaryKeyColumn;
    }

    @Override
    public Column getVersionColumn() {
        if (this.versionColumn == null) {
            for (Column column : this.getColumns()) {
                if (null == column.getAttribute() || !column.getAttribute().isVersion()) continue;
                this.versionColumn = column;
            }
        }
        return this.versionColumn;
    }

    @Override
    public DataBaseConstraint getPrimaryKey() {
        if (this.primaryKey == null) {
            Iterator<DataBaseConstraint> iterator = this.getDataBaseConstraintByType(DataBaseConstraintType.PRIMARY).iterator();
            this.primaryKey = iterator.hasNext() ? iterator.next() : null;
        }
        return this.primaryKey;
    }

    @Override
    public DataBaseConstraint getNaturalKey() {
        if (this.naturalKey == null) {
            Iterator<DataBaseConstraint> iterator = this.getDataBaseConstraintByType(DataBaseConstraintType.NATURAL).iterator();
            this.naturalKey = iterator.hasNext() ? iterator.next() : null;
        }
        return this.naturalKey;
    }

    @Override
    public EList<Column> getNaturalKeyColumns() {
        DataBaseConstraint naturalKey;
        EObjectEList naturalKeyColumns = new EObjectEList(Column.class, (InternalEObject)this, 15);
        if (naturalKeyColumns.isEmpty() && (naturalKey = this.getNaturalKey()) != null) {
            for (Attribute attribute : naturalKey.getAttributes()) {
                naturalKeyColumns.add((Object)this.getColumnDefinition(attribute));
            }
        }
        return naturalKeyColumns;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getOperations()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getQueryOperation()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getDataBaseConstraints()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getManyToOneAssociations()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getOneToOneAssociations()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getOneToManyAssociations()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getManyToManyAssociations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                if (resolve) {
                    return this.getEntity();
                }
                return this.basicGetEntity();
            }
            case 3: {
                return this.getTableName();
            }
            case 4: {
                return this.getDiscriminator();
            }
            case 5: {
                return this.getQualifier();
            }
            case 6: {
                return this.getOperations();
            }
            case 7: {
                return this.getQueryOperation();
            }
            case 8: {
                return this.getDataBaseConstraints();
            }
            case 9: {
                return this.getColumns();
            }
            case 10: {
                return this.getManyToOneAssociations();
            }
            case 11: {
                return this.getOneToOneAssociations();
            }
            case 12: {
                return this.getOneToManyAssociations();
            }
            case 13: {
                return this.getManyToManyAssociations();
            }
            case 14: {
                return this.getPrimaryKeyColumn();
            }
            case 15: {
                return this.getNaturalKeyColumns();
            }
            case 16: {
                return this.getVersionColumn();
            }
            case 17: {
                return this.getPrimaryKey();
            }
            case 18: {
                return this.getNaturalKey();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setEntity((Entity)newValue);
                return;
            }
            case 3: {
                this.setTableName((String)newValue);
                return;
            }
            case 4: {
                this.setDiscriminator((String)newValue);
                return;
            }
            case 5: {
                this.setQualifier((String)newValue);
                return;
            }
            case 6: {
                this.getOperations().clear();
                this.getOperations().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getQueryOperation().clear();
                this.getQueryOperation().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getDataBaseConstraints().clear();
                this.getDataBaseConstraints().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getColumns().clear();
                this.getColumns().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getManyToOneAssociations().clear();
                this.getManyToOneAssociations().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getOneToOneAssociations().clear();
                this.getOneToOneAssociations().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getOneToManyAssociations().clear();
                this.getOneToManyAssociations().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getManyToManyAssociations().clear();
                this.getManyToManyAssociations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setEntity(null);
                return;
            }
            case 3: {
                this.setTableName(TABLE_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setDiscriminator(DISCRIMINATOR_EDEFAULT);
                return;
            }
            case 5: {
                this.setQualifier(QUALIFIER_EDEFAULT);
                return;
            }
            case 6: {
                this.getOperations().clear();
                return;
            }
            case 7: {
                this.getQueryOperation().clear();
                return;
            }
            case 8: {
                this.getDataBaseConstraints().clear();
                return;
            }
            case 9: {
                this.getColumns().clear();
                return;
            }
            case 10: {
                this.getManyToOneAssociations().clear();
                return;
            }
            case 11: {
                this.getOneToOneAssociations().clear();
                return;
            }
            case 12: {
                this.getOneToManyAssociations().clear();
                return;
            }
            case 13: {
                this.getManyToManyAssociations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.entity != null;
            }
            case 3: {
                return TABLE_NAME_EDEFAULT == null ? this.tableName != null : !TABLE_NAME_EDEFAULT.equals(this.tableName);
            }
            case 4: {
                return DISCRIMINATOR_EDEFAULT == null ? this.discriminator != null : !DISCRIMINATOR_EDEFAULT.equals(this.discriminator);
            }
            case 5: {
                return QUALIFIER_EDEFAULT == null ? this.qualifier != null : !QUALIFIER_EDEFAULT.equals(this.qualifier);
            }
            case 6: {
                return this.operations != null && !this.operations.isEmpty();
            }
            case 7: {
                return this.queryOperation != null && !this.queryOperation.isEmpty();
            }
            case 8: {
                return this.dataBaseConstraints != null && !this.dataBaseConstraints.isEmpty();
            }
            case 9: {
                return this.columns != null && !this.columns.isEmpty();
            }
            case 10: {
                return this.manyToOneAssociations != null && !this.manyToOneAssociations.isEmpty();
            }
            case 11: {
                return this.oneToOneAssociations != null && !this.oneToOneAssociations.isEmpty();
            }
            case 12: {
                return this.oneToManyAssociations != null && !this.oneToManyAssociations.isEmpty();
            }
            case 13: {
                return this.manyToManyAssociations != null && !this.manyToManyAssociations.isEmpty();
            }
            case 14: {
                return this.getPrimaryKeyColumn() != null;
            }
            case 15: {
                return !this.getNaturalKeyColumns().isEmpty();
            }
            case 16: {
                return this.getVersionColumn() != null;
            }
            case 17: {
                return this.getPrimaryKey() != null;
            }
            case 18: {
                return this.getNaturalKey() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (tableName: ");
        result.append(this.tableName);
        result.append(", discriminator: ");
        result.append(this.discriminator);
        result.append(", qualifier: ");
        result.append(this.qualifier);
        result.append(')');
        return result.toString();
    }

    @Override
    public Column getColumnDefinition(Attribute attribute) {
        for (Column column : this.getColumns()) {
            if (column.getAttribute() == null || !column.getAttribute().getName().equals(attribute.getName())) continue;
            return column;
        }
        return null;
    }

    @Override
    public OneToMany getOneToMany(Attribute feature) {
        for (OneToMany oneToMany : this.getOneToManyAssociations()) {
            if (!oneToMany.getAttribute().equals(feature)) continue;
            return oneToMany;
        }
        return null;
    }

    @Override
    public ManyToMany getManyToMany(Attribute feature) {
        for (ManyToMany manyToMany : this.getManyToManyAssociations()) {
            if (!manyToMany.getAttribute().equals(feature)) continue;
            return manyToMany;
        }
        return null;
    }

    @Override
    public ManyToOne getManyToOne(Attribute feature) {
        for (ManyToOne manyToOne : this.getManyToOneAssociations()) {
            if (!manyToOne.getAttribute().equals(feature)) continue;
            return manyToOne;
        }
        return null;
    }

    @Override
    public OneToOne getOneToOne(Attribute feature) {
        EList<OneToOne> oneToManyAssociations = this.getOneToOneAssociations();
        for (OneToOne oneToOne : oneToManyAssociations) {
            if (!oneToOne.getAttribute().equals(feature)) continue;
            return oneToOne;
        }
        return null;
    }

    @Override
    public Collection<DataBaseConstraint> getDataBaseConstraintByType(final DataBaseConstraintType type) {
        return Collections2.filter(this.getDataBaseConstraints(), (Predicate)new Predicate<DataBaseConstraint>(){

            public boolean apply(DataBaseConstraint dataBaseConstraint) {
                return type.equals((Object)dataBaseConstraint.getType());
            }
        });
    }
}

