/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeSortOrder;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.PresentableFeature;
import org.openxma.dsl.dom.model.impl.ComplexTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataViewImpl
extends ComplexTypeImpl
implements DataView {
    private static final int ALL = 1;
    private static final int ATTRIBUTE = 5;
    protected DataView superType;
    protected EList<FeatureReference> featureReferences;
    private String originalName;
    private String originalContainerName;

    protected DataViewImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DomPackage.Literals.DATA_VIEW;
    }

    @Override
    public DataView getSuperType() {
        if (this.superType != null && this.superType.eIsProxy()) {
            InternalEObject oldSuperType = (InternalEObject)this.superType;
            this.superType = (DataView)this.eResolveProxy(oldSuperType);
            if (this.superType != oldSuperType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldSuperType, (Object)this.superType));
            }
        }
        return this.superType;
    }

    public DataView basicGetSuperType() {
        return this.superType;
    }

    @Override
    public void setSuperType(DataView newSuperType) {
        DataView oldSuperType = this.superType;
        this.superType = newSuperType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSuperType, (Object)this.superType));
        }
    }

    @Override
    public EList<FeatureReference> getFeatureReferences() {
        if (this.featureReferences == null) {
            this.featureReferences = new EObjectContainmentEList(FeatureReference.class, (InternalEObject)this, 5);
        }
        return this.featureReferences;
    }

    @Override
    public EList<Attribute> getReferencedAssociations() {
        BasicEList referencedAssociations = new BasicEList();
        for (FeatureReference featureReference : this.getFeatureReferences()) {
            if (featureReference.getAttribute().isReference()) {
                referencedAssociations.add((Object)featureReference.getAttribute());
                continue;
            }
            if (!featureReference.isAll()) continue;
            referencedAssociations.addAll(featureReference.getSource().getRequiredReferences());
        }
        return referencedAssociations;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getFeatureReferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                if (resolve) {
                    return this.getSuperType();
                }
                return this.basicGetSuperType();
            }
            case 5: {
                return this.getFeatureReferences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setSuperType((DataView)newValue);
                return;
            }
            case 5: {
                this.getFeatureReferences().clear();
                this.getFeatureReferences().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setSuperType(null);
                return;
            }
            case 5: {
                this.getFeatureReferences().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.superType != null;
            }
            case 5: {
                return this.featureReferences != null && !this.featureReferences.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public EList<Attribute> getAllAttributes() {
        EObjectEList allAttributeHolders = new EObjectEList(Attribute.class, (InternalEObject)this, 3);
        for (FeatureReference featureReference : this.getFeatureReferences()) {
            List<Attribute> tempList = this.allAttributeHolders(featureReference);
            if (tempList == null) continue;
            allAttributeHolders.addAll(tempList);
        }
        if (this.getAttributes() != null && this.getAttributes().size() > 0) {
            allAttributeHolders.addAll(this.getAttributes());
        }
        return allAttributeHolders;
    }

    @Override
    public List<PresentableFeature> getAllPresentableFeaturesIncludingSuperType() {
        ArrayList<PresentableFeature> presentableFeatureList = new ArrayList<PresentableFeature>();
        presentableFeatureList.addAll((Collection<PresentableFeature>)this.getAttributes());
        block4: for (FeatureReference fr : this.getFeatureReferences()) {
            int incExcType = this.getIncExcType(fr);
            switch (incExcType) {
                case 1: {
                    if (fr.getSource() == null) continue block4;
                    presentableFeatureList.addAll(fr.getSource().getAllPresentableFeaturesIncludingSuperType());
                    continue block4;
                }
                case 5: {
                    presentableFeatureList.add(fr);
                    continue block4;
                }
            }
            throw new RuntimeException("Unsupported type of IncludeExclude for " + ((ComplexType)fr.eContainer()).getName());
        }
        if (this.getSuperType() != null) {
            presentableFeatureList.addAll(this.getSuperType().getAllPresentableFeaturesIncludingSuperType());
        }
        return presentableFeatureList;
    }

    public List<Attribute> allAttributeHolders(FeatureReference featureReference) {
        int incExcType = this.getIncExcType(featureReference);
        switch (incExcType) {
            case 1: {
                return featureReference.getSource() != null ? featureReference.getSource().getAllAttributes() : Lists.newArrayList();
            }
            case 5: {
                ArrayList tempAttrList = Lists.newArrayList();
                if (featureReference.getAttribute() != null) {
                    tempAttrList.add(featureReference.getAttribute());
                }
                return tempAttrList;
            }
        }
        throw new RuntimeException("Unsupported type of IncludeExclude for " + ((ComplexType)featureReference.eContainer()).getName());
    }

    private int getIncExcType(FeatureReference incExcDef) {
        if (incExcDef.isAll()) {
            return 1;
        }
        return 5;
    }

    @Override
    public boolean includesAllRequiredFeaturesFor(Entity entity) {
        if (!this.includesAllFeaturesByWildcard(entity)) {
            List<Attribute> includedAttributes = this.resolveIncludedAttributes(this.filterIncludedFeaturesBySource(entity));
            return includedAttributes.containsAll((Collection<?>)entity.getRequiredAttributes()) && Iterables.all(entity.getRequiredReferences(), (Predicate)new Predicate<Attribute>(){

                public boolean apply(Attribute structuralFeature) {
                    Entity entity = (Entity)structuralFeature.getDataType();
                    return DataViewImpl.this.includesIdentifierFor(entity);
                }
            });
        }
        return true;
    }

    @Override
    public boolean includesIdentifierFor(Entity entity) {
        List<Attribute> includedFeatures = this.resolveIncludedAttributes(this.filterIncludedFeaturesBySource(entity));
        return Iterables.any(includedFeatures, (Predicate)new Predicate<Attribute>(){

            public boolean apply(Attribute structuralFeature) {
                if (structuralFeature instanceof Attribute) {
                    Attribute attribute = structuralFeature;
                    return attribute.isIdentifier();
                }
                return false;
            }
        });
    }

    @Override
    public boolean includesKeyFor(Entity entity) {
        List<Attribute> includedFeatures = this.resolveIncludedAttributes(this.filterIncludedFeaturesBySource(entity));
        return includedFeatures.containsAll(Collections2.transform(entity.getKey().getAttributes(), (Function)new Function<AttributeSortOrder, Attribute>(){

            public Attribute apply(AttributeSortOrder from) {
                return from.getAttribute();
            }
        }));
    }

    @Override
    public boolean includesVersionFor(Entity entity) {
        List<Attribute> includedFeatures = this.resolveIncludedAttributes(this.filterIncludedFeaturesBySource(entity));
        return Iterables.any(includedFeatures, (Predicate)new Predicate<Attribute>(){

            public boolean apply(Attribute structuralFeature) {
                if (structuralFeature instanceof Attribute) {
                    Attribute attribute = structuralFeature;
                    return attribute.isVersion();
                }
                return false;
            }
        });
    }

    private Collection<FeatureReference> filterIncludedFeaturesBySource(final Entity entity) {
        return Collections2.filter(this.getFeatureReferences(), (Predicate)new Predicate<FeatureReference>(){

            public boolean apply(FeatureReference featureReference) {
                return featureReference.getSource().equals(entity);
            }
        });
    }

    private List<Attribute> resolveIncludedAttributes(Collection<FeatureReference> featureReferences) {
        ArrayList structuralFeatures = Lists.newArrayList();
        for (FeatureReference featureReference : featureReferences) {
            if (featureReference.getAttribute() != null) {
                structuralFeatures.add(featureReference.getAttribute());
                continue;
            }
            if (!featureReference.isAll()) continue;
            EList<Attribute> allAttributeHolders = featureReference.getSource().getAllAttributes();
            structuralFeatures.addAll(allAttributeHolders);
        }
        return structuralFeatures;
    }

    private boolean includesAllFeaturesByWildcard(Entity entity) {
        return Iterables.any(this.filterIncludedFeaturesBySource(entity), (Predicate)new Predicate<FeatureReference>(){

            public boolean apply(FeatureReference input) {
                return input.isAll();
            }
        });
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getOriginalContainerName() {
        return this.originalContainerName;
    }

    public void setOriginalContainerName(String originalContainerName) {
        this.originalContainerName = originalContainerName;
    }
}

