/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.openxma.dsl.core.CorePackage;
import org.openxma.dsl.core.model.Model;
import org.openxma.dsl.core.model.ModelElement;
import org.openxma.dsl.core.model.SimpleType;
import org.openxma.dsl.core.model.Style;
import org.openxma.dsl.core.model.Type;
import org.openxma.dsl.core.validation.CoreDslJavaValidator;
import org.openxma.dsl.dom.DomPackage;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.FromRange;
import org.openxma.dsl.dom.model.ManyToMany;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.OneToOne;
import org.openxma.dsl.dom.model.Operation;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;
import org.openxma.dsl.dom.model.QueryParameterValue;
import org.openxma.dsl.dom.model.SelectStatement;
import org.openxma.dsl.dom.model.Service;
import org.openxma.dsl.dom.model.ValueObject;
import org.openxma.dsl.dom.model.impl.SelectStatementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomDslJavaValidator
extends CoreDslJavaValidator {
    public static final List<String> SUPPORTED_ID_TYPES = Lists.newArrayList((Object[])new String[]{"String", "Long", "Integer"});
    public static final List<String> SUPPORTED_VERSION_TYPES = Lists.newArrayList((Object[])new String[]{"Date", "Long", "Timestamp"});
    public static final String MISSING_IDENTIFIER = "DOM_MISSING_IDENTIFIER";
    public static final String INVALID_TYPE_NAME = "INVALID_TYPE_NAME";
    private static QueryOperationComparator queryOperationComparator = new QueryOperationComparator();
    private static OperationComparator operationComparator = new OperationComparator();
    public static Set<String> RESERVED_KEYWORDS = Sets.newHashSet((Object[])new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized", "true", "false", "null"});

    protected List<EPackage> getEPackages() {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        result.add((EPackage)CorePackage.eINSTANCE);
        result.add(DomPackage.eINSTANCE);
        return result;
    }

    @Check(value=CheckType.NORMAL)
    public void checkCallableStatement(QueryOperation queryOperation) {
        if (queryOperation.getStatement() instanceof CallableStatement) {
            CallableStatement callableStatement = (CallableStatement)queryOperation.getStatement();
            if (queryOperation.getType() instanceof ComplexType) {
                ComplexType complexType = (ComplexType)queryOperation.getType();
                ImmutableMap attributeMap = Maps.uniqueIndex(complexType.getAllAttributes(), (Function)new Function<Attribute, String>(){

                    public String apply(Attribute from) {
                        return from.getName();
                    }
                });
                EList<CallOutputParameter> eList = callableStatement.getOutParameter();
                Iterable iterable = Iterables.filter(eList, (Predicate)new Predicate<CallOutputParameter>(){

                    public boolean apply(CallOutputParameter input) {
                        return input.getName() != null && input.getAttribute() == null;
                    }
                });
                for (CallOutputParameter callOutputParameter : iterable) {
                    if (attributeMap.containsKey((Object)callOutputParameter.getName())) continue;
                    this.error("Attribute name could not be resolved.", callOutputParameter, (EStructuralFeature)DomPackage.eINSTANCE.getCallOutputParameter_Name(), -1);
                }
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUnusedQueryParameter(QueryOperation queryOperation) {
        if (queryOperation.getStatement() != null && !(queryOperation.getStatement() instanceof CallableStatement)) {
            Collection declaredQueryParameters = Collections2.filter(queryOperation.getQueryParameters(), (Predicate)new Predicate<QueryParameter>(){

                public boolean apply(QueryParameter queryParameter) {
                    Parameter parameter;
                    return !(queryParameter instanceof Parameter) || !"firstResult".equalsIgnoreCase((parameter = (Parameter)queryParameter).getName()) && !"maxResults".equalsIgnoreCase(parameter.getName());
                }
            });
            List queryParameterValues = EcoreUtil2.eAllOfType((EObject)queryOperation.getStatement(), QueryParameterValue.class);
            if (queryParameterValues.size() < declaredQueryParameters.size()) {
                this.warning("Unused QueryParameter's.", (EStructuralFeature)DomPackage.eINSTANCE.getQueryOperation_Statement());
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkType(QueryOperation queryOperation) {
        SelectStatement statement;
        EList<FromRange> from;
        if (queryOperation.getType() != null && queryOperation.getStatement() != null && SelectStatementImpl.class.equals(queryOperation.getStatement().getClass()) && (from = (statement = (SelectStatement)queryOperation.getStatement()).getFrom()).size() == 1 && from.iterator().next() instanceof FromClass) {
            FromClass fromClass = (FromClass)from.iterator().next();
            if (!queryOperation.getType().equals(fromClass.getEntity())) {
                this.error("Type mismatch: cannot convert from '" + (String)SimpleAttributeResolver.NAME_RESOLVER.apply((EObject)fromClass.getEntity()) + "' to '" + (String)SimpleAttributeResolver.NAME_RESOLVER.apply((EObject)queryOperation.getType()) + "'.", (EStructuralFeature)DomPackage.eINSTANCE.getDaoOperation_Type());
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkFeatureName(Attribute feature) {
        if (feature.getName() != null && RESERVED_KEYWORDS.contains(feature.getName())) {
            this.error("Invalid feature name: Reserved java keyword.", (EStructuralFeature)DomPackage.eINSTANCE.getPresentableFeature_Name());
        }
        if (!Character.isLowerCase(feature.getName().charAt(0))) {
            this.error("Invalid feature name: Name should start with a lowercase initial letter.", (EStructuralFeature)DomPackage.eINSTANCE.getPresentableFeature_Name());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkModelElement(ModelElement modelElement) {
        if (!(modelElement instanceof Style) && !Character.isUpperCase(modelElement.getName().charAt(0))) {
            this.warning("Name should start with a capital letter.", (EStructuralFeature)CorePackage.eINSTANCE.getModelElement_Name(), INVALID_TYPE_NAME, new String[]{modelElement.getName()});
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDelegateOperationDataView(DelegateOperation delegateOperation) {
        DataView viewParameter;
        Entity entity = delegateOperation.getRepository().getEntity();
        DataView dataView = viewParameter = delegateOperation.getViewParameter() != null ? delegateOperation.getViewParameter() : entity.getDefaultDataView();
        if (delegateOperation.isCreateOperation() && null != viewParameter && !viewParameter.includesAllRequiredFeaturesFor(entity)) {
            this.warning("DataView '" + viewParameter.getName() + "' can not be used for create because it doesn't contain all required features of entity '" + entity.getName() + "'", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_ViewParameter());
        }
        if (delegateOperation.isUpdateOperation()) {
            if (null != viewParameter && !viewParameter.includesIdentifierFor(entity)) {
                boolean includesKey = false;
                if (entity.getKey() != null && entity.getIdentifier() == null && (entity.getSuperType() == null || entity.getSuperType().getIdentifier() == null)) {
                    includesKey = viewParameter.includesKeyFor(entity);
                }
                if (!includesKey) {
                    this.warning("DataView '" + viewParameter.getName() + "' can not be used for update because it doesn't include the identifier or key attributes of entity '" + entity.getName() + "'", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_ViewParameter());
                }
            }
            if (entity.getVersion() != null && !viewParameter.includesVersionFor(entity)) {
                this.warning("DataView '" + viewParameter.getName() + "' is missing the version attribute of entity '" + entity.getName() + "'", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_ViewParameter());
            }
        }
        if (delegateOperation.getFilter() != null) {
            if (!(delegateOperation.getOperation() instanceof QueryOperation)) {
                this.error("Filter expression only supported for QueryOperations.", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_Operation());
            } else {
                QueryOperation queryOperation = (QueryOperation)delegateOperation.getOperation();
                if (!(queryOperation.getStatement() instanceof SelectStatement)) {
                    this.error("Filter expression only supported for SelectStatements.", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_Operation());
                } else {
                    SelectStatement selectStmt = (SelectStatement)queryOperation.getStatement();
                    if (selectStmt.getOrderBy().size() > 0) {
                        this.warning("Filter expression does not support operations with order by clause.", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_Operation());
                    }
                }
                if (!queryOperation.isMany() || queryOperation.getType() == null) {
                    this.error("Filter expression only supported for operations returning collections.", (EStructuralFeature)DomPackage.eINSTANCE.getDelegateOperation_Operation());
                }
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkSameResourceWithEntity(Dao dao) {
        if (!dao.eResource().equals(dao.getEntity().eResource())) {
            this.error("Dao and entity must be defined in the same resource (dsl file).", (EStructuralFeature)CorePackage.eINSTANCE.getModel_Elements());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDuplicateOperations(Operation theOperation) {
        EList<Operation> operations = theOperation.eContainer() instanceof Service ? ((Service)theOperation.eContainer()).getOperations() : ((Dao)theOperation.eContainer()).getOperations();
        for (Operation operation : operations) {
            if (operation == theOperation || operationComparator.compare(operation, theOperation) != 0) continue;
            this.warning("Duplicate operation '" + theOperation.getName() + "'", theOperation, (EStructuralFeature)DomPackage.eINSTANCE.getOperation_Delegate(), -1);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDuplicateQueryOperations(QueryOperation theOperation) {
        Dao dao = (Dao)theOperation.eContainer();
        for (QueryOperation operation : dao.getQueryOperation()) {
            if (operation == theOperation || queryOperationComparator.compare(theOperation, operation) != 0) continue;
            this.warning("Duplicate operation '" + theOperation.getName() + "'", theOperation, (EStructuralFeature)DomPackage.eINSTANCE.getQueryOperation_Statement(), -1);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkManyToMany(ManyToMany manyToMany) {
        if (manyToMany.getAttribute().getOpposite() == null && manyToMany.getAttribute().getOppositeReference() == null) {
            this.warning("Missing opposite reference definition.", manyToMany.getAttribute(), (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite(), -1);
        }
        if (manyToMany.getAttribute().getOppositeReference() != null && manyToMany.getAttribute().getOppositeReference().getOpposite() != null && manyToMany.getAttribute().getOpposite() != null) {
            this.warning("Opposite reference definition on both sides: No entity is responsable for mapping table of the many-to-many relationship: .", manyToMany.getAttribute(), (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite(), -1);
        }
        if (manyToMany.getAttribute().isRequired()) {
            this.error("Many-to-many relationship cannot be mandatory. ", manyToMany.getAttribute(), (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite(), -1);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkIdentifierOrKeyAvailable(Dao dao) {
        Entity entity = dao.getEntity();
        if (entity.getKey() == null && entity.getIdentifier() == null) {
            this.error("Entity '" + entity.getName() + "' is not persistable because it doesn't define an identifier attribute or a business key.", (EStructuralFeature)DomPackage.eINSTANCE.getDao_Entity(), MISSING_IDENTIFIER, new String[]{entity.getName() == null ? "n/a" : entity.getName()});
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkEntity(Entity entity) {
        Attribute identifierAttribute = null;
        Attribute versionAttribute = null;
        for (Attribute attribute : entity.getAllAttributes()) {
            if (attribute.getAttribute().isIdentifier()) {
                if (identifierAttribute != null) {
                    this.error("Entity '" + entity.getName() + "' defines more than one identifier attribute.", (EStructuralFeature)DomPackage.eINSTANCE.getDao_Entity());
                } else {
                    Type type;
                    identifierAttribute = attribute;
                    if (identifierAttribute.getDataTypeName() != null && !SUPPORTED_ID_TYPES.contains(identifierAttribute.getDataTypeName()) && this.isScalarType(type = identifierAttribute.getDataType())) {
                        this.error("Unsupported identifier datatype '" + identifierAttribute.getDataTypeName() + "'. Supported types are: " + Strings.concat((String)",", SUPPORTED_ID_TYPES) + ".", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Type());
                    }
                }
            }
            if (attribute.getAttribute().isVersion()) {
                if (versionAttribute != null) {
                    this.error("Entity '" + entity.getName() + "' defines more than one version attribute.", (EStructuralFeature)DomPackage.eINSTANCE.getDao_Entity());
                } else if (attribute.getType() != null && attribute.getType().getDataType() instanceof SimpleType) {
                    versionAttribute = attribute;
                    SimpleType simpleType = (SimpleType)attribute.getType().getDataType();
                    if (simpleType.getInstanceTypeName() != null && !SUPPORTED_VERSION_TYPES.contains(Strings.lastToken((String)simpleType.getInstanceTypeName(), (String)"."))) {
                        this.error("Unsupported instance datatype '" + simpleType.getInstanceTypeName() + "'. Supported types are: " + Strings.concat((String)",", SUPPORTED_VERSION_TYPES) + ".", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Type());
                    }
                }
            }
            if (attribute.isComposition() && null == attribute.getOpposite()) {
                this.error("Opposite reference must not be null for composition associations.", attribute, (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite(), -1);
            }
            if (!this.isInverseCompositionAttribute(attribute) || attribute.isRequired()) continue;
            this.warning("Opposite reference for composition associations must be marked as 'required=true'.", attribute, (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite(), -1);
        }
    }

    private boolean isInverseCompositionAttribute(Attribute attribute) {
        return !attribute.isComposition() && null != attribute.getOppositeReference() && attribute.getOppositeReference().isComposition();
    }

    private boolean isScalarType(Type type) {
        return type instanceof SimpleType && ((SimpleType)type).getTypeDefinition() != null && ((SimpleType)type).getTypeDefinition().getInstanceType() != null;
    }

    @Check(value=CheckType.NORMAL)
    public void checkSuperTypeCycle(Entity entity) {
        if (entity.getSuperType() != null && entity.getSuperType().equals(entity)) {
            this.error("Cycle detected: Entity '" + entity.getName() + "' cannot extend itself.", (EStructuralFeature)DomPackage.eINSTANCE.getEntity_SuperType());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkOneToOne(OneToOne oneToOne) {
        if (oneToOne.getAttribute().getOpposite() == null) {
            this.error("Missing opposite reference definition.", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkReference(Attribute attribute) {
        if (attribute.eContainer() instanceof Entity) {
            if (!attribute.isMany() && attribute.isComposition() && null == attribute.getOpposite()) {
                this.error("Containment type reference must define the opposite reference.", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Composition());
            }
            if (attribute.isMany() && !attribute.isComposition() && null != attribute.getOpposite() && attribute.getOpposite().isRequired()) {
                this.warning("Should be marked as composition since reference '" + attribute.getName() + "' is marked as required on the opposite site '" + attribute.getOpposite().getName() + "'.", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite());
            }
            if (attribute.getOpposite() == attribute) {
                this.error("Opposite reference must not be the reference itself.", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Opposite());
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDuplicateAttributes(DataView dataView) {
        ArrayListMultimap featureMap = ArrayListMultimap.create();
        for (FeatureReference featureReference : dataView.getFeatureReferences()) {
            Entity entity = featureReference.getSource();
            String name = featureReference.getSource().getName();
            if (featureReference.isAll()) {
                for (Attribute attribute : DomDslJavaValidator.cloneAttributes(entity)) {
                    if (attribute.getDataType() instanceof Entity) continue;
                    featureMap.put((Object)(name + attribute.getName()), (Object)attribute);
                }
                continue;
            }
            if (null == featureReference.getAttribute()) continue;
            featureMap.put((Object)(name + (featureReference.getName() != null ? featureReference.getName() : featureReference.getAttribute().getName())), (Object)featureReference.getAttribute());
        }
        for (String name : featureMap.keySet()) {
            Collection features = featureMap.get((Object)name);
            if (features.size() <= 1) continue;
            for (Attribute feature : features) {
                this.error("Duplicate attribute '" + feature.getName() + "'", (EStructuralFeature)DomPackage.eINSTANCE.getComplexType_Attributes());
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkAttributeTypes(ComplexType complexType) {
        if (complexType instanceof ValueObject) {
            for (Attribute attribute : complexType.getAttributes()) {
                if (!(attribute.getDataType() instanceof Entity)) continue;
                this.error("Entity references not supported in '" + complexType.eClass().getName() + "' elements", attribute, (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_DataType(), -1);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkIfAttributeIsUnique(final Attribute attribute) {
        ImmutableListMultimap multiMap;
        Collection attributes = EcoreUtil.getObjectsByType((Collection)attribute.eContainer().eContents(), (EClassifier)DomPackage.eINSTANCE.getAttribute());
        Collection duplicateAttributeNames = Collections2.filter((Collection)attributes, (Predicate)new Predicate<EObject>((ListMultimap)(multiMap = Multimaps.index((Iterable)attributes, (Function)SimpleAttributeResolver.NAME_RESOLVER))){
            final /* synthetic */ ListMultimap val$multiMap;
            {
                this.val$multiMap = listMultimap;
            }

            public boolean apply(EObject input) {
                return input.equals(attribute) && this.val$multiMap.get(SimpleAttributeResolver.NAME_RESOLVER.apply(input)).size() > 1;
            }
        });
        if (!duplicateAttributeNames.isEmpty()) {
            this.error("Duplicate attribute '" + attribute.getName() + "'", (EStructuralFeature)DomPackage.eINSTANCE.getPresentableFeature_Name());
        }
    }

    private static Collection<Attribute> cloneAttributes(Entity entity) {
        Collection attributes = EcoreUtil.copyAll(entity.getAttributes());
        if (entity.getSuperType() != null) {
            Collection<Attribute> superTypeAttributes = DomDslJavaValidator.cloneAttributes(entity.getSuperType());
            attributes.addAll(EcoreUtil.copyAll(superTypeAttributes));
        }
        return attributes;
    }

    @Check(value=CheckType.NORMAL)
    public void checkMapper(Mapper mapper) {
        if (null == mapper.getLeft() || null == mapper.getRight()) {
            return;
        }
        if (mapper.getRight() instanceof ValueObject) {
            this.error("valueobject not yet supported, use dataview", (EStructuralFeature)DomPackage.eINSTANCE.getMapper_Right());
        }
        if (mapper.getRight() instanceof Entity) {
            this.error("entity not yet supported, use dataview", (EStructuralFeature)DomPackage.eINSTANCE.getMapper_Right());
        }
        if (mapper.getLeft() instanceof ValueObject) {
            this.error("valueobject not yet supported, use dataview", (EStructuralFeature)DomPackage.eINSTANCE.getMapper_Left());
        }
        if (mapper.getLeft() instanceof Entity) {
            this.error("entity not yet supported, use dataview", (EStructuralFeature)DomPackage.eINSTANCE.getMapper_Left());
        }
        if (mapper.getLeft().equals(mapper.getRight())) {
            this.error("mapping must map different types", (EStructuralFeature)DomPackage.eINSTANCE.getMapper_Right());
        }
        for (EObject next : ((Model)mapper.eContainer()).eContents()) {
            Mapper nextMapper;
            if (!(next instanceof Mapper) || (nextMapper = (Mapper)next) == mapper || nextMapper.getName() == null || !nextMapper.getName().equals(mapper.getName())) continue;
            this.error("Duplicate mapper name '" + mapper.getName() + "' in model '" + ((Model)mapper.eContainer()).getName() + "' detected", (EStructuralFeature)CorePackage.eINSTANCE.getModelElement_Name());
            break;
        }
        if (!this.arePropertyMappingsConsistent(mapper)) {
            return;
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkEntityManyAttributes(Attribute attribute) {
        if (attribute.eContainer() instanceof Entity && attribute.isMany() && !attribute.isReference()) {
            this.error("Unable to map multiple attribute values to database table.", (EStructuralFeature)DomPackage.eINSTANCE.getAttribute_Many());
        }
    }

    private boolean arePropertyMappingsConsistent(Mapper mapper) {
        ArrayList<Attribute> left = new ArrayList<Attribute>(mapper.getPropertyMappings().size());
        ArrayList<Attribute> right = new ArrayList<Attribute>(mapper.getPropertyMappings().size());
        for (PropertyMapping propertyMapping : mapper.getPropertyMappings()) {
            if (this.isPropertyMappingConsistent(left, right, propertyMapping)) continue;
            return false;
        }
        return true;
    }

    private boolean isPropertyMappingConsistent(List<Attribute> left, List<Attribute> right, PropertyMapping propertyMapping) {
        return !(propertyMapping.isBiDirectional() ? !this.isBidirectionalPropertyMappingConsistent(left, right, propertyMapping) : (propertyMapping.isToLeft() ? !this.isToLeftPropertyMappingConsistent(left, propertyMapping) : propertyMapping.isToRight() && !this.isToRightPropertyMappingConsistent(right, propertyMapping)));
    }

    private boolean isBidirectionalPropertyMappingConsistent(List<Attribute> left, List<Attribute> right, PropertyMapping propertyMapping) {
        boolean isConsistent = true;
        if (left.contains(propertyMapping.getLeft())) {
            this.signalAttributeisMappedMoreThanOnce(propertyMapping, true);
            isConsistent = false;
        }
        if (right.contains(propertyMapping.getRight())) {
            this.signalAttributeisMappedMoreThanOnce(propertyMapping, false);
            isConsistent = false;
        }
        if (!isConsistent) {
            return false;
        }
        left.add(propertyMapping.getLeft());
        right.add(propertyMapping.getRight());
        return true;
    }

    private boolean isToLeftPropertyMappingConsistent(List<Attribute> left, PropertyMapping propertyMapping) {
        boolean isConsistent = true;
        if (left.contains(propertyMapping.getLeft())) {
            this.signalAttributeisMappedMoreThanOnce(propertyMapping, true);
            isConsistent = false;
        }
        if (!isConsistent) {
            return false;
        }
        left.add(propertyMapping.getLeft());
        return true;
    }

    private boolean isToRightPropertyMappingConsistent(List<Attribute> right, PropertyMapping propertyMapping) {
        boolean isConsistent = true;
        if (right.contains(propertyMapping.getRight())) {
            this.signalAttributeisMappedMoreThanOnce(propertyMapping, false);
            isConsistent = false;
        }
        if (!isConsistent) {
            return false;
        }
        right.add(propertyMapping.getRight());
        return true;
    }

    private void signalAttributeisMappedMoreThanOnce(PropertyMapping propertyMapping, boolean isLeft) {
        if (isLeft) {
            this.error("attribute: '" + propertyMapping.getLeft().getName() + "' is mapped more than once", propertyMapping, (EStructuralFeature)DomPackage.eINSTANCE.getPropertyMapping_Left(), -1);
        } else {
            this.error("attribute: '" + propertyMapping.getRight().getName() + "' is mapped more than once", propertyMapping, (EStructuralFeature)DomPackage.eINSTANCE.getPropertyMapping_Right(), -1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryOperationComparator
    implements Comparator<QueryOperation> {
        private static QueryParamComparator queryParamComparator = new QueryParamComparator();

        private QueryOperationComparator() {
        }

        @Override
        public int compare(QueryOperation o1, QueryOperation o2) {
            if (!o1.getName().equals(o2.getName())) {
                return -1;
            }
            EList<QueryParameter> o1p = o1.getQueryParameters();
            EList<QueryParameter> o2p = o2.getQueryParameters();
            if (o1p.size() != o2p.size()) {
                return -1;
            }
            for (int i = 0; i < o1p.size(); ++i) {
                if (queryParamComparator.compare((QueryParameter)o1p.get(i), (QueryParameter)o2p.get(i)) == 0) continue;
                return -1;
            }
            return 0;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class QueryParamComparator
        implements Comparator<QueryParameter> {
            private QueryParamComparator() {
            }

            @Override
            public int compare(QueryParameter p1, QueryParameter p2) {
                if (!p1.getClass().equals(p2.getClass())) {
                    return -1;
                }
                if (p1 instanceof Parameter && p2 instanceof Parameter) {
                    Parameter pp1 = (Parameter)p1;
                    Parameter pp2 = (Parameter)p2;
                    Type type1 = pp1.getType();
                    Type type2 = pp2.getType();
                    if (!type1.getClass().equals(type2.getClass())) {
                        return -1;
                    }
                    if (type1 instanceof Entity || type1 instanceof ValueObject || type2 instanceof DataView) {
                        if (type1.equals(type2)) {
                            return 0;
                        }
                        return 1;
                    }
                    if (type1 instanceof SimpleType && type2 instanceof SimpleType) {
                        SimpleType p1SimpleType = (SimpleType)type1;
                        SimpleType p2SimpleType = (SimpleType)type2;
                        if (!p1SimpleType.getInstanceTypeName().equals(p2SimpleType.getInstanceTypeName())) {
                            return -1;
                        }
                    }
                    return 0;
                }
                if (!p1.getAttribute().equals(p2.getAttribute())) {
                    return -1;
                }
                return 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OperationComparator
    implements Comparator<Operation> {
        private static ServiceParamComparator serviceParamComparator = new ServiceParamComparator();

        private OperationComparator() {
        }

        @Override
        public int compare(Operation o1, Operation o2) {
            if (!o1.getName().equals(o2.getName())) {
                return -1;
            }
            EList<Parameter> o1p = o1.getParameters();
            EList<Parameter> o2p = o2.getParameters();
            if (o1p.size() != o2p.size()) {
                return -1;
            }
            for (int i = 0; i < o1p.size(); ++i) {
                if (serviceParamComparator.compare((Parameter)o1p.get(i), (Parameter)o2p.get(i)) == 0) continue;
                return -1;
            }
            return 0;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ServiceParamComparator
        implements Comparator<Parameter> {
            private ServiceParamComparator() {
            }

            @Override
            public int compare(Parameter p1, Parameter p2) {
                Type type1 = p1.getType();
                Type type2 = p2.getType();
                if (!type1.getClass().equals(type2.getClass())) {
                    return -1;
                }
                if (type1 instanceof Entity || type1 instanceof ValueObject || type1 instanceof DataView) {
                    if (type1.equals(type2)) {
                        return 0;
                    }
                    return 1;
                }
                if (type1 instanceof SimpleType && type2 instanceof SimpleType) {
                    SimpleType p1SimpleType = (SimpleType)type1;
                    SimpleType p2SimpleType = (SimpleType)type2;
                    if (p1SimpleType.getInstanceTypeName() != null && !p1SimpleType.getInstanceTypeName().equals(p2SimpleType.getInstanceTypeName())) {
                        return -1;
                    }
                    return 0;
                }
                return -1;
            }
        }
    }
}

