/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.deploy.lifecycle.phase;

import java.io.File;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentContext;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentException;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.phase.AbstractAppDeploymentPhase;
import org.codehaus.plexus.appserver.deploy.DeploymentException;

public class ExpandAppPhase
extends AbstractAppDeploymentPhase {
    public void execute(AppDeploymentContext context) throws AppDeploymentException {
        String appId = context.getApplicationId();
        File directory = context.getApplicationsDirectory();
        File file = context.getPar();
        File location = new File(directory, appId);
        if (location.exists()) {
            this.getLogger().info("Application '" + appId + "' already extracted.");
        } else {
            this.getLogger().info("Extracting " + file + " to '" + location.getAbsolutePath() + "'.");
            try {
                this.expand(file, location, false);
            }
            catch (DeploymentException e) {
                throw new AppDeploymentException("Could not deploy the JAR", e);
            }
        }
        this.getLogger().info("Deploying application '" + appId + "' at '" + location.getAbsolutePath() + "'.");
        if (context.getDeployments().containsKey(appId)) {
            throw new AppDeploymentException("A appserver with the specified appId ('" + appId + "') already exists.");
        }
    }
}

