/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.lifecycle.phase;

import java.io.File;
import org.codehaus.plexus.appserver.lifecycle.AppServerContext;
import org.codehaus.plexus.appserver.lifecycle.AppServerLifecycleException;
import org.codehaus.plexus.appserver.lifecycle.phase.AbstractAppServerPhase;
import org.codehaus.plexus.appserver.service.deploy.ServiceDeployer;
import org.codehaus.plexus.appserver.supervisor.Supervisor;
import org.codehaus.plexus.appserver.supervisor.SupervisorException;
import org.codehaus.plexus.appserver.supervisor.SupervisorListener;

public class ServiceDeploymentPhase
extends AbstractAppServerPhase {
    private ServiceDeployer serviceDeployer;
    private Supervisor serviceSupervisor;

    public void execute(AppServerContext context) throws AppServerLifecycleException {
        try {
            this.serviceSupervisor.addDirectory(new File(context.getAppServerHome(), "services"), new SupervisorListener(){

                public void onJarDiscovered(File jar) {
                    String name = jar.getName();
                    try {
                        String serviceName = name.substring(0, name.length() - 4);
                        ServiceDeploymentPhase.this.getLogger().info(ServiceDeploymentPhase.this.serviceSupervisor.getName() + " is deploying " + serviceName + ".");
                        ServiceDeploymentPhase.this.serviceDeployer.deploy(serviceName, jar);
                    }
                    catch (Exception e) {
                        ServiceDeploymentPhase.this.getLogger().error("Error while deploying service " + name + ".", (Throwable)e);
                    }
                }
            });
            this.serviceSupervisor.scan();
        }
        catch (SupervisorException e) {
            throw new AppServerLifecycleException("Error deploying services in the app server.", e);
        }
    }
}

