/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.commonscompress.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class BitInputStream
implements Closeable {
    private static final int MAXIMUM_CACHE_SIZE = 31;
    private static final int[] MASKS = new int[32];
    private final InputStream in;
    private final ByteOrder byteOrder;
    private int bitsCached = 0;
    private int bitsCachedSize = 0;

    public BitInputStream(InputStream in, ByteOrder byteOrder) {
        this.in = in;
        this.byteOrder = byteOrder;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void clearBitCache() {
        this.bitsCached = 0;
        this.bitsCachedSize = 0;
    }

    public int readBits(int count) throws IOException {
        int bitsOut;
        if (count < 0 || count > 31) {
            throw new IllegalArgumentException("count must not be negative or greater than 31");
        }
        while (this.bitsCachedSize < count) {
            int nextByte = this.in.read();
            if (nextByte < 0) {
                return nextByte;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.bitsCached |= nextByte << this.bitsCachedSize;
            } else {
                this.bitsCached <<= 8;
                this.bitsCached |= nextByte;
            }
            this.bitsCachedSize += 8;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bitsOut = this.bitsCached & MASKS[count];
            this.bitsCached >>>= count;
        } else {
            bitsOut = this.bitsCached >> this.bitsCachedSize - count & MASKS[count];
        }
        this.bitsCachedSize -= count;
        return bitsOut;
    }

    static {
        for (int i = 1; i <= 31; ++i) {
            BitInputStream.MASKS[i] = (MASKS[i - 1] << 1) + 1;
        }
    }
}

