/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.InputStreamSupplier;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ParallelScatterZipCreator;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterGatherBackingStore;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterGatherBackingStoreSupplier;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterZipOutputStream;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.StreamCompressor;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveEntry;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveOutputStream;
import org.codehaus.plexus.archiver.zip.DeferredScatterOutputStream;

public class ConcurrentJarCreator {
    ScatterZipOutputStream directories;
    ScatterZipOutputStream manifest;
    private final ParallelScatterZipCreator parallelScatterZipCreator;
    private long zipCloseElapsed;

    public static ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) throws IOException {
        ScatterGatherBackingStore bs = scatterGatherBackingStoreSupplier.get();
        StreamCompressor sc = StreamCompressor.create(-1, bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    public ConcurrentJarCreator(int nThreads) throws IOException {
        DeferredSupplier defaultSupplier = new DeferredSupplier();
        this.directories = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.manifest = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.parallelScatterZipCreator = new ParallelScatterZipCreator(nThreads, defaultSupplier);
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier source) throws IOException {
        int method = zipArchiveEntry.getMethod();
        if (method == -1) {
            throw new IllegalArgumentException("Method must be set on the supplied zipArchiveEntry");
        }
        if (zipArchiveEntry.isDirectory() && !zipArchiveEntry.isUnixSymlink()) {
            ByteArrayInputStream payload = new ByteArrayInputStream(new byte[0]);
            this.directories.addArchiveEntry(zipArchiveEntry, payload, 0);
            payload.close();
        } else if ("META-INF".equals(zipArchiveEntry.getName()) || "META-INF/MANIFEST.MF".equals(zipArchiveEntry.getName())) {
            InputStream payload = source.get();
            this.manifest.addArchiveEntry(zipArchiveEntry, payload, zipArchiveEntry.isDirectory() ? 0 : method);
            payload.close();
        } else {
            this.parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, source);
        }
    }

    public void writeTo(ZipArchiveOutputStream targetStream) throws IOException, ExecutionException, InterruptedException {
        this.manifest.writeTo(targetStream);
        this.directories.writeTo(targetStream);
        this.parallelScatterZipCreator.writeTo(targetStream);
        long startAt = System.currentTimeMillis();
        targetStream.close();
        this.zipCloseElapsed = System.currentTimeMillis() - startAt;
        this.manifest.close();
        this.directories.close();
    }

    public String getStatisticsMessage() {
        return this.parallelScatterZipCreator.getStatisticsMessage() + " Zip Close: " + this.zipCloseElapsed + "ms";
    }

    static class DeferredSupplier
    implements ScatterGatherBackingStoreSupplier {
        DeferredSupplier() {
        }

        public ScatterGatherBackingStore get() throws IOException {
            return new DeferredScatterOutputStream();
        }
    }
}

