/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;
import org.codehaus.plexus.archiver.zip.DeferredScatterOutputStream;

public class ConcurrentJarCreator {
    private final ScatterZipOutputStream directories;
    private final ScatterZipOutputStream metaInfDir;
    private final ScatterZipOutputStream manifest;
    private final ScatterZipOutputStream synchronousEntries;
    private final ParallelScatterZipCreator parallelScatterZipCreator;
    private long zipCloseElapsed;

    public static ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) throws IOException {
        ScatterGatherBackingStore bs = scatterGatherBackingStoreSupplier.get();
        StreamCompressor sc = StreamCompressor.create((int)-1, (ScatterGatherBackingStore)bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    public ConcurrentJarCreator(int nThreads) throws IOException {
        DeferredSupplier defaultSupplier = new DeferredSupplier();
        this.directories = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.manifest = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.metaInfDir = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.synchronousEntries = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.parallelScatterZipCreator = new ParallelScatterZipCreator(Executors.newFixedThreadPool(nThreads), (ScatterGatherBackingStoreSupplier)defaultSupplier);
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier source, boolean addInParallel) throws IOException {
        int method = zipArchiveEntry.getMethod();
        if (method == -1) {
            throw new IllegalArgumentException("Method must be set on the supplied zipArchiveEntry");
        }
        if (zipArchiveEntry.isDirectory() && !zipArchiveEntry.isUnixSymlink()) {
            ByteArrayInputStream payload = new ByteArrayInputStream(new byte[0]);
            this.directories.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)this.createInputStreamSupplier(payload)));
            payload.close();
        } else if ("META-INF".equals(zipArchiveEntry.getName()) || "META-INF/".equals(zipArchiveEntry.getName())) {
            InputStream payload = source.get();
            if (zipArchiveEntry.isDirectory()) {
                zipArchiveEntry.setMethod(0);
            }
            this.metaInfDir.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)this.createInputStreamSupplier(payload)));
            payload.close();
        } else if ("META-INF/MANIFEST.MF".equals(zipArchiveEntry.getName())) {
            InputStream payload = source.get();
            if (zipArchiveEntry.isDirectory()) {
                zipArchiveEntry.setMethod(0);
            }
            this.manifest.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)this.createInputStreamSupplier(payload)));
            payload.close();
        } else if (addInParallel) {
            this.parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, source);
        } else {
            this.synchronousEntries.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)source));
        }
    }

    private InputStreamSupplier createInputStreamSupplier(final InputStream payload) {
        return new InputStreamSupplier(){

            public InputStream get() {
                return payload;
            }
        };
    }

    public void writeTo(ZipArchiveOutputStream targetStream) throws IOException, ExecutionException, InterruptedException {
        this.metaInfDir.writeTo(targetStream);
        this.manifest.writeTo(targetStream);
        this.directories.writeTo(targetStream);
        this.synchronousEntries.writeTo(targetStream);
        this.parallelScatterZipCreator.writeTo(targetStream);
        long startAt = System.currentTimeMillis();
        targetStream.close();
        this.zipCloseElapsed = System.currentTimeMillis() - startAt;
        this.metaInfDir.close();
        this.manifest.close();
        this.directories.close();
        this.synchronousEntries.close();
    }

    public String getStatisticsMessage() {
        return this.parallelScatterZipCreator.getStatisticsMessage() + " Zip Close: " + this.zipCloseElapsed + "ms";
    }

    static class DeferredSupplier
    implements ScatterGatherBackingStoreSupplier {
        DeferredSupplier() {
        }

        public ScatterGatherBackingStore get() throws IOException {
            return new DeferredScatterOutputStream();
        }
    }
}

