/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.input.BoundedInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver {
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";
    private long maxOutputSize = Long.MAX_VALUE;

    public AbstractZipUnArchiver() {
    }

    public AbstractZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }

    public void setMaxOutputSize(long maxOutputSize) {
        if (maxOutputSize <= 0L) {
            throw new IllegalArgumentException("Invalid max output size specified: " + maxOutputSize);
        }
        this.maxOutputSize = maxOutputSize;
    }

    @Override
    protected void execute() throws ArchiverException {
        this.execute("", this.getDestDirectory());
    }

    private String resolveSymlink(ZipFile zf, ZipArchiveEntry ze) throws IOException {
        if (ze.isUnixSymlink()) {
            return zf.getUnixSymlink(ze);
        }
        return null;
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        this.getLogger().debug("Expanding: " + this.getSourceFile() + " into " + outputDirectory);
        try (ZipFile zipFile = ((ZipFile.Builder)((ZipFile.Builder)ZipFile.builder().setFile(this.getSourceFile())).setCharset(this.encoding)).setUseUnicodeExtraFields(true).get();){
            long remainingSpace = this.maxOutputSize;
            Enumeration e = zipFile.getEntriesInPhysicalOrder();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zipFile, ze);
                if (!this.isSelected(ze.getName(), fileInfo) || !ze.getName().startsWith(path)) continue;
                InputStream in = zipFile.getInputStream(ze);
                try {
                    BoundedInputStream bis = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(in)).setMaxCount(remainingSpace + 1L)).get();
                    long time = ze.getTime();
                    if (time <= 0L) {
                        time = 0L;
                    }
                    this.extractFile(this.getSourceFile(), outputDirectory, (InputStream)bis, ze.getName(), new Date(time), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zipFile, ze), this.getFileMappers());
                    if ((remainingSpace -= bis.getCount()) >= 0L) continue;
                    throw new ArchiverException("Maximum output size limit reached");
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
        }
    }

    private static class ZipEntryFileInfo
    implements PlexusIoResource {
        private final ZipFile zipFile;
        private final ZipArchiveEntry zipEntry;

        ZipEntryFileInfo(ZipFile zipFile, ZipArchiveEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public boolean isFile() {
            return !this.zipEntry.isDirectory() && !this.zipEntry.isUnixSymlink();
        }

        public boolean isSymbolicLink() {
            return this.zipEntry.isUnixSymlink();
        }

        @Nonnull
        public InputStream getContents() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        public long getLastModified() {
            long l = this.zipEntry.getTime();
            return l <= 0L ? 0L : l;
        }

        public long getSize() {
            long l = this.zipEntry.getSize();
            return l == -1L ? -1L : l;
        }

        public URL getURL() throws IOException {
            return null;
        }

        public boolean isExisting() {
            return true;
        }
    }
}

