/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.AbstractSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSourceInclusionScanner
extends AbstractSourceInclusionScanner {
    private Set sourceIncludes;
    private Set sourceExcludes;

    public SimpleSourceInclusionScanner(Set sourceIncludes, Set sourceExcludes) {
        this.sourceIncludes = sourceIncludes;
        this.sourceExcludes = sourceExcludes;
    }

    @Override
    public Set<File> getIncludedSources(File sourceDir, File targetDir) throws InclusionScanException {
        List<SourceMapping> srcMappings = this.getSourceMappings();
        if (srcMappings.isEmpty()) {
            return Collections.emptySet();
        }
        String[] potentialSources = this.scanForSources(sourceDir, this.sourceIncludes, this.sourceExcludes);
        HashSet<File> matchingSources = new HashSet<File>(potentialSources != null ? potentialSources.length : 0);
        if (potentialSources != null) {
            for (String potentialSource : potentialSources) {
                matchingSources.add(new File(sourceDir, potentialSource));
            }
        }
        return matchingSources;
    }
}

