/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerNotImplementedException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompiler
implements Compiler {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String EOL = System.lineSeparator();
    protected static final String PS = System.getProperty("path.separator");
    private final CompilerOutputStyle compilerOutputStyle;
    private final String inputFileEnding;
    private final String outputFileEnding;
    private final String outputFile;

    protected AbstractCompiler(CompilerOutputStyle compilerOutputStyle, String inputFileEnding, String outputFileEnding, String outputFile) {
        this.compilerOutputStyle = compilerOutputStyle;
        this.inputFileEnding = inputFileEnding;
        this.outputFileEnding = outputFileEnding;
        this.outputFile = outputFile;
    }

    public abstract String getCompilerId();

    @Override
    public CompilerResult performCompile(CompilerConfiguration configuration) throws CompilerException {
        throw new CompilerNotImplementedException("The performCompile method has not been implemented.");
    }

    @Override
    public CompilerOutputStyle getCompilerOutputStyle() {
        return this.compilerOutputStyle;
    }

    @Override
    public String getInputFileEnding(CompilerConfiguration configuration) throws CompilerException {
        return this.inputFileEnding;
    }

    @Override
    public String getOutputFileEnding(CompilerConfiguration configuration) throws CompilerException {
        if (this.compilerOutputStyle != CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            throw new RuntimeException("This compiler implementation doesn't have one output file per input file.");
        }
        return this.outputFileEnding;
    }

    @Override
    public String getOutputFile(CompilerConfiguration configuration) throws CompilerException {
        if (this.compilerOutputStyle != CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            throw new RuntimeException("This compiler implementation doesn't have one output file for all files.");
        }
        return this.outputFile;
    }

    @Override
    public boolean canUpdateTarget(CompilerConfiguration configuration) throws CompilerException {
        return true;
    }

    public static String getPathString(List<String> pathElements) {
        StringBuilder sb = new StringBuilder();
        for (String pathElement : pathElements) {
            sb.append(pathElement).append(File.pathSeparator);
        }
        return sb.toString();
    }

    protected static Set<String> getSourceFilesForSourceRoot(CompilerConfiguration config, String sourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceLocation);
        Set<String> includes = config.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            String[] inclStrs = includes.toArray(new String[0]);
            scanner.setIncludes(inclStrs);
        } else {
            scanner.setIncludes(new String[]{"**/*.java"});
        }
        Set<String> excludes = config.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            String[] exclStrs = excludes.toArray(new String[0]);
            scanner.setExcludes(exclStrs);
        }
        scanner.scan();
        String[] sourceDirectorySources = scanner.getIncludedFiles();
        HashSet<String> sources = new HashSet<String>();
        for (String sourceDirectorySource : sourceDirectorySources) {
            File f = new File(sourceLocation, sourceDirectorySource);
            sources.add(f.getPath());
        }
        return sources;
    }

    protected static String[] getSourceFiles(CompilerConfiguration config) {
        HashSet<String> sources = new HashSet<String>();
        Set<File> sourceFiles = config.getSourceFiles();
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            for (File sourceFile : sourceFiles) {
                sources.add(sourceFile.getAbsolutePath());
            }
        } else {
            for (String sourceLocation : config.getSourceLocations()) {
                sources.addAll(AbstractCompiler.getSourceFilesForSourceRoot(config, sourceLocation));
            }
        }
        String[] result = sources.isEmpty() ? new String[]{} : sources.toArray(new String[0]);
        return result;
    }

    protected static String makeClassName(String fileName, String sourceDir) throws CompilerException {
        File origFile = new File(fileName);
        String canonical = null;
        if (origFile.exists()) {
            canonical = AbstractCompiler.getCanonicalPath(origFile).replace('\\', '/');
        }
        if (sourceDir != null) {
            String prefix = AbstractCompiler.getCanonicalPath(new File(sourceDir)).replace('\\', '/');
            if (canonical != null) {
                if (canonical.startsWith(prefix)) {
                    String result = canonical.substring(prefix.length() + 1, canonical.length() - 5);
                    result = result.replace('/', '.');
                    return result;
                }
            } else {
                File t = new File(sourceDir, fileName);
                if (t.exists()) {
                    String str = AbstractCompiler.getCanonicalPath(t).replace('\\', '/');
                    return str.substring(prefix.length() + 1, str.length() - 5).replace('/', '.');
                }
            }
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        fileName = fileName.replace('\\', '.');
        return fileName.replace('/', '.');
    }

    private static String getCanonicalPath(File origFile) throws CompilerException {
        try {
            return origFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CompilerException("Error while getting the canonical path of '" + origFile.getAbsolutePath() + "'.", e);
        }
    }

    protected void logCompiling(String[] sourceFiles, CompilerConfiguration config) {
        if (this.log.isInfoEnabled()) {
            String to = config.getWorkingDirectory() == null ? config.getOutputLocation() : config.getWorkingDirectory().toPath().relativize(new File(config.getOutputLocation()).toPath()).toString();
            this.log.info("Compiling " + (sourceFiles == null ? "" : sourceFiles.length + " source file" + (sourceFiles.length == 1 ? " " : "s ")) + "with " + this.getCompilerId() + " [" + config.describe() + "] to " + to);
        }
    }
}

