/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.ann;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.codehaus.plexus.metadata.ann.Ann;
import org.codehaus.plexus.metadata.ann.AnnClass;
import org.codehaus.plexus.metadata.ann.AnnEnum;
import org.codehaus.plexus.metadata.ann.AnnField;
import org.codehaus.plexus.metadata.ann.AnnMethod;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AnnReader
extends ClassVisitor {
    private final AnnClass annClass;

    private AnnReader(AnnClass annClass) {
        super(589824);
        this.annClass = annClass;
    }

    public static AnnClass read(InputStream is, ClassLoader cl) throws IOException {
        AnnClass annClass = new AnnClass(cl);
        AnnReader cv = new AnnReader(annClass);
        ClassReader r = new ClassReader(is);
        r.accept((ClassVisitor)cv, 5);
        return annClass;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.annClass.setName(name);
        this.annClass.setAccess(access);
        this.annClass.setSuperName(superName);
        this.annClass.setInterfaces(interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Ann ann = new Ann(desc);
        this.annClass.addAnn(ann);
        return new AnnAnnReader(ann);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        final AnnField field = new AnnField(this.annClass, access, name, desc);
        this.annClass.addField(field);
        return new FieldVisitor(589824){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                Ann ann = new Ann(desc);
                field.addAnn(ann);
                return new AnnAnnReader(ann);
            }
        };
    }

    public MethodVisitor visitMethod(int access, String mname, String mdesc, String signature, String[] exceptions) {
        final AnnMethod method = new AnnMethod(this.annClass, access, mname, mdesc);
        this.annClass.addMethod(method);
        return new MethodVisitor(589824){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                Ann ann = new Ann(desc);
                method.addAnn(ann);
                return new AnnAnnReader(ann);
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                Ann ann = new Ann(desc);
                method.addParamAnn(parameter, ann);
                return new AnnAnnReader(ann);
            }
        };
    }

    static class AnnAnnReader
    extends AnnotationVisitor {
        private Ann ann;

        public AnnAnnReader(Ann ann) {
            super(589824);
            this.ann = ann;
        }

        public void visit(String name, Object value) {
            this.ann.addParam(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            this.ann.addParam(name, new AnnEnum(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            Ann ann = new Ann(desc);
            this.ann.addParam(name, ann);
            return new AnnAnnReader(ann);
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnAnnArrayReader(this.ann, name);
        }
    }

    static class AnnAnnArrayReader
    extends AnnotationVisitor {
        private Ann ann;
        private String name;
        private ArrayList<String> array = new ArrayList();

        public AnnAnnArrayReader(Ann ann, String name) {
            super(589824);
            this.ann = ann;
            this.name = name;
        }

        public void visit(String name, Object value) {
            if (value instanceof String) {
                this.array.add((String)value);
            }
        }

        public void visitEnd() {
            this.ann.addParam(this.name, this.array.toArray(new String[this.array.size()]));
        }
    }
}

