/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.factory.UndefinedComponentFactoryException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractComponentManager
implements ComponentManager,
Cloneable {
    private MutablePlexusContainer container;
    private ComponentDescriptor componentDescriptor;
    private LifecycleHandler lifecycleHandler;
    private int connections;
    private String id = null;

    public ComponentManager copy() {
        try {
            ComponentManager componentManager = (ComponentManager)this.clone();
            return componentManager;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.componentDescriptor;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    protected void incrementConnectionCount() {
        ++this.connections;
    }

    protected void decrementConnectionCount() {
        --this.connections;
    }

    protected boolean connected() {
        return this.connections > 0;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setup(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor componentDescriptor) {
        this.container = container;
        this.lifecycleHandler = lifecycleHandler;
        this.componentDescriptor = componentDescriptor;
    }

    public void initialize() {
    }

    protected Object createComponentInstance() throws ComponentInstantiationException, ComponentLifecycleException {
        Object component = this.createComponentInstance(this.componentDescriptor);
        this.startComponentLifecycle(component);
        return component;
    }

    protected void startComponentLifecycle(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().start(component, this);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error starting component", (Throwable)e);
        }
    }

    public void suspend(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().suspend(component, this);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error suspending component", (Throwable)e);
        }
    }

    public void resume(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().resume(component, this);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error suspending component", (Throwable)e);
        }
    }

    protected void endComponentLifecycle(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().end(component, this);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error ending component lifecycle", (Throwable)e);
        }
    }

    public MutablePlexusContainer getContainer() {
        return this.container;
    }

    public Logger getLogger() {
        return this.container.getLogger();
    }

    protected Object createComponentInstance(ComponentDescriptor componentDescriptor) throws ComponentInstantiationException, ComponentLifecycleException {
        String componentFactoryId = componentDescriptor.getComponentFactory();
        ComponentFactory componentFactory = null;
        Object component = null;
        try {
            componentFactory = componentFactoryId != null ? this.container.getComponentFactoryManager().findComponentFactory(componentFactoryId) : this.container.getComponentFactoryManager().getDefaultComponentFactory();
            component = componentFactory.newInstance(componentDescriptor, this.container.getContainerRealm(), this.container);
        }
        catch (UndefinedComponentFactoryException e) {
            throw new ComponentInstantiationException("Unable to create component as factory '" + componentFactoryId + "' could not be found", e);
        }
        finally {
            if (StringUtils.isNotEmpty((String)componentFactoryId) && !"java".equals(componentFactoryId)) {
                this.release(componentFactory);
            }
        }
        return component;
    }

    public abstract /* synthetic */ Object getComponent() throws ComponentInstantiationException, ComponentLifecycleException;

    public abstract /* synthetic */ void release(Object var1) throws ComponentLifecycleException;

    public abstract /* synthetic */ void dispose() throws ComponentLifecycleException;
}

