/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator;

import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.expression.DefaultExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractComponentConfigurator
implements ComponentConfigurator,
Contextualizable {
    protected MutablePlexusContainer container;
    protected ConverterLookup converterLookup = new DefaultConverterLookup();

    public void configureComponent(Object component, PlexusConfiguration configuration, ClassRealm classRealm) throws ComponentConfigurationException {
        this.configureComponent(component, configuration, (ExpressionEvaluator)new DefaultExpressionEvaluator(), classRealm);
    }

    public void configureComponent(Object component, PlexusConfiguration configuration, ClassLoader classLoader) throws ComponentConfigurationException {
        this.configureComponent(component, configuration, AbstractComponentConfigurator.createClassRealm(this.container, classLoader));
    }

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm classRealm) throws ComponentConfigurationException {
        this.configureComponent(component, configuration, expressionEvaluator, classRealm, null);
    }

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassLoader classLoader) throws ComponentConfigurationException {
        this.configureComponent(component, configuration, expressionEvaluator, AbstractComponentConfigurator.createClassRealm(this.container, classLoader));
    }

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm classRealm, ConfigurationListener listener) throws ComponentConfigurationException {
        this.configureComponent(component, configuration, expressionEvaluator, classRealm);
    }

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassLoader classLoader, ConfigurationListener listener) throws ComponentConfigurationException {
        this.configureComponent(component, configuration, expressionEvaluator, AbstractComponentConfigurator.createClassRealm(this.container, classLoader), listener);
    }

    public static ClassRealm createClassRealm(MutablePlexusContainer container, ClassLoader classLoader) throws ComponentConfigurationException {
        try {
            ClassRealm realm = null;
            try {
                realm = container.getClassWorld().getRealm(classLoader.toString());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                // empty catch block
            }
            if (realm == null) {
                realm = container.getClassWorld().newRealm(classLoader.toString(), classLoader);
            }
            return realm;
        }
        catch (DuplicateRealmException e) {
            throw new ComponentConfigurationException("Error converting ClassLoader to a ClassRealm.", (Throwable)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (MutablePlexusContainer)context.get((Object)"plexus");
    }
}

