/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.composition.AbstractComponentComposer;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.Requirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.ReflectionUtils;

public class FieldComponentComposer
extends AbstractComponentComposer {
    public void assignRequirement(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container, Map compositionContext, ClassRealm lookupRealm) throws CompositionException {
        Field field = this.findMatchingField(component, componentDescriptor, requirement, container);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.assignRequirementToField(component, field, container, requirement, lookupRealm);
    }

    private List assignRequirementToField(Object component, Field field, PlexusContainer container, ComponentRequirement requirementDescriptor, ClassRealm lookupRealm) throws CompositionException {
        Requirement requirement = FieldComponentComposer.findRequirement(component, field.getType(), container, requirementDescriptor, lookupRealm);
        try {
            field.set(component, requirement.getAssignment());
            return requirement.getComponentDescriptors();
        }
        catch (IllegalArgumentException e) {
            String msg = "";
            for (Class<?> c = requirement.getAssignment().getClass(); c != null && !c.isAssignableFrom(class$java$lang$Object == null ? FieldComponentComposer.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
                Class<?>[] ifaces = c.getInterfaces();
                msg = msg + "  Interfaces for " + c + ":";
                for (int i = 0; i < ifaces.length; ++i) {
                    msg = msg + "\n    Interface " + ifaces[i];
                    if (ifaces[i].getClassLoader() == null) continue;
                    msg = msg + "; realm: " + (ifaces[i].getClassLoader() instanceof ClassRealm ? ((ClassRealm)ifaces[i].getClassLoader()).getId() : ifaces[i].getClassLoader().toString());
                    msg = msg + this.getURLs(ifaces[i].getClassLoader());
                }
            }
            String compositionMsg = "Composition failed for the field " + field.getName() + " " + "in object of type " + component.getClass().getName() + " (lookup realm: " + lookupRealm.getId() + ")" + "\nfield type: " + field.getType() + " realm: ";
            if (field.getType().getClassLoader() != null) {
                compositionMsg = compositionMsg + (field.getType().getClassLoader() instanceof ClassRealm ? ((ClassRealm)field.getType().getClassLoader()).getId() : " classloader " + field.getType().getClassLoader());
                compositionMsg = compositionMsg + this.getURLs(field.getType().getClassLoader());
            }
            compositionMsg = compositionMsg + "\nvalue type: " + requirement.getAssignment().getClass() + " realm: ";
            if (requirement.getAssignment().getClass().getClassLoader() != null) {
                compositionMsg = compositionMsg + (requirement.getAssignment().getClass().getClassLoader() instanceof ClassRealm ? ((ClassRealm)requirement.getAssignment().getClass().getClassLoader()).getId() : " classloader " + requirement.getAssignment().getClass().getClassLoader());
                compositionMsg = compositionMsg + this.getURLs(requirement.getAssignment().getClass().getClassLoader());
            }
            compositionMsg = compositionMsg + "\nassignable: " + field.getType().isAssignableFrom(requirement.getAssignment().getClass());
            throw new CompositionException(compositionMsg + msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CompositionException("Composition failed for the field " + field.getName() + " " + "in object of type " + component.getClass().getName(), (Throwable)e);
        }
    }

    private String getURLs(ClassLoader classLoader) {
        if (classLoader == null) {
            return "";
        }
        String msg = "";
        if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                msg = msg + "\n     " + urls[i];
            }
        }
        return msg;
    }

    protected Field findMatchingField(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container) throws CompositionException {
        Field field;
        String fieldName = requirement.getFieldName();
        if (fieldName != null) {
            field = this.getFieldByName(component, fieldName, componentDescriptor);
        } else {
            Class<?> fieldClass;
            try {
                fieldClass = component.getClass().getClassLoader().loadClass(requirement.getRole());
            }
            catch (ClassNotFoundException e) {
                StringBuffer msg = new StringBuffer("Component Composition failed for component: ");
                msg.append(componentDescriptor.getHumanReadableKey());
                msg.append(": Requirement class: '");
                msg.append(requirement.getRole());
                msg.append("' not found.");
                throw new CompositionException(msg.toString(), (Throwable)e);
            }
            field = this.getFieldByType(component, fieldClass, componentDescriptor);
        }
        return field;
    }

    protected Field getFieldByName(Object component, String fieldName, ComponentDescriptor componentDescriptor) throws CompositionException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)fieldName, component.getClass());
        if (field == null) {
            StringBuffer msg = new StringBuffer("Component Composition failed. No field of name: '");
            msg.append(fieldName);
            msg.append("' exists in component: ");
            msg.append(componentDescriptor.getHumanReadableKey());
            throw new CompositionException(msg.toString());
        }
        return field;
    }

    protected Field getFieldByTypeIncludingSuperclasses(Class componentClass, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        List fields = this.getFieldsByTypeIncludingSuperclasses(componentClass, type, componentDescriptor);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() == 1) {
            return (Field)fields.get(0);
        }
        throw new CompositionException("There are several fields of type '" + type + "', " + "use 'field-name' to select the correct field.");
    }

    protected List getFieldsByTypeIncludingSuperclasses(Class componentClass, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        Class<?> arrayType = Array.newInstance(type, 0).getClass();
        Field[] fields = componentClass.getDeclaredFields();
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            Class<?> fieldType = fields[i].getType();
            if (!fieldType.isAssignableFrom(type) && !fieldType.isAssignableFrom(arrayType)) continue;
            foundFields.add(fields[i]);
        }
        if (componentClass.getSuperclass() != Object.class) {
            List superFields = this.getFieldsByTypeIncludingSuperclasses(componentClass.getSuperclass(), type, componentDescriptor);
            foundFields.addAll(superFields);
        }
        return foundFields;
    }

    protected Field getFieldByType(Object component, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        Field field = this.getFieldByTypeIncludingSuperclasses(component.getClass(), type, componentDescriptor);
        if (field == null) {
            StringBuffer msg = new StringBuffer("Component composition failed. No field of type: '");
            msg.append(type);
            msg.append("' exists in class '");
            msg.append(component.getClass().getName());
            msg.append("'.");
            if (componentDescriptor != null) {
                msg.append(" Component: ");
                msg.append(componentDescriptor.getHumanReadableKey());
            }
            throw new CompositionException(msg.toString());
        }
        return field;
    }
}

