/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.collections.AbstractComponentCollection;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentList<T>
extends AbstractComponentCollection<T>
implements List<T> {
    private List<T> components;

    public ComponentList(MutablePlexusContainer container, Class<T> type, String role, List<String> roleHints, String hostComponent) {
        super(container, type, role, roleHints, hostComponent);
    }

    @Override
    public int size() {
        return this.getComponentDescriptorMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getComponentDescriptorMap().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.getList().contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public <X> X[] toArray(X[] ts) {
        return this.getList().toArray(ts);
    }

    @Override
    public boolean add(T object) {
        this.getList().add(object);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("You cannot modify this list. This list is a requirement of " + this.hostComponent + " and managed by the container.");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getList().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("You cannot modify this list. This list is a requirement of " + this.hostComponent + " and managed by the container.");
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("You cannot modify this list. This list is a requirement of " + this.hostComponent + " and managed by the container.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getList().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getList().retainAll(collection);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List other = (List)o;
        return ((Object)this.getList()).equals(other);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }

    @Override
    public T get(int i) {
        return this.getList().get(i);
    }

    @Override
    public T set(int i, T object) {
        throw new UnsupportedOperationException("You cannot modify this list. This list is a requirement of " + this.hostComponent + " and managed by the container.");
    }

    @Override
    public void add(int i, T object) {
        throw new UnsupportedOperationException("You cannot modify this list. This list is a requirement of " + this.hostComponent + " and managed by the container.");
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("You cannot modify this list. This list is a requirement of " + this.hostComponent + " and managed by the container.");
    }

    @Override
    public int indexOf(Object object) {
        return this.getList().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getList().lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    private List<T> getList() {
        if (this.components == null || this.checkUpdate()) {
            ArrayList<T> componentList = new ArrayList<T>();
            Map descriptorMap = this.getComponentDescriptorMap();
            if (this.roleHints != null) {
                for (String roleHint : this.roleHints) {
                    ComponentDescriptor componentDescriptor = descriptorMap.get(roleHint);
                    Object component = this.lookup(componentDescriptor);
                    if (component == null) continue;
                    componentList.add(component);
                }
            } else {
                for (Map.Entry entry : descriptorMap.entrySet()) {
                    ComponentDescriptor componentDescriptor = entry.getValue();
                    Object component = this.lookup(componentDescriptor);
                    if (component == null) continue;
                    componentList.add(component);
                }
            }
            this.components = componentList;
        }
        return this.components;
    }

    @Override
    protected boolean checkUpdate() {
        if (super.checkUpdate()) {
            this.components = null;
            return true;
        }
        return false;
    }

    @Override
    protected void releaseAllCallback() {
        if (this.components != null) {
            try {
                this.container.releaseAll(this.components);
            }
            catch (ComponentLifecycleException e) {
                this.logger.debug("Error releasing components in active collection: " + e.getMessage(), e);
            }
            this.components.clear();
            this.components = null;
        }
    }
}

