/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ComponentValueSetter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class ObjectWithFieldsConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        boolean retValue = true;
        if (Dictionary.class.isAssignableFrom(type)) {
            retValue = false;
        } else if (Map.class.isAssignableFrom(type)) {
            retValue = false;
        } else if (Collection.class.isAssignableFrom(type)) {
            retValue = false;
        }
        return retValue;
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValue = this.fromExpression(configuration, expressionEvaluator, type);
        if (retValue == null) {
            try {
                Class implementation = this.getClassForImplementationHint(type, configuration, classLoader);
                if (type == implementation && type.isInterface() && configuration.getChildCount() <= 0) {
                    return null;
                }
                retValue = this.instantiateObject(implementation);
                this.processConfiguration(converterLookup, retValue, classLoader, configuration, expressionEvaluator, listener);
            }
            catch (ComponentConfigurationException e) {
                if (e.getFailedConfiguration() == null) {
                    e.setFailedConfiguration(configuration);
                }
                throw e;
            }
        }
        return retValue;
    }

    public void processConfiguration(ConverterLookup converterLookup, Object object, ClassLoader classLoader, PlexusConfiguration configuration) throws ComponentConfigurationException {
        this.processConfiguration(converterLookup, object, classLoader, configuration, null);
    }

    public void processConfiguration(ConverterLookup converterLookup, Object object, ClassLoader classLoader, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        this.processConfiguration(converterLookup, object, classLoader, configuration, expressionEvaluator, null);
    }

    public void processConfiguration(ConverterLookup converterLookup, Object object, ClassLoader classLoader, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        int items = configuration.getChildCount();
        for (int i = 0; i < items; ++i) {
            PlexusConfiguration childConfiguration = configuration.getChild(i);
            String elementName = childConfiguration.getName();
            ComponentValueSetter valueSetter = new ComponentValueSetter(this.fromXML(elementName), object, converterLookup, listener);
            valueSetter.configure(childConfiguration, classLoader, expressionEvaluator);
        }
    }
}

