package org.codehaus.plexus.digest;

/*
 * Copyright 2001-2006 The Codehaus.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import javax.inject.Named;

/**
 * Digester that does MD5 Message Digesting Only.
 *
 */
@Named("md5")
public class Md5Digester extends AbstractDigester {
    /**
     * <p>getFilenameExtension.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getFilenameExtension() {
        return ".md5";
    }

    /**
     * <p>Constructor for Md5Digester.</p>
     */
    public Md5Digester() {
        super(new StreamingMd5Digester());
    }
}
