/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.digest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.digest.DigestUtils;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.digest.StreamingDigester;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractDigester
implements Digester {
    private final StreamingDigester streamingDigester;

    protected AbstractDigester(StreamingDigester streamingDigester) {
        this.streamingDigester = streamingDigester;
    }

    @Override
    public String getAlgorithm() {
        return this.streamingDigester.getAlgorithm();
    }

    @Override
    public String calc(File file) throws DigesterException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.streamingDigester.reset();
            this.streamingDigester.update(fis);
            string = this.streamingDigester.calc();
        }
        catch (IOException e) {
            try {
                throw new DigesterException("Unable to calculate the " + this.streamingDigester.getAlgorithm() + " hashcode for " + file.getAbsolutePath() + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fis);
        return string;
    }

    @Override
    public void verify(File file, String checksum) throws DigesterException {
        String sum;
        String trimmedChecksum = DigestUtils.cleanChecksum(checksum, this.streamingDigester.getAlgorithm(), file.getName());
        if (!StringUtils.equalsIgnoreCase((String)trimmedChecksum, (String)(sum = this.calc(file)))) {
            throw new DigesterException("Checksum failed (expected=" + trimmedChecksum + ", actual=" + sum + ")");
        }
    }

    public String toString() {
        return "[Digester:" + this.streamingDigester.getAlgorithm() + "]";
    }
}

