/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.digest;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.digest.Hex;
import org.codehaus.plexus.digest.StreamingDigester;

public abstract class AbstractStreamingDigester
implements StreamingDigester {
    protected final MessageDigest md;
    private static final int BUFFER_SIZE = 32768;

    protected AbstractStreamingDigester(String algorithm) {
        try {
            this.md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to initialize digest algorithm " + algorithm + " : " + e.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return this.md.getAlgorithm();
    }

    @Override
    public String calc() throws DigesterException {
        return AbstractStreamingDigester.calc(this.md);
    }

    @Override
    public void reset() throws DigesterException {
        this.md.reset();
    }

    @Override
    public void update(InputStream is) throws DigesterException {
        AbstractStreamingDigester.update(is, this.md);
    }

    protected static String calc(MessageDigest md) {
        return Hex.encode(md.digest());
    }

    protected static void update(InputStream is, MessageDigest digest) throws DigesterException {
        try {
            byte[] buffer = new byte[32768];
            int size = is.read(buffer, 0, 32768);
            while (size >= 0) {
                digest.update(buffer, 0, size);
                size = is.read(buffer, 0, 32768);
            }
        }
        catch (IOException e) {
            throw new DigesterException("Unable to update " + digest.getAlgorithm() + " hash: " + e.getMessage(), e);
        }
    }
}

