/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.digest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.digest.DigestUtils;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Named
public class ChecksumFile {
    @Inject
    @Named(value="sha256")
    private Digester digestSha256;
    @Inject
    @Named(value="sha1")
    private Digester digestSha1;
    @Inject
    @Named(value="md5")
    private Digester digestMd5;

    public boolean isValidChecksum(File checksumFile) throws DigesterException, FileNotFoundException, IOException {
        if (!checksumFile.exists()) {
            throw new FileNotFoundException("Unable to find checksum file " + checksumFile.getAbsolutePath());
        }
        if (!checksumFile.isFile()) {
            throw new IOException("Unable to load checksum from non-file " + checksumFile.getAbsolutePath());
        }
        String path = checksumFile.getAbsolutePath();
        Digester digester = this.findDigesterByFileSuffix(path);
        File referenceFile = new File(path.substring(0, path.length() - digester.getFilenameExtension().length()));
        String rawChecksum = FileUtils.fileRead((File)checksumFile, (String)"UTF-8");
        String expectedChecksum = DigestUtils.cleanChecksum(rawChecksum, digester, referenceFile.getName());
        String actualChecksum = digester.calc(referenceFile);
        return StringUtils.equalsIgnoreCase((String)expectedChecksum, (String)actualChecksum);
    }

    private Digester findDigesterByFileSuffix(String path) throws DigesterException {
        if (path.endsWith(this.digestMd5.getFilenameExtension())) {
            return this.digestMd5;
        }
        if (path.endsWith(this.digestSha1.getFilenameExtension())) {
            return this.digestSha1;
        }
        if (path.endsWith(this.digestSha256.getFilenameExtension())) {
            return this.digestSha256;
        }
        throw new DigesterException("Unable to determine digester type from filename " + path);
    }

    public File createChecksum(File referenceFile, Digester digester) throws DigesterException, IOException {
        File checksumFile = new File(referenceFile.getAbsolutePath() + digester.getFilenameExtension());
        String checksum = digester.calc(referenceFile);
        FileUtils.fileWrite((String)checksumFile.getAbsolutePath(), (String)"UTF-8", (String)(checksum + "  " + referenceFile.getName()));
        return checksumFile;
    }
}

