package org.codehaus.plexus.components.io.resources.proxy;

/*
 * Copyright 2007 The Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

import javax.annotation.Nonnull;

public class PlexusIoProxyResourceWithAttributes
	extends PlexusIoProxyResource
    implements PlexusIoResourceWithAttributes
{

    private final PlexusIoResourceAttributes src;

	public PlexusIoProxyResourceWithAttributes( @Nonnull final PlexusIoResource plexusIoResource,
                                                final PlexusIoResourceAttributes attrs )
    {
        super(plexusIoResource);
		this.src = attrs;
    }


	public PlexusIoResourceAttributes getAttributes() {
		return src;
	}
}
