/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender.javamail;

import java.util.Iterator;
import java.util.Properties;
import javax.mail.Session;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.mailsender.javamail.AbstractJavamailMailSender;
import org.codehaus.plexus.mailsender.javamail.DummySSLSocketFactory;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;

public class JavamailMailSender
extends AbstractJavamailMailSender
implements Initializable {
    private Properties userProperties;

    public void initialize() throws InitializationException {
        if (StringUtils.isEmpty((String)this.getSmtpHost())) {
            throw new InitializationException("Error in configuration: Missing smtpHost.");
        }
        if (this.getSmtpPort() == 0) {
            this.setSmtpPort(25);
        }
        this.setUsername(super.getUsername());
        this.setSslMode(super.isSslMode());
        this.updateProps();
    }

    public void updateProps() {
        if (this.userProperties != null) {
            Iterator<Object> i = this.userProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = this.userProperties.getProperty(key);
                this.addProperty(key, value);
            }
        }
    }

    public void updateProps(Properties userProperties) {
        this.setUserProperties(userProperties);
        this.updateProps();
    }

    public Session getSession() throws MailSenderException {
        if ("smtps".equals(this.getProperties().getProperty("mail.transport.protocol"))) {
            if ("true".equals(this.getProperties().getProperty("mail.smtp.starttls.enable"))) {
                this.setSslMode(true, true);
            } else {
                this.setSslMode(true, false);
            }
        } else {
            this.setSslMode(false);
        }
        if (StringUtils.isEmpty((String)this.getProperties().getProperty("mail.smtp.timeout"))) {
            this.addProperty("mail.smtp.timeout", "30000");
        }
        this.addProperty("mail.smtp.quitwait", "false");
        Session session = Session.getInstance((Properties)this.getProperties(), null);
        return session;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
    }

    public void setSslMode(boolean sslEnabled, boolean tlsEnabled) {
        super.setSslMode(sslEnabled, tlsEnabled);
        if (sslEnabled) {
            this.addProperty("mail.transport.protocol", "smtps");
            this.addProperty("mail.smtps.socketFactory.class", DummySSLSocketFactory.class.getName());
        } else {
            this.removeProperty("mail.smtps.socketFactory.class");
        }
        if (tlsEnabled) {
            this.addProperty("mail.smtp.starttls.enable", "true");
        }
    }
}

