/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;

public class JarHolder {
    private String urlpath = null;
    private JarFile theJar = null;
    private JarURLConnection conn = null;

    public JarHolder(String urlpath) {
        this.urlpath = urlpath;
        this.init();
    }

    public void init() {
        try {
            URL url = new URL(this.urlpath);
            this.conn = (JarURLConnection)url.openConnection();
            this.conn.setAllowUserInteraction(false);
            this.conn.setDoInput(true);
            this.conn.setDoOutput(false);
            this.conn.connect();
            this.theJar = this.conn.getJarFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.theJar.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theJar = null;
        this.conn = null;
    }

    public InputStream getResource(String theentry) throws ResourceNotFoundException {
        InputStream data = null;
        try {
            JarEntry entry = this.theJar.getJarEntry(theentry);
            if (entry != null) {
                data = this.theJar.getInputStream(entry);
            }
        }
        catch (Exception fnfe) {
            throw new ResourceNotFoundException(fnfe.getMessage());
        }
        return data;
    }

    public Hashtable getEntries() {
        Hashtable<String, String> allEntries = new Hashtable<String, String>(559);
        if (this.theJar != null) {
            Enumeration<JarEntry> all = this.theJar.entries();
            while (all.hasMoreElements()) {
                JarEntry je = all.nextElement();
                if (je.isDirectory()) continue;
                allEntries.put(je.getName(), this.urlpath);
            }
        }
        return allEntries;
    }

    public String getUrlPath() {
        return this.urlpath;
    }

    public PlexusResource getPlexusResource(final String name) {
        final JarEntry entry = this.theJar.getJarEntry(name);
        if (entry == null) {
            return null;
        }
        return new PlexusResource(){

            public File getFile() throws IOException {
                return null;
            }

            public InputStream getInputStream() throws IOException {
                return JarHolder.this.theJar.getInputStream(entry);
            }

            public String getName() {
                return JarHolder.this.conn.getURL() + name;
            }

            public URI getURI() throws IOException {
                return null;
            }

            public URL getURL() throws IOException {
                return new URL(JarHolder.this.conn.getJarFileURL(), name);
            }
        };
    }
}

