/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SourceCodeBuilderCallback;
import com.sonar.sslr.squid.SourceCodeBuilderVisitor;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.SquidAstVisitorContext;
import com.sonar.sslr.squid.SquidAstVisitorContextImpl;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.ComplexityVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import com.sonar.sslr.squid.metrics.LinesVisitor;
import java.io.File;
import java.util.Collection;
import org.sonar.cxx.CxxConfiguration;
import org.sonar.cxx.CxxLinesOfCodeVisitor;
import org.sonar.cxx.api.CxxGrammar;
import org.sonar.cxx.api.CxxKeyword;
import org.sonar.cxx.api.CxxMetric;
import org.sonar.cxx.api.CxxPunctuator;
import org.sonar.cxx.parser.CxxParser;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxxAstScanner {
    private CxxAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<CxxGrammar> ... visitors) {
        return CxxAstScanner.scanSingleFileConfig(file, new CxxConfiguration(), visitors);
    }

    public static SourceFile scanSingleFileConfig(File file, CxxConfiguration cxxConfig, SquidAstVisitor<CxxGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<CxxGrammar> scanner = CxxAstScanner.create(cxxConfig, visitors);
        scanner.scanFile(file);
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<CxxGrammar> create(CxxConfiguration conf, SquidAstVisitor<CxxGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("Cxx Project"));
        final Parser<CxxGrammar> parser = CxxParser.create((SquidAstVisitorContext<CxxGrammar>)context, conf);
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])CxxMetric.values());
        builder.setFilesMetric((MetricDef)CxxMetric.FILES);
        builder.setCommentAnalyser(new CommentAnalyser(){

            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            public String getContents(String comment) {
                return comment.substring(0, 2).equals("/*") ? comment.substring(2, comment.length() - 2) : comment.substring(2);
            }
        });
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                StringBuilder sb = new StringBuilder();
                for (Token token : astNode.findFirstChild(new AstNodeType[]{((CxxGrammar)parser.getGrammar()).declaratorId}).getTokens()) {
                    sb.append(token.getValue());
                }
                String functionName = sb.toString();
                SourceFunction function = new SourceFunction(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{((CxxGrammar)parser.getGrammar()).functionDefinition}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)CxxMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{((CxxGrammar)parser.getGrammar()).functionDefinition}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                AstNode classNameAst = astNode.findFirstChild(new AstNodeType[]{((CxxGrammar)parser.getGrammar()).className});
                String className = classNameAst == null ? "" : classNameAst.getChild(0).getTokenValue();
                SourceClass cls = new SourceClass(className + ":" + astNode.getToken().getLine(), className);
                cls.setStartAtLine(astNode.getTokenLine());
                return cls;
            }
        }, new AstNodeType[]{((CxxGrammar)parser.getGrammar()).classSpecifier}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)CxxMetric.CLASSES).subscribeTo(new AstNodeType[]{((CxxGrammar)parser.getGrammar()).classSpecifier}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)CxxMetric.LINES));
        builder.withSquidAstVisitor(new CxxLinesOfCodeVisitor(CxxMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)CxxMetric.COMMENT_LINES).withBlankCommentMetric((MetricDef)CxxMetric.COMMENT_BLANK_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)CxxMetric.STATEMENTS).subscribeTo(new AstNodeType[]{((CxxGrammar)parser.getGrammar()).statement}).build());
        AstNodeType[] complexityAstNodeType = new AstNodeType[]{((CxxGrammar)parser.getGrammar()).functionDefinition, CxxKeyword.IF, CxxKeyword.FOR, CxxKeyword.WHILE, CxxKeyword.CATCH, CxxKeyword.CASE, CxxKeyword.DEFAULT, CxxPunctuator.AND, CxxPunctuator.OR, CxxPunctuator.QUEST};
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)CxxMetric.COMPLEXITY).subscribeTo(complexityAstNodeType).build());
        for (SquidAstVisitor<CxxGrammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

