/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.SquidAstVisitor;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxxLinesOfCodeVisitor<GRAMMAR extends Grammar>
extends SquidAstVisitor<GRAMMAR>
implements AstAndTokenVisitor {
    private final MetricDef metric;
    private int lastTokenLine;

    public CxxLinesOfCodeVisitor(MetricDef metric) {
        this.metric = metric;
    }

    public void visitFile(AstNode node) {
        this.lastTokenLine = -1;
    }

    public void visitToken(Token token) {
        if (token.getType() != GenericTokenType.EOF) {
            String[] tokenLines = token.getValue().split("\n", -1);
            int firstLineAlreadyCounted = this.lastTokenLine == token.getLine() ? 1 : 0;
            this.getContext().peekSourceCode().add(this.metric, (double)(tokenLines.length - firstLineAlreadyCounted));
            this.lastTokenLine = token.getLine() + tokenLines.length - 1;
        }
    }
}

