/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.channels;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.cxx.api.CxxTokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessorChannel
extends Channel<Lexer> {
    private static final char EOF = '\uffff';

    public boolean consume(CodeReader code, Lexer output) {
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        char ch = code.charAt(0);
        if (ch != '#') {
            return false;
        }
        String tokenValue = this.read(code);
        output.addToken(new Token[]{Token.builder().setLine(line).setColumn(column).setURI(output.getURI()).setValueAndOriginalValue(tokenValue).setType((TokenType)CxxTokenType.PREPROCESSOR).build()});
        return true;
    }

    private String read(CodeReader code) {
        char ch;
        StringBuilder sb = new StringBuilder();
        while (!PreprocessorChannel.isNewline(ch = (char)code.pop()) && ch != '\uffff') {
            if (ch == '/' && code.charAt(0) == '*') {
                PreprocessorChannel.consumeComment(code);
                continue;
            }
            if (ch == '\\' && PreprocessorChannel.isNewline((char)code.peek())) {
                PreprocessorChannel.consumeNewline(code);
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static void consumeNewline(CodeReader code) {
        if (code.charAt(0) == '\r' && code.charAt(1) == '\n') {
            code.pop();
            code.pop();
        } else {
            code.pop();
        }
    }

    private static void consumeComment(CodeReader code) {
        char ch;
        code.pop();
        while ((ch = (char)code.pop()) != '\uffff') {
            if (ch != '*' || code.charAt(0) != '/') continue;
            code.pop();
            break;
        }
    }

    private static boolean isNewline(char ch) {
        return ch == '\n' || ch == '\r';
    }
}

