/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.channels;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.cxx.api.CxxTokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLiteralsChannel
extends Channel<Lexer> {
    private static final char EOF = '\uffff';
    private final StringBuilder sb = new StringBuilder();
    private int index;
    private char ch;

    public boolean consume(CodeReader code, Lexer output) {
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        this.index = 0;
        this.readStringPrefix(code);
        if (this.ch != '\"') {
            return false;
        }
        if (!this.read(code)) {
            return false;
        }
        for (int i = 0; i < this.index; ++i) {
            this.sb.append((char)code.pop());
        }
        output.addToken(new Token[]{Token.builder().setLine(line).setColumn(column).setURI(output.getURI()).setValueAndOriginalValue(this.sb.toString()).setType((TokenType)CxxTokenType.STRING).build()});
        this.sb.setLength(0);
        return true;
    }

    private boolean read(CodeReader code) {
        ++this.index;
        while (code.charAt(this.index) != this.ch) {
            if (code.charAt(this.index) == '\uffff') {
                return false;
            }
            if (code.charAt(this.index) == '\\') {
                ++this.index;
            }
            ++this.index;
        }
        ++this.index;
        return true;
    }

    private void readStringPrefix(CodeReader code) {
        this.ch = code.charAt(this.index);
        if (this.ch == 'u' || this.ch == 'U' || this.ch == 'L') {
            ++this.index;
            if (this.ch == 'u' && code.charAt(this.index) == '8') {
                ++this.index;
            }
            this.ch = code.charAt(this.index);
        }
        if (this.ch == 'R') {
            ++this.index;
            this.ch = code.charAt(this.index);
        }
    }
}

