/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.lexer;

import com.sonar.sslr.api.Preprocessor;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import org.sonar.channel.Channel;
import org.sonar.cxx.CxxConfiguration;
import org.sonar.cxx.api.CxxKeyword;
import org.sonar.cxx.api.CxxPunctuator;
import org.sonar.cxx.api.CxxTokenType;
import org.sonar.cxx.channels.CharacterLiteralsChannel;
import org.sonar.cxx.channels.PreprocessorChannel;
import org.sonar.cxx.channels.StringLiteralsChannel;
import org.sonar.cxx.lexer.BackslashChannel;

public final class CxxLexer {
    private static final String INTEGER_SUFFIX = "(((U|u)(LL|ll|L|l)?)|((LL|ll|L|l)(u|U)?))";
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String FLOAT_SUFFIX = "(f|l|F|L)";

    private CxxLexer() {
    }

    public static Lexer create(Preprocessor ... preprocessors) {
        return CxxLexer.create(new CxxConfiguration(), preprocessors);
    }

    public static Lexer create(CxxConfiguration conf, Preprocessor ... preprocessors) {
        Lexer.Builder builder = Lexer.builder().withCharset(conf.getCharset()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)new BlackHoleChannel("\\s")).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"//[^\\n\\r]*+"})).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"/\\*", "[\\s\\S]*?", "\\*/"})).withChannel((Channel)new BackslashChannel()).withChannel((Channel)new PreprocessorChannel()).withChannel((Channel)new CharacterLiteralsChannel()).withChannel((Channel)new StringLiteralsChannel()).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"[0-9]++\\.[0-9]*+" + RegexpChannelBuilder.opt((String)EXP) + RegexpChannelBuilder.opt((String)FLOAT_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"\\.[0-9]++" + RegexpChannelBuilder.opt((String)EXP) + RegexpChannelBuilder.opt((String)FLOAT_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"[0-9]++([Ee][+-]?+[0-9_]++)" + RegexpChannelBuilder.opt((String)FLOAT_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"[1-9][0-9]*+" + RegexpChannelBuilder.opt((String)INTEGER_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"0[0-7]++" + RegexpChannelBuilder.opt((String)INTEGER_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"0[xX][0-9a-fA-F]++" + RegexpChannelBuilder.opt((String)INTEGER_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{"0" + RegexpChannelBuilder.opt((String)INTEGER_SUFFIX)})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)CxxTokenType.NUMBER, (String[])new String[]{CxxKeyword.NULLPTR.getValue()})).withChannel((Channel)new IdentifierAndKeywordChannel(RegexpChannelBuilder.and((String[])new String[]{"[a-zA-Z_]", RegexpChannelBuilder.o2n((String)"\\w")}), true, (TokenType[][])new TokenType[][]{CxxKeyword.values()})).withChannel((Channel)new PunctuatorChannel((TokenType[])CxxPunctuator.values())).withChannel((Channel)new UnknownCharacterChannel());
        for (Preprocessor preprocessor : preprocessors) {
            builder.withPreprocessor(preprocessor);
        }
        return builder.build();
    }
}

