/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.preprocessor;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Preprocessor;
import com.sonar.sslr.api.PreprocessorAction;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.squid.SquidAstVisitorContext;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.cxx.CxxConfiguration;
import org.sonar.cxx.api.CppKeyword;
import org.sonar.cxx.api.CppPunctuator;
import org.sonar.cxx.api.CxxGrammar;
import org.sonar.cxx.api.CxxTokenType;
import org.sonar.cxx.lexer.CxxLexer;
import org.sonar.cxx.preprocessor.CppGrammar;
import org.sonar.cxx.preprocessor.CppParser;
import org.sonar.cxx.preprocessor.EvaluationException;
import org.sonar.cxx.preprocessor.ExpressionEvaluator;
import org.sonar.cxx.preprocessor.IncludeLexer;
import org.sonar.cxx.preprocessor.MapChain;
import org.sonar.cxx.preprocessor.SourceCodeProvider;
import org.sonar.cxx.preprocessor.StandardDefinitions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxxPreprocessor
extends Preprocessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"CxxPreprocessor");
    private Parser<CppGrammar> pplineParser = null;
    private MapChain<String, Macro> macros = new MapChain();
    private Set<File> analysedFiles = new HashSet<File>();
    private SourceCodeProvider codeProvider = new SourceCodeProvider();
    private SquidAstVisitorContext<CxxGrammar> context;
    private ExpressionEvaluator ifExprEvaluator;
    private State state = new State(null);
    private Stack<State> stateStack = new Stack();

    public CxxPreprocessor(SquidAstVisitorContext<CxxGrammar> context) {
        this(context, new CxxConfiguration());
    }

    public CxxPreprocessor(SquidAstVisitorContext<CxxGrammar> context, CxxConfiguration conf) {
        this(context, conf, new SourceCodeProvider());
    }

    public CxxPreprocessor(SquidAstVisitorContext<CxxGrammar> context, CxxConfiguration conf, SourceCodeProvider sourceCodeProvider) {
        this.context = context;
        this.ifExprEvaluator = new ExpressionEvaluator(conf, this);
        this.codeProvider = sourceCodeProvider;
        this.codeProvider.setIncludeRoots(conf.getIncludeDirectories(), conf.getBaseDir());
        this.pplineParser = CppParser.create(conf);
        for (String string : conf.getDefines()) {
            Macro macro;
            LOG.debug("parsing external macro: '{}'", (Object)string);
            if (string.equals("") || (macro = this.parseMacroDefinition("#define " + string)) == null) continue;
            LOG.info("storing external macro: '{}'", (Object)macro);
            this.macros.putHighPrio(macro.name, macro);
        }
        for (Map.Entry entry : StandardDefinitions.macros().entrySet()) {
            Token bodyToken;
            try {
                bodyToken = Token.builder().setLine(1).setColumn(0).setURI(new URI("")).setValueAndOriginalValue((String)entry.getValue()).setType((TokenType)CxxTokenType.STRING).build();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.macros.putHighPrio((String)entry.getKey(), new Macro((String)entry.getKey(), null, Lists.newArrayList((Object[])new Token[]{bodyToken})));
        }
    }

    public PreprocessorAction process(List<Token> tokens) {
        String filePath;
        Token token = tokens.get(0);
        TokenType ttype = token.getType();
        File file = this.getFileUnderAnalysis();
        String string = filePath = file == null ? token.getURI().toString() : file.getAbsolutePath();
        if (ttype == CxxTokenType.PREPROCESSOR) {
            AstNode lineAst = null;
            try {
                lineAst = this.pplineParser.parse(token.getValue()).getChild(0);
            }
            catch (RecognitionException re) {
                LOG.warn("Cannot parse '{}', ignoring...", (Object)token.getValue());
                return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
            }
            String lineKind = lineAst.getName();
            if ("ifdefLine".equals(lineKind)) {
                return this.handleIfdefLine(lineAst, token, filePath);
            }
            if ("elseLine".equals(lineKind)) {
                return this.handleElseLine(lineAst, token, filePath);
            }
            if ("endifLine".equals(lineKind)) {
                return this.handleEndifLine(lineAst, token, filePath);
            }
            if ("ifLine".equals(lineKind)) {
                return this.handleIfLine(lineAst, token, filePath);
            }
            if ("elifLine".equals(lineKind)) {
                return this.handleElIfLine(lineAst, token, filePath);
            }
            if (this.inSkippingMode()) {
                return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
            }
            if ("defineLine".equals(lineKind)) {
                return this.handleDefineLine(lineAst, token, filePath);
            }
            if ("includeLine".equals(lineKind)) {
                return this.handleIncludeLine(lineAst, token, filePath);
            }
            if ("undefLine".equals(lineKind)) {
                return this.handleUndefLine(lineAst, token, filePath);
            }
            return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
        }
        if (ttype != GenericTokenType.EOF) {
            if (this.inSkippingMode()) {
                return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
            }
            if (ttype != CxxTokenType.STRING && ttype != CxxTokenType.NUMBER) {
                return this.handleIdentifiersAndKeywords(tokens, token, filePath);
            }
        }
        return PreprocessorAction.NO_OPERATION;
    }

    public void beginPreprocessing(File file) {
        LOG.debug("beginning preprocessing '{}'", (Object)file);
        this.analysedFiles.clear();
        this.macros.clearLowPrio();
        this.state.reset();
    }

    public String valueOf(String macroname) {
        String result = null;
        Macro macro = this.macros.get(macroname);
        if (macro != null) {
            result = this.serialize(macro.body);
        }
        return result;
    }

    private PreprocessorAction handleIfdefLine(AstNode ast, Token token, String filename) {
        if (this.state.skipping) {
            ++this.state.nestedIfdefs;
        } else {
            Macro macro = this.macros.get(this.getMacroName(ast));
            TokenType tokType = ast.getToken().getType();
            if (tokType == CppKeyword.IFDEF && macro == null || tokType == CppKeyword.IFNDEF && macro != null) {
                LOG.trace("[{}:{}]: '{}' evaluated to false, skipping tokens that follow", new Object[]{filename, token.getLine(), token.getValue()});
                this.state.skipping = true;
            }
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleElseLine(AstNode ast, Token token, String filename) {
        if (this.state.nestedIfdefs == 0) {
            if (this.state.skipping) {
                LOG.trace("[{}:{}]: #else, returning to non-skipping mode", (Object)filename, (Object)token.getLine());
            } else {
                LOG.trace("[{}:{}]: skipping tokens inside the #else", (Object)filename, (Object)token.getLine());
            }
            this.state.skipping = !this.state.skipping;
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleEndifLine(AstNode ast, Token token, String filename) {
        if (this.state.nestedIfdefs > 0) {
            --this.state.nestedIfdefs;
        } else {
            if (this.state.skipping) {
                LOG.trace("[{}:{}]: #endif, returning to non-skipping mode", (Object)filename, (Object)token.getLine());
            }
            this.state.skipping = false;
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleIfLine(AstNode ast, Token token, String filename) {
        if (this.state.skipping) {
            ++this.state.nestedIfdefs;
        } else {
            LOG.trace("[{}:{}]: handling #if line '{}'", new Object[]{filename, token.getLine(), token.getValue()});
            try {
                this.state.skipping = !this.ifExprEvaluator.eval(ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).constantExpression}));
            }
            catch (EvaluationException e) {
                LOG.error("[{}:{}]: error evaluating the expression {} assume 'true' ...", new Object[]{filename, token.getLine(), token.getValue()});
                LOG.error(e.toString());
                this.state.skipping = false;
            }
            if (this.state.skipping) {
                LOG.trace("[{}:{}]: '{}' evaluated to false, skipping tokens that follow", new Object[]{filename, token.getLine(), token.getValue()});
            }
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleElIfLine(AstNode ast, Token token, String filename) {
        if (this.state.nestedIfdefs == 0) {
            if (this.state.skipping) {
                try {
                    LOG.trace("[{}:{}]: handling #elif line '{}'", new Object[]{filename, token.getLine(), token.getValue()});
                    this.state.skipping = false;
                    this.state.skipping = !this.ifExprEvaluator.eval(ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).constantExpression}));
                }
                catch (EvaluationException e) {
                    LOG.error("[{}:{}]: error evaluating the expression {} assume 'true' ...", new Object[]{filename, token.getLine(), token.getValue()});
                    LOG.error(e.toString());
                    this.state.skipping = false;
                }
                if (this.state.skipping) {
                    LOG.trace("[{}:{}]: '{}' evaluated to false, skipping tokens that follow", new Object[]{filename, token.getLine(), token.getValue()});
                }
            } else {
                this.state.skipping = !this.state.skipping;
                LOG.trace("[{}:{}]: skipping tokens inside the #elif", (Object)filename, (Object)token.getLine());
            }
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleDefineLine(AstNode ast, Token token, String filename) {
        Macro macro = this.parseMacroDefinition(ast);
        if (macro != null) {
            LOG.trace("[{}:{}]: storing macro: '{}'", new Object[]{filename, token.getLine(), macro});
            this.macros.putLowPrio(macro.name, macro);
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreprocessorAction handleIncludeLine(AstNode ast, Token token, String filename) {
        File includedFile = this.findIncludedFile(ast, token, filename);
        if (includedFile == null) {
            LOG.warn("[{}:{}]: cannot find the sources for '{}'", new Object[]{filename, token.getLine(), token.getValue()});
        } else if (!this.analysedFiles.contains(includedFile)) {
            this.analysedFiles.add(includedFile.getAbsoluteFile());
            LOG.debug("[{}:{}]: processing {}, resolved to file '{}'", new Object[]{filename, token.getLine(), token.getValue(), includedFile.getAbsolutePath()});
            this.stateStack.push(this.state);
            this.state = new State(includedFile);
            try {
                IncludeLexer.create(this).lex(this.codeProvider.getSourceCode(includedFile));
            }
            finally {
                this.state = this.stateStack.pop();
            }
        } else {
            LOG.debug("[{}:{}]: skipping already included file '{}'", new Object[]{filename, token.getLine(), includedFile});
        }
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleUndefLine(AstNode ast, Token token, String filename) {
        String macroName = ast.findFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER}).getTokenValue();
        this.macros.removeLowPrio(macroName);
        return new PreprocessorAction(1, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText((Token[])new Token[]{token})}), new ArrayList());
    }

    PreprocessorAction handleIdentifiersAndKeywords(List<Token> tokens, Token curr, String filename) {
        PreprocessorAction ppaction = PreprocessorAction.NO_OPERATION;
        Macro macro = this.macros.get(curr.getValue());
        if (macro != null) {
            List<Token> replTokens = new LinkedList<Token>();
            int tokensConsumed = 0;
            ArrayList<Token> arguments = new ArrayList<Token>();
            if (macro.params == null) {
                tokensConsumed = 1;
                replTokens = this.expandMacro(macro.name, this.serialize(this.evaluateHashhashOperators(macro.body)));
            } else {
                int tokensConsumedMatchingArgs = this.expandFunctionLikeMacro(macro.name, tokens.subList(1, tokens.size()), replTokens);
                if (tokensConsumedMatchingArgs > 0) {
                    tokensConsumed = 1 + tokensConsumedMatchingArgs;
                }
            }
            if (tokensConsumed > 0) {
                replTokens = this.reallocate(replTokens, curr);
                LOG.trace("[{}:{}]: replacing '" + curr.getValue() + (arguments.size() == 0 ? "" : "(" + this.serialize(arguments, ", ") + ")") + "' -> '" + this.serialize(replTokens) + "'", (Object)filename, (Object)curr.getLine());
                ppaction = new PreprocessorAction(tokensConsumed, (List)Lists.newArrayList((Object[])new Trivia[]{Trivia.createSkippedText(tokens.subList(0, tokensConsumed))}), replTokens);
            }
        }
        return ppaction;
    }

    public String expandFunctionLikeMacro(String macroName, List<Token> restTokens) {
        LinkedList<Token> expansion = new LinkedList<Token>();
        this.expandFunctionLikeMacro(macroName, restTokens, expansion);
        return this.serialize(expansion);
    }

    private int expandFunctionLikeMacro(String macroName, List<Token> restTokens, List<Token> expansion) {
        List<Token> replTokens = null;
        ArrayList<Token> arguments = new ArrayList<Token>();
        int tokensConsumedMatchingArgs = this.matchArguments(restTokens, arguments);
        Macro macro = this.macros.get(macroName);
        if (macro != null && macro.params.size() == arguments.size()) {
            replTokens = this.replaceParams(macro.body, macro.params, arguments);
            replTokens = this.evaluateHashhashOperators(replTokens);
            expansion.addAll(this.expandMacro(macro.name, this.serialize(replTokens)));
        }
        return tokensConsumedMatchingArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Token> expandMacro(String macroName, String macroExpression) {
        List<Token> tokens = null;
        this.macros.disable(macroName);
        try {
            tokens = this.stripEOF(CxxLexer.create(this).lex(macroExpression));
        }
        finally {
            this.macros.enable(macroName);
        }
        return tokens;
    }

    private List<Token> stripEOF(List<Token> tokens) {
        if (tokens.get(tokens.size() - 1).getType() == GenericTokenType.EOF) {
            return tokens.subList(0, tokens.size() - 1);
        }
        return tokens;
    }

    private String serialize(List<Token> tokens) {
        return this.serialize(tokens, " ");
    }

    private String serialize(List<Token> tokens, String spacer) {
        LinkedList<String> values = new LinkedList<String>();
        for (Token t : tokens) {
            values.add(t.getValue());
        }
        return StringUtils.join(values, (String)spacer);
    }

    /*
     * Unable to fully structure code
     */
    private int matchArguments(List<Token> tokens, List<Token> arguments) {
        rest = tokens;
        try {
            rest = this.match(rest, "(");
        }
        catch (MismatchException me) {
            return 0;
        }
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                rest = this.matchArgument(rest, arguments);
                try {
                    rest = this.match(rest, ",");
                    continue;
                }
                catch (MismatchException me) {
                    rest = this.match(rest, ")");
                }
                break;
            }
        }
        catch (MismatchException me) {
            CxxPreprocessor.LOG.error(me.toString());
            return 0;
        }
        {
            ** while (true)
        }
        return tokens.size() - rest.size();
    }

    private List<Token> match(List<Token> tokens, String str) throws MismatchException {
        if (!tokens.get(0).getValue().equals(str)) {
            throw new MismatchException("Mismatch: expected '" + str + "' got: '" + tokens.get(0).getValue() + "'");
        }
        return tokens.subList(1, tokens.size());
    }

    private List<Token> matchArgument(List<Token> tokens, List<Token> arguments) throws MismatchException {
        Token firstToken;
        int nestingLevel = 0;
        int tokensConsumed = 0;
        int noTokens = tokens.size();
        Token currToken = firstToken = tokens.get(0);
        String curr = currToken.getValue();
        LinkedList<Token> matchedTokens = new LinkedList<Token>();
        while (true) {
            if (nestingLevel == 0 && (",".equals(curr) || ")".equals(curr))) {
                if (tokensConsumed > 0) {
                    arguments.add(Token.builder().setLine(firstToken.getLine()).setColumn(firstToken.getColumn()).setURI(firstToken.getURI()).setValueAndOriginalValue(this.serialize(matchedTokens)).setType((TokenType)CxxTokenType.STRING).build());
                }
                return tokens.subList(tokensConsumed, noTokens);
            }
            if (curr.equals("(")) {
                ++nestingLevel;
            } else if (curr.equals(")")) {
                --nestingLevel;
            }
            if (++tokensConsumed == noTokens) {
                throw new MismatchException("reached the end of the stream while matching a macro argument");
            }
            matchedTokens.add(currToken);
            currToken = tokens.get(tokensConsumed);
            curr = currToken.getValue();
        }
    }

    private List<Token> replaceParams(List<Token> body, List<Token> parameters, List<Token> arguments) {
        ArrayList<Token> newTokens = new ArrayList<Token>();
        if (body.size() != 0) {
            ArrayList<String> defParamValues = new ArrayList<String>();
            for (Token t : parameters) {
                defParamValues.add(t.getValue());
            }
            for (int i = 0; i < body.size(); ++i) {
                Token curr = body.get(i);
                int index = defParamValues.indexOf(curr.getValue());
                if (index != -1) {
                    Token replacement = arguments.get(index);
                    String newValue = replacement.getValue();
                    if (i > 0 && body.get(i - 1).getValue().equals("#")) {
                        newTokens.remove(newTokens.size() - 1);
                        newValue = this.encloseWithQuotes(this.quote(newValue));
                    }
                    newTokens.add(Token.builder().setLine(replacement.getLine()).setColumn(replacement.getColumn()).setURI(replacement.getURI()).setValueAndOriginalValue(newValue).setType(replacement.getType()).setGeneratedCode(true).build());
                    continue;
                }
                newTokens.add(curr);
            }
        }
        return newTokens;
    }

    private List<Token> evaluateHashhashOperators(List<Token> tokens) {
        ArrayList<Token> newTokens = new ArrayList<Token>();
        Iterator<Token> it = tokens.iterator();
        while (it.hasNext()) {
            Token curr = it.next();
            if (curr.getValue().equals("##")) {
                Token pred = this.predConcatToken(newTokens);
                Token succ = this.succConcatToken(it);
                newTokens.add(Token.builder().setLine(pred.getLine()).setColumn(pred.getColumn()).setURI(pred.getURI()).setValueAndOriginalValue(pred.getValue() + succ.getValue()).setType(pred.getType()).setGeneratedCode(true).build());
                continue;
            }
            newTokens.add(curr);
        }
        return newTokens;
    }

    private Token predConcatToken(List<Token> tokens) {
        while (!tokens.isEmpty()) {
            Token last = tokens.remove(tokens.size() - 1);
            if (last.getType() == CxxTokenType.WS) continue;
            return last;
        }
        return null;
    }

    private Token succConcatToken(Iterator<Token> it) {
        Token succ = null;
        while (it.hasNext() && ((succ = it.next()).getValue().equals("##") || succ.getType() == CxxTokenType.WS)) {
        }
        return succ;
    }

    private String quote(String str) {
        return StringUtils.replaceEach((String)str, (String[])new String[]{"\\", "\""}, (String[])new String[]{"\\\\", "\\\""});
    }

    private String encloseWithQuotes(String str) {
        return "\"" + str + "\"";
    }

    private List<Token> reallocate(List<Token> tokens, Token token) {
        LinkedList<Token> reallocated = new LinkedList<Token>();
        int currColumn = token.getColumn();
        for (Token t : tokens) {
            reallocated.add(Token.builder().setLine(token.getLine()).setColumn(currColumn).setURI(token.getURI()).setValueAndOriginalValue(t.getValue()).setType(t.getType()).setGeneratedCode(true).build());
            currColumn += t.getValue().length() + 1;
        }
        return reallocated;
    }

    private Macro parseMacroDefinition(String macroDef) {
        return this.parseMacroDefinition(this.pplineParser.parse(macroDef).findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).defineLine}));
    }

    private Macro parseMacroDefinition(AstNode defineLineAst) {
        AstNode ast = defineLineAst.getChild(0);
        AstNode nameNode = ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).ppToken});
        String macroName = nameNode.getTokenValue();
        AstNode paramList = ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).parameterList});
        LinkedList<Token> macroParams = paramList == null ? (ast.getName().equals("objectlikeMacroDefinition") ? null : new LinkedList<Token>()) : this.getParams(paramList);
        AstNode replList = ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).replacementList});
        LinkedList<Token> macroBody = replList == null ? new LinkedList<Token>() : replList.getTokens().subList(0, replList.getTokens().size() - 1);
        return new Macro(macroName, macroParams, macroBody);
    }

    private List<Token> getParams(AstNode identListAst) {
        ArrayList<Token> params = new ArrayList<Token>();
        if (identListAst != null) {
            for (AstNode node : identListAst.findDirectChildren(new AstNodeType[]{GenericTokenType.IDENTIFIER})) {
                params.add(node.getToken());
            }
        }
        return params;
    }

    private File findIncludedFile(AstNode ast, Token token, String currFileName) {
        String includedFileName = null;
        File includedFile = null;
        boolean quoted = false;
        AstNode node = ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).includeBodyQuoted});
        if (node != null) {
            includedFileName = this.stripQuotes(node.getFirstChild().getTokenValue());
            quoted = true;
        } else {
            node = ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).includeBodyBracketed});
            if (node != null) {
                String value;
                node = node.findFirstChild(new AstNodeType[]{CppPunctuator.LT}).nextSibling();
                StringBuilder sb = new StringBuilder();
                while (!(value = node.getTokenValue()).equals(">")) {
                    sb.append(value);
                    node = node.nextSibling();
                }
                includedFileName = sb.toString();
            } else {
                node = ast.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).includeBodyFreeform});
                if (node != null) {
                    String includeBody = this.serialize(this.stripEOF(node.getTokens()), "");
                    String expandedIncludeBody = this.serialize(this.stripEOF(CxxLexer.create(this).lex(includeBody)), "");
                    boolean parseError = false;
                    AstNode includeBodyAst = null;
                    try {
                        includeBodyAst = this.pplineParser.parse("#include " + expandedIncludeBody);
                    }
                    catch (RecognitionException re) {
                        parseError = true;
                    }
                    if (parseError || includeBodyAst.findFirstChild(new AstNodeType[]{((CppGrammar)this.pplineParser.getGrammar()).includeBodyFreeform}) != null) {
                        LOG.warn("[{}:{}]: cannot parse included filename: {}'", new Object[]{currFileName, token.getLine(), expandedIncludeBody});
                        return null;
                    }
                    return this.findIncludedFile(includeBodyAst, token, currFileName);
                }
            }
        }
        if (includedFileName != null) {
            File file = this.getFileUnderAnalysis();
            String dir = file == null ? "" : file.getParent();
            includedFile = this.codeProvider.getSourceCodeFile(includedFileName, dir, quoted);
        }
        return includedFile;
    }

    private String getMacroName(AstNode ast) {
        return ast.findFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER}).getTokenValue();
    }

    private String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }

    private File getFileUnderAnalysis() {
        if (this.state.includeUnderAnalysis == null) {
            return this.context.getFile();
        }
        return this.state.includeUnderAnalysis;
    }

    private boolean inSkippingMode() {
        return this.state.skipping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Macro {
        public String name;
        public List<Token> params;
        public List<Token> body;

        public Macro(String name, List<Token> params, List<Token> body) {
            this.name = name;
            this.params = params;
            this.body = body;
        }

        public String toString() {
            return this.name + (this.params == null ? "" : "(" + CxxPreprocessor.this.serialize(this.params, ", ") + ")") + " -> '" + CxxPreprocessor.this.serialize(this.body) + "'";
        }
    }

    static class MismatchException
    extends Exception {
        private String why;

        MismatchException(String why) {
            this.why = why;
        }

        public String toString() {
            return this.why;
        }
    }

    private class State {
        public boolean skipping;
        public int nestedIfdefs;
        public File includeUnderAnalysis;

        public State(File includeUnderAnalysis) {
            this.reset();
            this.includeUnderAnalysis = includeUnderAnalysis;
        }

        public final void reset() {
            this.skipping = false;
            this.nestedIfdefs = 0;
            this.includeUnderAnalysis = null;
        }
    }
}

