/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.preprocessor;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Parser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.cxx.CxxConfiguration;
import org.sonar.cxx.preprocessor.CppGrammar;
import org.sonar.cxx.preprocessor.CppParser;
import org.sonar.cxx.preprocessor.CxxPreprocessor;
import org.sonar.cxx.preprocessor.EvaluationException;

public final class ExpressionEvaluator {
    public static final Logger LOG = LoggerFactory.getLogger((String)"Evaluator");
    private Parser<CppGrammar> parser;
    private CxxPreprocessor preprocessor;

    public ExpressionEvaluator(CxxConfiguration conf, CxxPreprocessor preprocessor) {
        this.parser = CppParser.createConstantExpressionParser(conf);
        this.preprocessor = preprocessor;
    }

    public boolean eval(String constExpr) {
        return this.evalToInt(constExpr) != 0L;
    }

    public boolean eval(AstNode constExpr) {
        return this.evalToInt(constExpr) != 0L;
    }

    private long evalToInt(String constExpr) {
        AstNode constExprAst = null;
        try {
            constExprAst = this.parser.parse(constExpr);
        }
        catch (RecognitionException re) {
            LOG.warn("Error evaluating expression '{}', assuming 0", (Object)constExpr);
            return 0L;
        }
        return this.evalToInt(constExprAst);
    }

    private long evalToInt(AstNode exprAst) {
        LOG.trace("Evaluating expression: {}", (Object)exprAst);
        int noChildren = exprAst.getNumberOfChildren();
        if (noChildren == 0) {
            return this.evalLeaf(exprAst);
        }
        if (noChildren == 1) {
            return this.evalOneChildAst(exprAst);
        }
        return this.evalComplexAst(exprAst);
    }

    private long evalLeaf(AstNode exprAst) {
        String nodeType = exprAst.getName();
        if ("NUMBER".equals(nodeType)) {
            return this.evalNumber(exprAst.getTokenValue());
        }
        if ("CHARACTER".equals(nodeType)) {
            return this.evalCharacter(exprAst.getTokenValue());
        }
        if ("IDENTIFIER".equals(nodeType)) {
            String value = this.preprocessor.valueOf(exprAst.getTokenValue());
            return value == null ? 0L : this.evalToInt(value);
        }
        throw new EvaluationException("Unknown expression type '" + nodeType + "'");
    }

    private long evalOneChildAst(AstNode exprAst) {
        String nodeType = exprAst.getName();
        if ("bool".equals(nodeType)) {
            return this.evalBool(exprAst.getTokenValue());
        }
        return this.evalToInt(exprAst.getChild(0));
    }

    private long evalComplexAst(AstNode exprAst) {
        String nodeType = exprAst.getName();
        if ("unaryExpression".equals(nodeType)) {
            return this.evalUnaryExpression(exprAst);
        }
        if ("conditionalExpression".equals(nodeType)) {
            return this.evalConditionalExpression(exprAst);
        }
        if ("logicalOrExpression".equals(nodeType)) {
            return this.evalLogicalOrExpression(exprAst);
        }
        if ("logicalAndExpression".equals(nodeType)) {
            return this.evalLogicalAndExpression(exprAst);
        }
        if ("inclusiveOrExpression".equals(nodeType)) {
            return this.evalInclusiveOrExpression(exprAst);
        }
        if ("exclusiveOrExpression".equals(nodeType)) {
            return this.evalExclusiveOrExpression(exprAst);
        }
        if ("andExpression".equals(nodeType)) {
            return this.evalAndExpression(exprAst);
        }
        if ("equalityExpression".equals(nodeType)) {
            return this.evalEqualityExpression(exprAst);
        }
        if ("relationalExpression".equals(nodeType)) {
            return this.evalRelationalExpression(exprAst);
        }
        if ("shiftExpression".equals(nodeType)) {
            return this.evalShiftExpression(exprAst);
        }
        if ("additiveExpression".equals(nodeType)) {
            return this.evalAdditiveExpression(exprAst);
        }
        if ("multiplicativeExpression".equals(nodeType)) {
            return this.evalMultiplicativeExpression(exprAst);
        }
        if ("primaryExpression".equals(nodeType)) {
            return this.evalPrimaryExpression(exprAst);
        }
        if ("definedExpression".equals(nodeType)) {
            return this.evalDefinedExpression(exprAst);
        }
        if ("functionlikeMacro".equals(nodeType)) {
            return this.evalFunctionlikeMacro(exprAst);
        }
        throw new EvaluationException("Unknown expression type '" + nodeType + "'");
    }

    long evalBool(String boolValue) {
        return boolValue.equalsIgnoreCase("true") ? 1L : 0L;
    }

    long evalNumber(String intValue) {
        long number = 0L;
        try {
            number = Long.decode(this.stripSuffix(intValue));
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Cannot decode the number '{}' falling back to max long ({}) instead", (Object)intValue, (Object)Long.MAX_VALUE);
            number = Long.MAX_VALUE;
        }
        return number;
    }

    long evalCharacter(String charValue) {
        return charValue.equals("'\u0000'") ? 0L : 1L;
    }

    long evalLogicalOrExpression(AstNode exprAst) {
        int noChildren = exprAst.getNumberOfChildren();
        boolean result = this.eval(exprAst.getChild(0));
        for (int i = 2; i < noChildren && !result; i += 2) {
            AstNode operand = exprAst.getChild(i);
            result = result || this.eval(operand);
        }
        return result ? 1L : 0L;
    }

    long evalLogicalAndExpression(AstNode exprAst) {
        int noChildren = exprAst.getNumberOfChildren();
        boolean result = this.eval(exprAst.getChild(0));
        for (int i = 2; i < noChildren && result; i += 2) {
            AstNode operand = exprAst.getChild(i);
            result = result && this.eval(operand);
        }
        return result ? 1L : 0L;
    }

    long evalEqualityExpression(AstNode exprAst) {
        boolean result;
        String operator = exprAst.getChild(1).getTokenValue();
        AstNode lhs = exprAst.getChild(0);
        AstNode rhs = exprAst.getChild(2);
        if (operator.equals("==")) {
            result = this.evalToInt(lhs) == this.evalToInt(rhs);
        } else if (operator.equals("!=")) {
            result = this.evalToInt(lhs) != this.evalToInt(rhs);
        } else {
            throw new EvaluationException("Unknown equality operator '" + operator + "'");
        }
        int noChildren = exprAst.getNumberOfChildren();
        for (int i = 4; i < noChildren; i += 2) {
            operator = exprAst.getChild(i - 1).getTokenValue();
            rhs = exprAst.getChild(i);
            if (operator.equals("==")) {
                result = result == this.eval(rhs);
                continue;
            }
            if (operator.equals("!=")) {
                result = result != this.eval(rhs);
                continue;
            }
            throw new EvaluationException("Unknown equality operator '" + operator + "'");
        }
        return result ? 1L : 0L;
    }

    long evalRelationalExpression(AstNode exprAst) {
        boolean result;
        String operator = exprAst.getChild(1).getTokenValue();
        AstNode lhs = exprAst.getChild(0);
        AstNode rhs = exprAst.getChild(2);
        if (operator.equals("<")) {
            result = this.evalToInt(lhs) < this.evalToInt(rhs);
        } else if (operator.equals(">")) {
            result = this.evalToInt(lhs) > this.evalToInt(rhs);
        } else if (operator.equals("<=")) {
            result = this.evalToInt(lhs) <= this.evalToInt(rhs);
        } else if (operator.equals(">=")) {
            result = this.evalToInt(lhs) >= this.evalToInt(rhs);
        } else {
            throw new EvaluationException("Unknown relational operator '" + operator + "'");
        }
        int noChildren = exprAst.getNumberOfChildren();
        for (int i = 4; i < noChildren; i += 2) {
            int resultAsInt;
            operator = exprAst.getChild(i - 1).getTokenValue();
            rhs = exprAst.getChild(i);
            int n = resultAsInt = result ? 1 : 0;
            if (operator.equals("<")) {
                result = (long)resultAsInt < this.evalToInt(rhs);
                continue;
            }
            if (operator.equals(">")) {
                result = (long)resultAsInt > this.evalToInt(rhs);
                continue;
            }
            if (operator.equals("<=")) {
                result = (long)resultAsInt <= this.evalToInt(rhs);
                continue;
            }
            if (operator.equals(">=")) {
                result = (long)resultAsInt >= this.evalToInt(rhs);
                continue;
            }
            throw new EvaluationException("Unknown relational operator '" + operator + "'");
        }
        return result ? 1L : 0L;
    }

    long evalAndExpression(AstNode exprAst) {
        int noChildren = exprAst.getNumberOfChildren();
        long result = this.evalToInt(exprAst.getChild(0));
        for (int i = 2; i < noChildren; i += 2) {
            AstNode operand = exprAst.getChild(i);
            result &= this.evalToInt(operand);
        }
        return result;
    }

    long evalInclusiveOrExpression(AstNode exprAst) {
        int noChildren = exprAst.getNumberOfChildren();
        long result = this.evalToInt(exprAst.getChild(0));
        for (int i = 2; i < noChildren; i += 2) {
            AstNode operand = exprAst.getChild(i);
            result |= this.evalToInt(operand);
        }
        return result;
    }

    long evalExclusiveOrExpression(AstNode exprAst) {
        int noChildren = exprAst.getNumberOfChildren();
        long result = this.evalToInt(exprAst.getChild(0));
        for (int i = 2; i < noChildren; i += 2) {
            AstNode operand = exprAst.getChild(i);
            result ^= this.evalToInt(operand);
        }
        return result;
    }

    long evalUnaryExpression(AstNode exprAst) {
        String operator = exprAst.getChild(0).getTokenValue();
        AstNode operand = exprAst.getChild(1);
        if (operator.equals("+")) {
            return this.evalToInt(operand);
        }
        if (operator.equals("-")) {
            return -this.evalToInt(operand);
        }
        if (operator.equals("!")) {
            boolean result = !this.eval(operand);
            return result ? 1L : 0L;
        }
        if (operator.equals("~")) {
            return this.evalToInt(operand) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        throw new EvaluationException("Unknown unary operator  '" + operator + "'");
    }

    long evalShiftExpression(AstNode exprAst) {
        long result = this.evalToInt(exprAst.getChild(0));
        int noChildren = exprAst.getNumberOfChildren();
        for (int i = 2; i < noChildren; i += 2) {
            String operator = exprAst.getChild(i - 1).getTokenValue();
            AstNode rhs = exprAst.getChild(i);
            if (operator.equals("<<")) {
                result <<= (int)this.evalToInt(rhs);
                continue;
            }
            if (operator.equals(">>")) {
                result >>= (int)this.evalToInt(rhs);
                continue;
            }
            throw new EvaluationException("Unknown shift operator '" + operator + "'");
        }
        return result;
    }

    long evalAdditiveExpression(AstNode exprAst) {
        long result = this.evalToInt(exprAst.getChild(0));
        int noChildren = exprAst.getNumberOfChildren();
        for (int i = 2; i < noChildren; i += 2) {
            String operator = exprAst.getChild(i - 1).getTokenValue();
            AstNode rhs = exprAst.getChild(i);
            if (operator.equals("+")) {
                result += this.evalToInt(rhs);
                continue;
            }
            if (operator.equals("-")) {
                result -= this.evalToInt(rhs);
                continue;
            }
            throw new EvaluationException("Unknown additive operator '" + operator + "'");
        }
        return result;
    }

    long evalMultiplicativeExpression(AstNode exprAst) {
        long result = this.evalToInt(exprAst.getChild(0));
        int noChildren = exprAst.getNumberOfChildren();
        for (int i = 2; i < noChildren; i += 2) {
            String operator = exprAst.getChild(i - 1).getTokenValue();
            AstNode rhs = exprAst.getChild(i);
            if (operator.equals("*")) {
                result *= this.evalToInt(rhs);
                continue;
            }
            if (operator.equals("/")) {
                result /= this.evalToInt(rhs);
                continue;
            }
            if (operator.equals("%")) {
                result %= this.evalToInt(rhs);
                continue;
            }
            throw new EvaluationException("Unknown multiplicative operator '" + operator + "'");
        }
        return result;
    }

    long evalConditionalExpression(AstNode exprAst) {
        AstNode decisionOperand = exprAst.getChild(0);
        AstNode trueCaseOperand = exprAst.getChild(2);
        AstNode falseCaseOperand = exprAst.getChild(4);
        return this.eval(decisionOperand) ? this.evalToInt(trueCaseOperand) : this.evalToInt(falseCaseOperand);
    }

    long evalPrimaryExpression(AstNode exprAst) {
        return this.evalToInt(exprAst.getChild(1));
    }

    long evalDefinedExpression(AstNode exprAst) {
        int posOfMacroName = exprAst.getNumberOfChildren() == 2 ? 1 : 2;
        String macroName = exprAst.getChild(posOfMacroName).getTokenValue();
        String value = this.preprocessor.valueOf(macroName);
        LOG.trace("expanding '{}' to '{}'", (Object)macroName, (Object)value);
        return value == null ? 0L : 1L;
    }

    long evalFunctionlikeMacro(AstNode exprAst) {
        String macroName = exprAst.getChild(0).getTokenValue();
        List tokens = exprAst.getTokens();
        List<Token> restTokens = tokens.subList(1, tokens.size());
        String value = this.preprocessor.expandFunctionLikeMacro(macroName, restTokens);
        LOG.trace("expanding '{}' to '{}'", (Object)macroName, (Object)value);
        if (value == null) {
            LOG.warn("Undefined functionlike macro '{}' assuming 0", (Object)macroName);
        }
        return value == null ? 0L : this.evalToInt(value);
    }

    String stripSuffix(String number) {
        return number.replaceAll("[LlUu]", "");
    }
}

