/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.preprocessor;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.Preprocessor;
import com.sonar.sslr.api.PreprocessorAction;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.cxx.api.CxxTokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinStringsPreprocessor
extends Preprocessor {
    public PreprocessorAction process(List<Token> tokens) {
        Token token = tokens.get(0);
        if (token.getType() == CxxTokenType.STRING) {
            Token nextToken;
            int numberOfStrings = 1;
            StringBuilder sb = new StringBuilder();
            while ((nextToken = tokens.get(numberOfStrings)).getType() == CxxTokenType.STRING) {
                sb.append(this.stripQuotes(nextToken.getValue()));
                ++numberOfStrings;
            }
            if (numberOfStrings > 1) {
                ArrayList tokensToInject = Lists.newArrayList();
                tokensToInject.add(Token.builder().setLine(token.getLine()).setColumn(token.getColumn()).setURI(token.getURI()).setType((TokenType)CxxTokenType.STRING).setValueAndOriginalValue("\"" + this.stripQuotes(token.getValue()) + sb.toString() + "\"").build());
                return new PreprocessorAction(numberOfStrings, Collections.EMPTY_LIST, (List)tokensToInject);
            }
            return PreprocessorAction.NO_OPERATION;
        }
        return PreprocessorAction.NO_OPERATION;
    }

    private String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }
}

